/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrdersRefundItemRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrdersRefundItemRequest extends com.google.api.client.json.GenericJson {

  /**
   * The items that are refunded. Either Item or Shipping must be provided in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrdersCustomBatchRequestEntryRefundItemItem> items;

  static {
    // hack to force ProGuard to consider OrdersCustomBatchRequestEntryRefundItemItem used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(OrdersCustomBatchRequestEntryRefundItemItem.class);
  }

  /**
   * The ID of the operation. Unique across all operations for a given order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operationId;

  /**
   * The reason for the refund.
   *
   * Acceptable values are:   - "`shippingCostAdjustment`"  - "`priceAdjustment`"  -
   * "`taxAdjustment`"  - "`feeAdjustment`"  - "`courtesyAdjustment`"  - "`adjustment`"  -
   * "`customerCancelled`"  - "`noInventory`"  - "`productNotAsDescribed`"  -
   * "`undeliverableShippingAddress`"  - "`wrongProductShipped`"  - "`lateShipmentCredit`"  -
   * "`deliveredLateByCarrier`"  - "`productArrivedDamaged`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * The explanation of the reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reasonText;

  /**
   * The refund on shipping. Optional, but either Item or Shipping must be provided in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrdersCustomBatchRequestEntryRefundItemShipping shipping;

  /**
   * The items that are refunded. Either Item or Shipping must be provided in the request.
   * @return value or {@code null} for none
   */
  public java.util.List<OrdersCustomBatchRequestEntryRefundItemItem> getItems() {
    return items;
  }

  /**
   * The items that are refunded. Either Item or Shipping must be provided in the request.
   * @param items items or {@code null} for none
   */
  public OrdersRefundItemRequest setItems(java.util.List<OrdersCustomBatchRequestEntryRefundItemItem> items) {
    this.items = items;
    return this;
  }

  /**
   * The ID of the operation. Unique across all operations for a given order.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperationId() {
    return operationId;
  }

  /**
   * The ID of the operation. Unique across all operations for a given order.
   * @param operationId operationId or {@code null} for none
   */
  public OrdersRefundItemRequest setOperationId(java.lang.String operationId) {
    this.operationId = operationId;
    return this;
  }

  /**
   * The reason for the refund.
   *
   * Acceptable values are:   - "`shippingCostAdjustment`"  - "`priceAdjustment`"  -
   * "`taxAdjustment`"  - "`feeAdjustment`"  - "`courtesyAdjustment`"  - "`adjustment`"  -
   * "`customerCancelled`"  - "`noInventory`"  - "`productNotAsDescribed`"  -
   * "`undeliverableShippingAddress`"  - "`wrongProductShipped`"  - "`lateShipmentCredit`"  -
   * "`deliveredLateByCarrier`"  - "`productArrivedDamaged`"
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * The reason for the refund.
   *
   * Acceptable values are:   - "`shippingCostAdjustment`"  - "`priceAdjustment`"  -
   * "`taxAdjustment`"  - "`feeAdjustment`"  - "`courtesyAdjustment`"  - "`adjustment`"  -
   * "`customerCancelled`"  - "`noInventory`"  - "`productNotAsDescribed`"  -
   * "`undeliverableShippingAddress`"  - "`wrongProductShipped`"  - "`lateShipmentCredit`"  -
   * "`deliveredLateByCarrier`"  - "`productArrivedDamaged`"
   * @param reason reason or {@code null} for none
   */
  public OrdersRefundItemRequest setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The explanation of the reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getReasonText() {
    return reasonText;
  }

  /**
   * The explanation of the reason.
   * @param reasonText reasonText or {@code null} for none
   */
  public OrdersRefundItemRequest setReasonText(java.lang.String reasonText) {
    this.reasonText = reasonText;
    return this;
  }

  /**
   * The refund on shipping. Optional, but either Item or Shipping must be provided in the request.
   * @return value or {@code null} for none
   */
  public OrdersCustomBatchRequestEntryRefundItemShipping getShipping() {
    return shipping;
  }

  /**
   * The refund on shipping. Optional, but either Item or Shipping must be provided in the request.
   * @param shipping shipping or {@code null} for none
   */
  public OrdersRefundItemRequest setShipping(OrdersCustomBatchRequestEntryRefundItemShipping shipping) {
    this.shipping = shipping;
    return this;
  }

  @Override
  public OrdersRefundItemRequest set(String fieldName, Object value) {
    return (OrdersRefundItemRequest) super.set(fieldName, value);
  }

  @Override
  public OrdersRefundItemRequest clone() {
    return (OrdersRefundItemRequest) super.clone();
  }

}
