/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for ProductShipping.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductShipping extends com.google.api.client.json.GenericJson {

  /**
   * The CLDR territory code of the country to which an item will ship.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * The location where the shipping is applicable, represented by a location group name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationGroupName;

  /**
   * The numeric ID of a location that the shipping rate applies to as defined in the AdWords API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long locationId;

  /**
   * The postal code range that the shipping rate applies to, represented by a postal code, a postal
   * code prefix followed by a * wildcard, a range between two postal codes or two postal code
   * prefixes of equal length.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String postalCode;

  /**
   * Fixed shipping price, represented as a number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price price;

  /**
   * The geographic region to which a shipping rate applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * A free-form description of the service class or delivery speed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String service;

  /**
   * The CLDR territory code of the country to which an item will ship.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * The CLDR territory code of the country to which an item will ship.
   * @param country country or {@code null} for none
   */
  public ProductShipping setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * The location where the shipping is applicable, represented by a location group name.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationGroupName() {
    return locationGroupName;
  }

  /**
   * The location where the shipping is applicable, represented by a location group name.
   * @param locationGroupName locationGroupName or {@code null} for none
   */
  public ProductShipping setLocationGroupName(java.lang.String locationGroupName) {
    this.locationGroupName = locationGroupName;
    return this;
  }

  /**
   * The numeric ID of a location that the shipping rate applies to as defined in the AdWords API.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLocationId() {
    return locationId;
  }

  /**
   * The numeric ID of a location that the shipping rate applies to as defined in the AdWords API.
   * @param locationId locationId or {@code null} for none
   */
  public ProductShipping setLocationId(java.lang.Long locationId) {
    this.locationId = locationId;
    return this;
  }

  /**
   * The postal code range that the shipping rate applies to, represented by a postal code, a postal
   * code prefix followed by a * wildcard, a range between two postal codes or two postal code
   * prefixes of equal length.
   * @return value or {@code null} for none
   */
  public java.lang.String getPostalCode() {
    return postalCode;
  }

  /**
   * The postal code range that the shipping rate applies to, represented by a postal code, a postal
   * code prefix followed by a * wildcard, a range between two postal codes or two postal code
   * prefixes of equal length.
   * @param postalCode postalCode or {@code null} for none
   */
  public ProductShipping setPostalCode(java.lang.String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

  /**
   * Fixed shipping price, represented as a number.
   * @return value or {@code null} for none
   */
  public Price getPrice() {
    return price;
  }

  /**
   * Fixed shipping price, represented as a number.
   * @param price price or {@code null} for none
   */
  public ProductShipping setPrice(Price price) {
    this.price = price;
    return this;
  }

  /**
   * The geographic region to which a shipping rate applies.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * The geographic region to which a shipping rate applies.
   * @param region region or {@code null} for none
   */
  public ProductShipping setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * A free-form description of the service class or delivery speed.
   * @return value or {@code null} for none
   */
  public java.lang.String getService() {
    return service;
  }

  /**
   * A free-form description of the service class or delivery speed.
   * @param service service or {@code null} for none
   */
  public ProductShipping setService(java.lang.String service) {
    this.service = service;
    return this;
  }

  @Override
  public ProductShipping set(String fieldName, Object value) {
    return (ProductShipping) super.set(fieldName, value);
  }

  @Override
  public ProductShipping clone() {
    return (ProductShipping) super.clone();
  }

}
