/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Return address resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReturnAddress extends com.google.api.client.json.GenericJson {

  /**
   * Required. The address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReturnAddressAddress address;

  /**
   * Required. The country of sale where the return address is applicable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#returnAddress`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Required. The user-defined label of the return address. For the default address, use the label
   * "default".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * Required. The merchant's contact phone number regarding the return.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneNumber;

  /**
   * Return address ID generated by Google.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String returnAddressId;

  /**
   * Required. The address.
   * @return value or {@code null} for none
   */
  public ReturnAddressAddress getAddress() {
    return address;
  }

  /**
   * Required. The address.
   * @param address address or {@code null} for none
   */
  public ReturnAddress setAddress(ReturnAddressAddress address) {
    this.address = address;
    return this;
  }

  /**
   * Required. The country of sale where the return address is applicable.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * Required. The country of sale where the return address is applicable.
   * @param country country or {@code null} for none
   */
  public ReturnAddress setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#returnAddress`"
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#returnAddress`"
   * @param kind kind or {@code null} for none
   */
  public ReturnAddress setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Required. The user-defined label of the return address. For the default address, use the label
   * "default".
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * Required. The user-defined label of the return address. For the default address, use the label
   * "default".
   * @param label label or {@code null} for none
   */
  public ReturnAddress setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * Required. The merchant's contact phone number regarding the return.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * Required. The merchant's contact phone number regarding the return.
   * @param phoneNumber phoneNumber or {@code null} for none
   */
  public ReturnAddress setPhoneNumber(java.lang.String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Return address ID generated by Google.
   * @return value or {@code null} for none
   */
  public java.lang.String getReturnAddressId() {
    return returnAddressId;
  }

  /**
   * Return address ID generated by Google.
   * @param returnAddressId returnAddressId or {@code null} for none
   */
  public ReturnAddress setReturnAddressId(java.lang.String returnAddressId) {
    this.returnAddressId = returnAddressId;
    return this;
  }

  @Override
  public ReturnAddress set(String fieldName, Object value) {
    return (ReturnAddress) super.set(fieldName, value);
  }

  @Override
  public ReturnAddress clone() {
    return (ReturnAddress) super.clone();
  }

}
