/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Return policy resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReturnPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Required. The country of sale where the return policy is applicable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#returnPolicy`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Required. The user-defined label of the return policy. For the default policy, use the label
   * "default".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * Required. The name of the policy as shown in Merchant Center.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Return reasons that will incur return fees.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> nonFreeReturnReasons;

  /**
   * Required. The policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReturnPolicyPolicy policy;

  /**
   * Return policy ID generated by Google.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String returnPolicyId;

  /**
   * An optional list of seasonal overrides.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ReturnPolicySeasonalOverride> seasonalOverrides;

  /**
   * Required. The country of sale where the return policy is applicable.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * Required. The country of sale where the return policy is applicable.
   * @param country country or {@code null} for none
   */
  public ReturnPolicy setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#returnPolicy`"
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "`content#returnPolicy`"
   * @param kind kind or {@code null} for none
   */
  public ReturnPolicy setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Required. The user-defined label of the return policy. For the default policy, use the label
   * "default".
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * Required. The user-defined label of the return policy. For the default policy, use the label
   * "default".
   * @param label label or {@code null} for none
   */
  public ReturnPolicy setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * Required. The name of the policy as shown in Merchant Center.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The name of the policy as shown in Merchant Center.
   * @param name name or {@code null} for none
   */
  public ReturnPolicy setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Return reasons that will incur return fees.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getNonFreeReturnReasons() {
    return nonFreeReturnReasons;
  }

  /**
   * Return reasons that will incur return fees.
   * @param nonFreeReturnReasons nonFreeReturnReasons or {@code null} for none
   */
  public ReturnPolicy setNonFreeReturnReasons(java.util.List<java.lang.String> nonFreeReturnReasons) {
    this.nonFreeReturnReasons = nonFreeReturnReasons;
    return this;
  }

  /**
   * Required. The policy.
   * @return value or {@code null} for none
   */
  public ReturnPolicyPolicy getPolicy() {
    return policy;
  }

  /**
   * Required. The policy.
   * @param policy policy or {@code null} for none
   */
  public ReturnPolicy setPolicy(ReturnPolicyPolicy policy) {
    this.policy = policy;
    return this;
  }

  /**
   * Return policy ID generated by Google.
   * @return value or {@code null} for none
   */
  public java.lang.String getReturnPolicyId() {
    return returnPolicyId;
  }

  /**
   * Return policy ID generated by Google.
   * @param returnPolicyId returnPolicyId or {@code null} for none
   */
  public ReturnPolicy setReturnPolicyId(java.lang.String returnPolicyId) {
    this.returnPolicyId = returnPolicyId;
    return this;
  }

  /**
   * An optional list of seasonal overrides.
   * @return value or {@code null} for none
   */
  public java.util.List<ReturnPolicySeasonalOverride> getSeasonalOverrides() {
    return seasonalOverrides;
  }

  /**
   * An optional list of seasonal overrides.
   * @param seasonalOverrides seasonalOverrides or {@code null} for none
   */
  public ReturnPolicy setSeasonalOverrides(java.util.List<ReturnPolicySeasonalOverride> seasonalOverrides) {
    this.seasonalOverrides = seasonalOverrides;
    return this;
  }

  @Override
  public ReturnPolicy set(String fieldName, Object value) {
    return (ReturnPolicy) super.set(fieldName, value);
  }

  @Override
  public ReturnPolicy clone() {
    return (ReturnPolicy) super.clone();
  }

}
