/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for ReturnShipment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReturnShipment extends com.google.api.client.json.GenericJson {

  /**
   * The date of creation of the shipment, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationDate;

  /**
   * The date of delivery of the shipment, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deliveryDate;

  /**
   * Type of the return method.
   *
   * Acceptable values are:   - "`byMail`"  - "`contactCustomerSupport`"  - "`returnless`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String returnMethodType;

  /**
   * Shipment ID generated by Google.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shipmentId;

  /**
   * Tracking information of the shipment. One return shipment might be handled by several shipping
   * carriers sequentially.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ShipmentTrackingInfo> shipmentTrackingInfos;

  /**
   * The date of shipping of the shipment, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shippingDate;

  /**
   * State of the shipment.
   *
   * Acceptable values are:   - "`completed`"  - "`new`"  - "`shipped`"  - "`undeliverable`"  -
   * "`pending`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * The date of creation of the shipment, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationDate() {
    return creationDate;
  }

  /**
   * The date of creation of the shipment, in ISO 8601 format.
   * @param creationDate creationDate or {@code null} for none
   */
  public ReturnShipment setCreationDate(java.lang.String creationDate) {
    this.creationDate = creationDate;
    return this;
  }

  /**
   * The date of delivery of the shipment, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeliveryDate() {
    return deliveryDate;
  }

  /**
   * The date of delivery of the shipment, in ISO 8601 format.
   * @param deliveryDate deliveryDate or {@code null} for none
   */
  public ReturnShipment setDeliveryDate(java.lang.String deliveryDate) {
    this.deliveryDate = deliveryDate;
    return this;
  }

  /**
   * Type of the return method.
   *
   * Acceptable values are:   - "`byMail`"  - "`contactCustomerSupport`"  - "`returnless`"
   * @return value or {@code null} for none
   */
  public java.lang.String getReturnMethodType() {
    return returnMethodType;
  }

  /**
   * Type of the return method.
   *
   * Acceptable values are:   - "`byMail`"  - "`contactCustomerSupport`"  - "`returnless`"
   * @param returnMethodType returnMethodType or {@code null} for none
   */
  public ReturnShipment setReturnMethodType(java.lang.String returnMethodType) {
    this.returnMethodType = returnMethodType;
    return this;
  }

  /**
   * Shipment ID generated by Google.
   * @return value or {@code null} for none
   */
  public java.lang.String getShipmentId() {
    return shipmentId;
  }

  /**
   * Shipment ID generated by Google.
   * @param shipmentId shipmentId or {@code null} for none
   */
  public ReturnShipment setShipmentId(java.lang.String shipmentId) {
    this.shipmentId = shipmentId;
    return this;
  }

  /**
   * Tracking information of the shipment. One return shipment might be handled by several shipping
   * carriers sequentially.
   * @return value or {@code null} for none
   */
  public java.util.List<ShipmentTrackingInfo> getShipmentTrackingInfos() {
    return shipmentTrackingInfos;
  }

  /**
   * Tracking information of the shipment. One return shipment might be handled by several shipping
   * carriers sequentially.
   * @param shipmentTrackingInfos shipmentTrackingInfos or {@code null} for none
   */
  public ReturnShipment setShipmentTrackingInfos(java.util.List<ShipmentTrackingInfo> shipmentTrackingInfos) {
    this.shipmentTrackingInfos = shipmentTrackingInfos;
    return this;
  }

  /**
   * The date of shipping of the shipment, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getShippingDate() {
    return shippingDate;
  }

  /**
   * The date of shipping of the shipment, in ISO 8601 format.
   * @param shippingDate shippingDate or {@code null} for none
   */
  public ReturnShipment setShippingDate(java.lang.String shippingDate) {
    this.shippingDate = shippingDate;
    return this;
  }

  /**
   * State of the shipment.
   *
   * Acceptable values are:   - "`completed`"  - "`new`"  - "`shipped`"  - "`undeliverable`"  -
   * "`pending`"
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * State of the shipment.
   *
   * Acceptable values are:   - "`completed`"  - "`new`"  - "`shipped`"  - "`undeliverable`"  -
   * "`pending`"
   * @param state state or {@code null} for none
   */
  public ReturnShipment setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  @Override
  public ReturnShipment set(String fieldName, Object value) {
    return (ReturnShipment) super.set(fieldName, value);
  }

  @Override
  public ReturnShipment clone() {
    return (ReturnShipment) super.clone();
  }

}
