/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for ShippingsettingsGetSupportedPickupServicesResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ShippingsettingsGetSupportedPickupServicesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "content#shippingsettingsGetSupportedPickupServicesResponse".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A list of supported pickup services. May be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PickupServicesPickupService> pickupServices;

  static {
    // hack to force ProGuard to consider PickupServicesPickupService used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PickupServicesPickupService.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "content#shippingsettingsGetSupportedPickupServicesResponse".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "content#shippingsettingsGetSupportedPickupServicesResponse".
   * @param kind kind or {@code null} for none
   */
  public ShippingsettingsGetSupportedPickupServicesResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A list of supported pickup services. May be empty.
   * @return value or {@code null} for none
   */
  public java.util.List<PickupServicesPickupService> getPickupServices() {
    return pickupServices;
  }

  /**
   * A list of supported pickup services. May be empty.
   * @param pickupServices pickupServices or {@code null} for none
   */
  public ShippingsettingsGetSupportedPickupServicesResponse setPickupServices(java.util.List<PickupServicesPickupService> pickupServices) {
    this.pickupServices = pickupServices;
    return this;
  }

  @Override
  public ShippingsettingsGetSupportedPickupServicesResponse set(String fieldName, Object value) {
    return (ShippingsettingsGetSupportedPickupServicesResponse) super.set(fieldName, value);
  }

  @Override
  public ShippingsettingsGetSupportedPickupServicesResponse clone() {
    return (ShippingsettingsGetSupportedPickupServicesResponse) super.clone();
  }

}
