/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for TestOrderPickupDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TestOrderPickupDetails extends com.google.api.client.json.GenericJson {

  /**
   * Required. Code of the location defined by provider or merchant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationCode;

  /**
   * Required. Pickup location address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TestOrderAddress pickupLocationAddress;

  /**
   * Pickup location type.
   *
   * Acceptable values are:   - "`locker`"  - "`store`"  - "`curbside`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pickupLocationType;

  /**
   * Required. all pickup persons set by users.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TestOrderPickupDetailsPickupPerson> pickupPersons;

  /**
   * Required. Code of the location defined by provider or merchant.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationCode() {
    return locationCode;
  }

  /**
   * Required. Code of the location defined by provider or merchant.
   * @param locationCode locationCode or {@code null} for none
   */
  public TestOrderPickupDetails setLocationCode(java.lang.String locationCode) {
    this.locationCode = locationCode;
    return this;
  }

  /**
   * Required. Pickup location address.
   * @return value or {@code null} for none
   */
  public TestOrderAddress getPickupLocationAddress() {
    return pickupLocationAddress;
  }

  /**
   * Required. Pickup location address.
   * @param pickupLocationAddress pickupLocationAddress or {@code null} for none
   */
  public TestOrderPickupDetails setPickupLocationAddress(TestOrderAddress pickupLocationAddress) {
    this.pickupLocationAddress = pickupLocationAddress;
    return this;
  }

  /**
   * Pickup location type.
   *
   * Acceptable values are:   - "`locker`"  - "`store`"  - "`curbside`"
   * @return value or {@code null} for none
   */
  public java.lang.String getPickupLocationType() {
    return pickupLocationType;
  }

  /**
   * Pickup location type.
   *
   * Acceptable values are:   - "`locker`"  - "`store`"  - "`curbside`"
   * @param pickupLocationType pickupLocationType or {@code null} for none
   */
  public TestOrderPickupDetails setPickupLocationType(java.lang.String pickupLocationType) {
    this.pickupLocationType = pickupLocationType;
    return this;
  }

  /**
   * Required. all pickup persons set by users.
   * @return value or {@code null} for none
   */
  public java.util.List<TestOrderPickupDetailsPickupPerson> getPickupPersons() {
    return pickupPersons;
  }

  /**
   * Required. all pickup persons set by users.
   * @param pickupPersons pickupPersons or {@code null} for none
   */
  public TestOrderPickupDetails setPickupPersons(java.util.List<TestOrderPickupDetailsPickupPerson> pickupPersons) {
    this.pickupPersons = pickupPersons;
    return this;
  }

  @Override
  public TestOrderPickupDetails set(String fieldName, Object value) {
    return (TestOrderPickupDetails) super.set(fieldName, value);
  }

  @Override
  public TestOrderPickupDetails clone() {
    return (TestOrderPickupDetails) super.clone();
  }

}
