/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for AccountBusinessInformation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountBusinessInformation extends com.google.api.client.json.GenericJson {

  /**
   * The address of the business. Use `\n` to add a second address line.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountAddress address;

  /**
   * The customer service information of the business.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountCustomerService customerService;

  /**
   * The 10-digit [Korean business registration
   * number](https://support.google.com/merchants/answer/9037766) separated with dashes in the
   * format: XXX-XX-XXXXX. This field will only be updated if explicitly set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String koreanBusinessRegistrationNumber;

  /**
   * The phone number of the business. This can only be updated if a verified phone number is not
   * already set. To replace a verified phone number use the `Accounts.requestphoneverification` and
   * `Accounts.verifyphonenumber`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneNumber;

  /**
   * Verification status of the phone number of the business. This status is read only and can be
   * updated only by successful phone verification. Acceptable values are: - "`verified`" -
   * "`unverified`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneVerificationStatus;

  /**
   * The address of the business. Use `\n` to add a second address line.
   * @return value or {@code null} for none
   */
  public AccountAddress getAddress() {
    return address;
  }

  /**
   * The address of the business. Use `\n` to add a second address line.
   * @param address address or {@code null} for none
   */
  public AccountBusinessInformation setAddress(AccountAddress address) {
    this.address = address;
    return this;
  }

  /**
   * The customer service information of the business.
   * @return value or {@code null} for none
   */
  public AccountCustomerService getCustomerService() {
    return customerService;
  }

  /**
   * The customer service information of the business.
   * @param customerService customerService or {@code null} for none
   */
  public AccountBusinessInformation setCustomerService(AccountCustomerService customerService) {
    this.customerService = customerService;
    return this;
  }

  /**
   * The 10-digit [Korean business registration
   * number](https://support.google.com/merchants/answer/9037766) separated with dashes in the
   * format: XXX-XX-XXXXX. This field will only be updated if explicitly set.
   * @return value or {@code null} for none
   */
  public java.lang.String getKoreanBusinessRegistrationNumber() {
    return koreanBusinessRegistrationNumber;
  }

  /**
   * The 10-digit [Korean business registration
   * number](https://support.google.com/merchants/answer/9037766) separated with dashes in the
   * format: XXX-XX-XXXXX. This field will only be updated if explicitly set.
   * @param koreanBusinessRegistrationNumber koreanBusinessRegistrationNumber or {@code null} for none
   */
  public AccountBusinessInformation setKoreanBusinessRegistrationNumber(java.lang.String koreanBusinessRegistrationNumber) {
    this.koreanBusinessRegistrationNumber = koreanBusinessRegistrationNumber;
    return this;
  }

  /**
   * The phone number of the business. This can only be updated if a verified phone number is not
   * already set. To replace a verified phone number use the `Accounts.requestphoneverification` and
   * `Accounts.verifyphonenumber`.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * The phone number of the business. This can only be updated if a verified phone number is not
   * already set. To replace a verified phone number use the `Accounts.requestphoneverification` and
   * `Accounts.verifyphonenumber`.
   * @param phoneNumber phoneNumber or {@code null} for none
   */
  public AccountBusinessInformation setPhoneNumber(java.lang.String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Verification status of the phone number of the business. This status is read only and can be
   * updated only by successful phone verification. Acceptable values are: - "`verified`" -
   * "`unverified`"
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneVerificationStatus() {
    return phoneVerificationStatus;
  }

  /**
   * Verification status of the phone number of the business. This status is read only and can be
   * updated only by successful phone verification. Acceptable values are: - "`verified`" -
   * "`unverified`"
   * @param phoneVerificationStatus phoneVerificationStatus or {@code null} for none
   */
  public AccountBusinessInformation setPhoneVerificationStatus(java.lang.String phoneVerificationStatus) {
    this.phoneVerificationStatus = phoneVerificationStatus;
    return this;
  }

  @Override
  public AccountBusinessInformation set(String fieldName, Object value) {
    return (AccountBusinessInformation) super.set(fieldName, value);
  }

  @Override
  public AccountBusinessInformation clone() {
    return (AccountBusinessInformation) super.clone();
  }

}
