/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Label assigned by CSS domain or CSS group to one of its sub-accounts.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountLabel extends com.google.api.client.json.GenericJson {

  /**
   * Immutable. The ID of account this label belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long accountId;

  /**
   * The description of this label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Output only. The ID of the label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long labelId;

  /**
   * Output only. The type of this label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String labelType;

  /**
   * The display name of this label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Immutable. The ID of account this label belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAccountId() {
    return accountId;
  }

  /**
   * Immutable. The ID of account this label belongs to.
   * @param accountId accountId or {@code null} for none
   */
  public AccountLabel setAccountId(java.lang.Long accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * The description of this label.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of this label.
   * @param description description or {@code null} for none
   */
  public AccountLabel setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Output only. The ID of the label.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLabelId() {
    return labelId;
  }

  /**
   * Output only. The ID of the label.
   * @param labelId labelId or {@code null} for none
   */
  public AccountLabel setLabelId(java.lang.Long labelId) {
    this.labelId = labelId;
    return this;
  }

  /**
   * Output only. The type of this label.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabelType() {
    return labelType;
  }

  /**
   * Output only. The type of this label.
   * @param labelType labelType or {@code null} for none
   */
  public AccountLabel setLabelType(java.lang.String labelType) {
    this.labelType = labelType;
    return this;
  }

  /**
   * The display name of this label.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The display name of this label.
   * @param name name or {@code null} for none
   */
  public AccountLabel setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public AccountLabel set(String fieldName, Object value) {
    return (AccountLabel) super.set(fieldName, value);
  }

  @Override
  public AccountLabel clone() {
    return (AccountLabel) super.clone();
  }

}
