/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for AccountStatusProducts.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountStatusProducts extends com.google.api.client.json.GenericJson {

  /**
   * The channel the data applies to. Acceptable values are: - "`local`" - "`online`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channel;

  /**
   * The country the data applies to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * The destination the data applies to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String destination;

  /**
   * List of item-level issues.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AccountStatusItemLevelIssue> itemLevelIssues;

  static {
    // hack to force ProGuard to consider AccountStatusItemLevelIssue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AccountStatusItemLevelIssue.class);
  }

  /**
   * Aggregated product statistics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountStatusStatistics statistics;

  /**
   * The channel the data applies to. Acceptable values are: - "`local`" - "`online`"
   * @return value or {@code null} for none
   */
  public java.lang.String getChannel() {
    return channel;
  }

  /**
   * The channel the data applies to. Acceptable values are: - "`local`" - "`online`"
   * @param channel channel or {@code null} for none
   */
  public AccountStatusProducts setChannel(java.lang.String channel) {
    this.channel = channel;
    return this;
  }

  /**
   * The country the data applies to.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * The country the data applies to.
   * @param country country or {@code null} for none
   */
  public AccountStatusProducts setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * The destination the data applies to.
   * @return value or {@code null} for none
   */
  public java.lang.String getDestination() {
    return destination;
  }

  /**
   * The destination the data applies to.
   * @param destination destination or {@code null} for none
   */
  public AccountStatusProducts setDestination(java.lang.String destination) {
    this.destination = destination;
    return this;
  }

  /**
   * List of item-level issues.
   * @return value or {@code null} for none
   */
  public java.util.List<AccountStatusItemLevelIssue> getItemLevelIssues() {
    return itemLevelIssues;
  }

  /**
   * List of item-level issues.
   * @param itemLevelIssues itemLevelIssues or {@code null} for none
   */
  public AccountStatusProducts setItemLevelIssues(java.util.List<AccountStatusItemLevelIssue> itemLevelIssues) {
    this.itemLevelIssues = itemLevelIssues;
    return this;
  }

  /**
   * Aggregated product statistics.
   * @return value or {@code null} for none
   */
  public AccountStatusStatistics getStatistics() {
    return statistics;
  }

  /**
   * Aggregated product statistics.
   * @param statistics statistics or {@code null} for none
   */
  public AccountStatusProducts setStatistics(AccountStatusStatistics statistics) {
    this.statistics = statistics;
    return this;
  }

  @Override
  public AccountStatusProducts set(String fieldName, Object value) {
    return (AccountStatusProducts) super.set(fieldName, value);
  }

  @Override
  public AccountStatusProducts clone() {
    return (AccountStatusProducts) super.clone();
  }

}
