/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Tax calculation rule to apply in a state or province (US only).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountTaxTaxRule extends com.google.api.client.json.GenericJson {

  /**
   * Country code in which tax is applicable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * Required. State (or province) is which the tax is applicable, described by its location ID
   * (also called criteria ID).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger locationId;

  /**
   * Explicit tax rate in percent, represented as a floating point number without the percentage
   * character. Must not be negative.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ratePercent;

  /**
   * If true, shipping charges are also taxed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean shippingTaxed;

  /**
   * Whether the tax rate is taken from a global tax table or specified explicitly.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useGlobalRate;

  /**
   * Country code in which tax is applicable.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * Country code in which tax is applicable.
   * @param country country or {@code null} for none
   */
  public AccountTaxTaxRule setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * Required. State (or province) is which the tax is applicable, described by its location ID
   * (also called criteria ID).
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getLocationId() {
    return locationId;
  }

  /**
   * Required. State (or province) is which the tax is applicable, described by its location ID
   * (also called criteria ID).
   * @param locationId locationId or {@code null} for none
   */
  public AccountTaxTaxRule setLocationId(java.math.BigInteger locationId) {
    this.locationId = locationId;
    return this;
  }

  /**
   * Explicit tax rate in percent, represented as a floating point number without the percentage
   * character. Must not be negative.
   * @return value or {@code null} for none
   */
  public java.lang.String getRatePercent() {
    return ratePercent;
  }

  /**
   * Explicit tax rate in percent, represented as a floating point number without the percentage
   * character. Must not be negative.
   * @param ratePercent ratePercent or {@code null} for none
   */
  public AccountTaxTaxRule setRatePercent(java.lang.String ratePercent) {
    this.ratePercent = ratePercent;
    return this;
  }

  /**
   * If true, shipping charges are also taxed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShippingTaxed() {
    return shippingTaxed;
  }

  /**
   * If true, shipping charges are also taxed.
   * @param shippingTaxed shippingTaxed or {@code null} for none
   */
  public AccountTaxTaxRule setShippingTaxed(java.lang.Boolean shippingTaxed) {
    this.shippingTaxed = shippingTaxed;
    return this;
  }

  /**
   * Whether the tax rate is taken from a global tax table or specified explicitly.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseGlobalRate() {
    return useGlobalRate;
  }

  /**
   * Whether the tax rate is taken from a global tax table or specified explicitly.
   * @param useGlobalRate useGlobalRate or {@code null} for none
   */
  public AccountTaxTaxRule setUseGlobalRate(java.lang.Boolean useGlobalRate) {
    this.useGlobalRate = useGlobalRate;
    return this;
  }

  @Override
  public AccountTaxTaxRule set(String fieldName, Object value) {
    return (AccountTaxTaxRule) super.set(fieldName, value);
  }

  @Override
  public AccountTaxTaxRule clone() {
    return (AccountTaxTaxRule) super.clone();
  }

}
