/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Fields related to the [Best Sellers
 * reports](https://support.google.com/merchants/answer/9488679).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BestSellers extends com.google.api.client.json.GenericJson {

  /**
   * Google product category ID to calculate the ranking for, represented in [Google's product
   * taxonomy](https://support.google.com/merchants/answer/6324436).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long categoryId;

  /**
   * Country where the ranking is calculated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * Popularity rank in the previous week or month.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long previousRank;

  /**
   * Estimated demand in relation to the item with the highest popularity rank in the same category
   * and country in the previous week or month.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String previousRelativeDemand;

  /**
   * Popularity on Shopping ads and free listings, in the selected category and country, based on
   * the estimated number of units sold.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long rank;

  /**
   * Estimated demand in relation to the item with the highest popularity rank in the same category
   * and country.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String relativeDemand;

  /**
   * Change in the estimated demand. Whether it rose, sank or remained flat.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String relativeDemandChange;

  /**
   * Report date. The value of this field can only be one of the following: * The first day of the
   * week (Monday) for weekly reports. * The first day of the month for monthly reports.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date reportDate;

  /**
   * Granularity of the report. The ranking can be done over a week or a month timeframe.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reportGranularity;

  /**
   * Google product category ID to calculate the ranking for, represented in [Google's product
   * taxonomy](https://support.google.com/merchants/answer/6324436).
   * @return value or {@code null} for none
   */
  public java.lang.Long getCategoryId() {
    return categoryId;
  }

  /**
   * Google product category ID to calculate the ranking for, represented in [Google's product
   * taxonomy](https://support.google.com/merchants/answer/6324436).
   * @param categoryId categoryId or {@code null} for none
   */
  public BestSellers setCategoryId(java.lang.Long categoryId) {
    this.categoryId = categoryId;
    return this;
  }

  /**
   * Country where the ranking is calculated.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Country where the ranking is calculated.
   * @param countryCode countryCode or {@code null} for none
   */
  public BestSellers setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Popularity rank in the previous week or month.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPreviousRank() {
    return previousRank;
  }

  /**
   * Popularity rank in the previous week or month.
   * @param previousRank previousRank or {@code null} for none
   */
  public BestSellers setPreviousRank(java.lang.Long previousRank) {
    this.previousRank = previousRank;
    return this;
  }

  /**
   * Estimated demand in relation to the item with the highest popularity rank in the same category
   * and country in the previous week or month.
   * @return value or {@code null} for none
   */
  public java.lang.String getPreviousRelativeDemand() {
    return previousRelativeDemand;
  }

  /**
   * Estimated demand in relation to the item with the highest popularity rank in the same category
   * and country in the previous week or month.
   * @param previousRelativeDemand previousRelativeDemand or {@code null} for none
   */
  public BestSellers setPreviousRelativeDemand(java.lang.String previousRelativeDemand) {
    this.previousRelativeDemand = previousRelativeDemand;
    return this;
  }

  /**
   * Popularity on Shopping ads and free listings, in the selected category and country, based on
   * the estimated number of units sold.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRank() {
    return rank;
  }

  /**
   * Popularity on Shopping ads and free listings, in the selected category and country, based on
   * the estimated number of units sold.
   * @param rank rank or {@code null} for none
   */
  public BestSellers setRank(java.lang.Long rank) {
    this.rank = rank;
    return this;
  }

  /**
   * Estimated demand in relation to the item with the highest popularity rank in the same category
   * and country.
   * @return value or {@code null} for none
   */
  public java.lang.String getRelativeDemand() {
    return relativeDemand;
  }

  /**
   * Estimated demand in relation to the item with the highest popularity rank in the same category
   * and country.
   * @param relativeDemand relativeDemand or {@code null} for none
   */
  public BestSellers setRelativeDemand(java.lang.String relativeDemand) {
    this.relativeDemand = relativeDemand;
    return this;
  }

  /**
   * Change in the estimated demand. Whether it rose, sank or remained flat.
   * @return value or {@code null} for none
   */
  public java.lang.String getRelativeDemandChange() {
    return relativeDemandChange;
  }

  /**
   * Change in the estimated demand. Whether it rose, sank or remained flat.
   * @param relativeDemandChange relativeDemandChange or {@code null} for none
   */
  public BestSellers setRelativeDemandChange(java.lang.String relativeDemandChange) {
    this.relativeDemandChange = relativeDemandChange;
    return this;
  }

  /**
   * Report date. The value of this field can only be one of the following: * The first day of the
   * week (Monday) for weekly reports. * The first day of the month for monthly reports.
   * @return value or {@code null} for none
   */
  public Date getReportDate() {
    return reportDate;
  }

  /**
   * Report date. The value of this field can only be one of the following: * The first day of the
   * week (Monday) for weekly reports. * The first day of the month for monthly reports.
   * @param reportDate reportDate or {@code null} for none
   */
  public BestSellers setReportDate(Date reportDate) {
    this.reportDate = reportDate;
    return this;
  }

  /**
   * Granularity of the report. The ranking can be done over a week or a month timeframe.
   * @return value or {@code null} for none
   */
  public java.lang.String getReportGranularity() {
    return reportGranularity;
  }

  /**
   * Granularity of the report. The ranking can be done over a week or a month timeframe.
   * @param reportGranularity reportGranularity or {@code null} for none
   */
  public BestSellers setReportGranularity(java.lang.String reportGranularity) {
    this.reportGranularity = reportGranularity;
    return this;
  }

  @Override
  public BestSellers set(String fieldName, Object value) {
    return (BestSellers) super.set(fieldName, value);
  }

  @Override
  public BestSellers clone() {
    return (BestSellers) super.clone();
  }

}
