/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The collection message.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Collection extends com.google.api.client.json.GenericJson {

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns. [Custom label](https://support.google.com/merchants/answer/9674217)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customLabel0;

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customLabel1;

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customLabel2;

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customLabel3;

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String customLabel4;

  /**
   * This identifies one or more products associated with the collection. Used as a lookup to the
   * corresponding product ID in your product feeds. Provide a maximum of 100 featuredProduct (for
   * collections). Provide up to 10 featuredProduct (for Shoppable Images only) with ID and X and Y
   * coordinates. [featured_product attribute](https://support.google.com/merchants/answer/9703736)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CollectionFeaturedProduct> featuredProduct;

  /**
   * Your collection's name. [headline
   * attribute](https://support.google.com/merchants/answer/9673580)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> headline;

  /**
   * Required. The REST ID of the collection. Content API methods that operate on collections take
   * this as their collectionId parameter. The REST ID for a collection is of the form collectionId.
   * [id attribute](https://support.google.com/merchants/answer/9649290)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * The URL of a collection’s image. [image_link
   * attribute](https://support.google.com/merchants/answer/9703236)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> imageLink;

  /**
   * The language of a collection and the language of any featured products linked to the
   * collection. [language attribute](https://support.google.com/merchants/answer/9673781)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String language;

  /**
   * A collection’s landing page. URL directly linking to your collection's page on your website.
   * [link attribute](https://support.google.com/merchants/answer/9673983)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String link;

  /**
   * A collection’s mobile-optimized landing page when you have a different URL for mobile and
   * desktop traffic. [mobile_link attribute](https://support.google.com/merchants/answer/9646123)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mobileLink;

  /**
   * [product_country attribute](https://support.google.com/merchants/answer/9674155)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productCountry;

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns. [Custom label](https://support.google.com/merchants/answer/9674217)
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomLabel0() {
    return customLabel0;
  }

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns. [Custom label](https://support.google.com/merchants/answer/9674217)
   * @param customLabel0 customLabel0 or {@code null} for none
   */
  public Collection setCustomLabel0(java.lang.String customLabel0) {
    this.customLabel0 = customLabel0;
    return this;
  }

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomLabel1() {
    return customLabel1;
  }

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * @param customLabel1 customLabel1 or {@code null} for none
   */
  public Collection setCustomLabel1(java.lang.String customLabel1) {
    this.customLabel1 = customLabel1;
    return this;
  }

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomLabel2() {
    return customLabel2;
  }

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * @param customLabel2 customLabel2 or {@code null} for none
   */
  public Collection setCustomLabel2(java.lang.String customLabel2) {
    this.customLabel2 = customLabel2;
    return this;
  }

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomLabel3() {
    return customLabel3;
  }

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * @param customLabel3 customLabel3 or {@code null} for none
   */
  public Collection setCustomLabel3(java.lang.String customLabel3) {
    this.customLabel3 = customLabel3;
    return this;
  }

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * @return value or {@code null} for none
   */
  public java.lang.String getCustomLabel4() {
    return customLabel4;
  }

  /**
   * Label that you assign to a collection to help organize bidding and reporting in Shopping
   * campaigns.
   * @param customLabel4 customLabel4 or {@code null} for none
   */
  public Collection setCustomLabel4(java.lang.String customLabel4) {
    this.customLabel4 = customLabel4;
    return this;
  }

  /**
   * This identifies one or more products associated with the collection. Used as a lookup to the
   * corresponding product ID in your product feeds. Provide a maximum of 100 featuredProduct (for
   * collections). Provide up to 10 featuredProduct (for Shoppable Images only) with ID and X and Y
   * coordinates. [featured_product attribute](https://support.google.com/merchants/answer/9703736)
   * @return value or {@code null} for none
   */
  public java.util.List<CollectionFeaturedProduct> getFeaturedProduct() {
    return featuredProduct;
  }

  /**
   * This identifies one or more products associated with the collection. Used as a lookup to the
   * corresponding product ID in your product feeds. Provide a maximum of 100 featuredProduct (for
   * collections). Provide up to 10 featuredProduct (for Shoppable Images only) with ID and X and Y
   * coordinates. [featured_product attribute](https://support.google.com/merchants/answer/9703736)
   * @param featuredProduct featuredProduct or {@code null} for none
   */
  public Collection setFeaturedProduct(java.util.List<CollectionFeaturedProduct> featuredProduct) {
    this.featuredProduct = featuredProduct;
    return this;
  }

  /**
   * Your collection's name. [headline
   * attribute](https://support.google.com/merchants/answer/9673580)
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getHeadline() {
    return headline;
  }

  /**
   * Your collection's name. [headline
   * attribute](https://support.google.com/merchants/answer/9673580)
   * @param headline headline or {@code null} for none
   */
  public Collection setHeadline(java.util.List<java.lang.String> headline) {
    this.headline = headline;
    return this;
  }

  /**
   * Required. The REST ID of the collection. Content API methods that operate on collections take
   * this as their collectionId parameter. The REST ID for a collection is of the form collectionId.
   * [id attribute](https://support.google.com/merchants/answer/9649290)
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required. The REST ID of the collection. Content API methods that operate on collections take
   * this as their collectionId parameter. The REST ID for a collection is of the form collectionId.
   * [id attribute](https://support.google.com/merchants/answer/9649290)
   * @param id id or {@code null} for none
   */
  public Collection setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * The URL of a collection’s image. [image_link
   * attribute](https://support.google.com/merchants/answer/9703236)
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getImageLink() {
    return imageLink;
  }

  /**
   * The URL of a collection’s image. [image_link
   * attribute](https://support.google.com/merchants/answer/9703236)
   * @param imageLink imageLink or {@code null} for none
   */
  public Collection setImageLink(java.util.List<java.lang.String> imageLink) {
    this.imageLink = imageLink;
    return this;
  }

  /**
   * The language of a collection and the language of any featured products linked to the
   * collection. [language attribute](https://support.google.com/merchants/answer/9673781)
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguage() {
    return language;
  }

  /**
   * The language of a collection and the language of any featured products linked to the
   * collection. [language attribute](https://support.google.com/merchants/answer/9673781)
   * @param language language or {@code null} for none
   */
  public Collection setLanguage(java.lang.String language) {
    this.language = language;
    return this;
  }

  /**
   * A collection’s landing page. URL directly linking to your collection's page on your website.
   * [link attribute](https://support.google.com/merchants/answer/9673983)
   * @return value or {@code null} for none
   */
  public java.lang.String getLink() {
    return link;
  }

  /**
   * A collection’s landing page. URL directly linking to your collection's page on your website.
   * [link attribute](https://support.google.com/merchants/answer/9673983)
   * @param link link or {@code null} for none
   */
  public Collection setLink(java.lang.String link) {
    this.link = link;
    return this;
  }

  /**
   * A collection’s mobile-optimized landing page when you have a different URL for mobile and
   * desktop traffic. [mobile_link attribute](https://support.google.com/merchants/answer/9646123)
   * @return value or {@code null} for none
   */
  public java.lang.String getMobileLink() {
    return mobileLink;
  }

  /**
   * A collection’s mobile-optimized landing page when you have a different URL for mobile and
   * desktop traffic. [mobile_link attribute](https://support.google.com/merchants/answer/9646123)
   * @param mobileLink mobileLink or {@code null} for none
   */
  public Collection setMobileLink(java.lang.String mobileLink) {
    this.mobileLink = mobileLink;
    return this;
  }

  /**
   * [product_country attribute](https://support.google.com/merchants/answer/9674155)
   * @return value or {@code null} for none
   */
  public java.lang.String getProductCountry() {
    return productCountry;
  }

  /**
   * [product_country attribute](https://support.google.com/merchants/answer/9674155)
   * @param productCountry productCountry or {@code null} for none
   */
  public Collection setProductCountry(java.lang.String productCountry) {
    this.productCountry = productCountry;
    return this;
  }

  @Override
  public Collection set(String fieldName, Object value) {
    return (Collection) super.set(fieldName, value);
  }

  @Override
  public Collection clone() {
    return (Collection) super.clone();
  }

}
