/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The collectionstatus message.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CollectionStatus extends com.google.api.client.json.GenericJson {

  /**
   * A list of all issues associated with the collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CollectionStatusItemLevelIssue> collectionLevelIssuses;

  /**
   * Date on which the collection has been created in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationDate;

  /**
   * The intended destinations for the collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CollectionStatusDestinationStatus> destinationStatuses;

  /**
   * Required. The ID of the collection for which status is reported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Date on which the collection has been last updated in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastUpdateDate;

  /**
   * A list of all issues associated with the collection.
   * @return value or {@code null} for none
   */
  public java.util.List<CollectionStatusItemLevelIssue> getCollectionLevelIssuses() {
    return collectionLevelIssuses;
  }

  /**
   * A list of all issues associated with the collection.
   * @param collectionLevelIssuses collectionLevelIssuses or {@code null} for none
   */
  public CollectionStatus setCollectionLevelIssuses(java.util.List<CollectionStatusItemLevelIssue> collectionLevelIssuses) {
    this.collectionLevelIssuses = collectionLevelIssuses;
    return this;
  }

  /**
   * Date on which the collection has been created in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationDate() {
    return creationDate;
  }

  /**
   * Date on which the collection has been created in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * @param creationDate creationDate or {@code null} for none
   */
  public CollectionStatus setCreationDate(java.lang.String creationDate) {
    this.creationDate = creationDate;
    return this;
  }

  /**
   * The intended destinations for the collection.
   * @return value or {@code null} for none
   */
  public java.util.List<CollectionStatusDestinationStatus> getDestinationStatuses() {
    return destinationStatuses;
  }

  /**
   * The intended destinations for the collection.
   * @param destinationStatuses destinationStatuses or {@code null} for none
   */
  public CollectionStatus setDestinationStatuses(java.util.List<CollectionStatusDestinationStatus> destinationStatuses) {
    this.destinationStatuses = destinationStatuses;
    return this;
  }

  /**
   * Required. The ID of the collection for which status is reported.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Required. The ID of the collection for which status is reported.
   * @param id id or {@code null} for none
   */
  public CollectionStatus setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Date on which the collection has been last updated in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * @return value or {@code null} for none
   */
  public java.lang.String getLastUpdateDate() {
    return lastUpdateDate;
  }

  /**
   * Date on which the collection has been last updated in [ISO
   * 8601](http://en.wikipedia.org/wiki/ISO_8601) format: Date, time, and offset, for example
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z"
   * @param lastUpdateDate lastUpdateDate or {@code null} for none
   */
  public CollectionStatus setLastUpdateDate(java.lang.String lastUpdateDate) {
    this.lastUpdateDate = lastUpdateDate;
    return this;
  }

  @Override
  public CollectionStatus set(String fieldName, Object value) {
    return (CollectionStatus) super.set(fieldName, value);
  }

  @Override
  public CollectionStatus clone() {
    return (CollectionStatus) super.clone();
  }

}
