/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for LiasettingsCustomBatchRequestEntry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LiasettingsCustomBatchRequestEntry extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the account for which to get/update account LIA settings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger accountId;

  /**
   * An entry ID, unique within the batch request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long batchId;

  /**
   * Inventory validation contact email. Required only for SetInventoryValidationContact.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contactEmail;

  /**
   * Inventory validation contact name. Required only for SetInventoryValidationContact.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contactName;

  /**
   * The country code. Required only for RequestInventoryVerification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * The Business Profile. Required only for RequestGmbAccess.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gmbEmail;

  /**
   * The account Lia settings to update. Only defined if the method is `update`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LiaSettings liaSettings;

  /**
   * The ID of the managing account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger merchantId;

  /**
   * The method of the batch entry. Acceptable values are: - "`get`" - "`getAccessibleGmbAccounts`"
   * - "`requestGmbAccess`" - "`requestInventoryVerification`" - "`setInventoryVerificationContact`"
   * - "`update`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String method;

  /**
   * The ID of POS data provider. Required only for SetPosProvider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger posDataProviderId;

  /**
   * The account ID by which this merchant is known to the POS provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String posExternalAccountId;

  /**
   * The ID of the account for which to get/update account LIA settings.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getAccountId() {
    return accountId;
  }

  /**
   * The ID of the account for which to get/update account LIA settings.
   * @param accountId accountId or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setAccountId(java.math.BigInteger accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * An entry ID, unique within the batch request.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBatchId() {
    return batchId;
  }

  /**
   * An entry ID, unique within the batch request.
   * @param batchId batchId or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setBatchId(java.lang.Long batchId) {
    this.batchId = batchId;
    return this;
  }

  /**
   * Inventory validation contact email. Required only for SetInventoryValidationContact.
   * @return value or {@code null} for none
   */
  public java.lang.String getContactEmail() {
    return contactEmail;
  }

  /**
   * Inventory validation contact email. Required only for SetInventoryValidationContact.
   * @param contactEmail contactEmail or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setContactEmail(java.lang.String contactEmail) {
    this.contactEmail = contactEmail;
    return this;
  }

  /**
   * Inventory validation contact name. Required only for SetInventoryValidationContact.
   * @return value or {@code null} for none
   */
  public java.lang.String getContactName() {
    return contactName;
  }

  /**
   * Inventory validation contact name. Required only for SetInventoryValidationContact.
   * @param contactName contactName or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setContactName(java.lang.String contactName) {
    this.contactName = contactName;
    return this;
  }

  /**
   * The country code. Required only for RequestInventoryVerification.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * The country code. Required only for RequestInventoryVerification.
   * @param country country or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * The Business Profile. Required only for RequestGmbAccess.
   * @return value or {@code null} for none
   */
  public java.lang.String getGmbEmail() {
    return gmbEmail;
  }

  /**
   * The Business Profile. Required only for RequestGmbAccess.
   * @param gmbEmail gmbEmail or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setGmbEmail(java.lang.String gmbEmail) {
    this.gmbEmail = gmbEmail;
    return this;
  }

  /**
   * The account Lia settings to update. Only defined if the method is `update`.
   * @return value or {@code null} for none
   */
  public LiaSettings getLiaSettings() {
    return liaSettings;
  }

  /**
   * The account Lia settings to update. Only defined if the method is `update`.
   * @param liaSettings liaSettings or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setLiaSettings(LiaSettings liaSettings) {
    this.liaSettings = liaSettings;
    return this;
  }

  /**
   * The ID of the managing account.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getMerchantId() {
    return merchantId;
  }

  /**
   * The ID of the managing account.
   * @param merchantId merchantId or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setMerchantId(java.math.BigInteger merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * The method of the batch entry. Acceptable values are: - "`get`" - "`getAccessibleGmbAccounts`"
   * - "`requestGmbAccess`" - "`requestInventoryVerification`" - "`setInventoryVerificationContact`"
   * - "`update`"
   * @return value or {@code null} for none
   */
  public java.lang.String getMethod() {
    return method;
  }

  /**
   * The method of the batch entry. Acceptable values are: - "`get`" - "`getAccessibleGmbAccounts`"
   * - "`requestGmbAccess`" - "`requestInventoryVerification`" - "`setInventoryVerificationContact`"
   * - "`update`"
   * @param method method or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setMethod(java.lang.String method) {
    this.method = method;
    return this;
  }

  /**
   * The ID of POS data provider. Required only for SetPosProvider.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getPosDataProviderId() {
    return posDataProviderId;
  }

  /**
   * The ID of POS data provider. Required only for SetPosProvider.
   * @param posDataProviderId posDataProviderId or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setPosDataProviderId(java.math.BigInteger posDataProviderId) {
    this.posDataProviderId = posDataProviderId;
    return this;
  }

  /**
   * The account ID by which this merchant is known to the POS provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getPosExternalAccountId() {
    return posExternalAccountId;
  }

  /**
   * The account ID by which this merchant is known to the POS provider.
   * @param posExternalAccountId posExternalAccountId or {@code null} for none
   */
  public LiasettingsCustomBatchRequestEntry setPosExternalAccountId(java.lang.String posExternalAccountId) {
    this.posExternalAccountId = posExternalAccountId;
    return this;
  }

  @Override
  public LiasettingsCustomBatchRequestEntry set(String fieldName, Object value) {
    return (LiasettingsCustomBatchRequestEntry) super.set(fieldName, value);
  }

  @Override
  public LiasettingsCustomBatchRequestEntry clone() {
    return (LiasettingsCustomBatchRequestEntry) super.clone();
  }

}
