/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Batch entry encoding a single local inventory update request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocalinventoryCustomBatchRequestEntry extends com.google.api.client.json.GenericJson {

  /**
   * An entry ID, unique within the batch request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long batchId;

  /**
   * Local inventory of the product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalInventory localInventory;

  /**
   * The ID of the managing account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger merchantId;

  /**
   * Method of the batch request entry. Acceptable values are: - "`insert`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String method;

  /**
   * The ID of the product for which to update local inventory.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productId;

  /**
   * An entry ID, unique within the batch request.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBatchId() {
    return batchId;
  }

  /**
   * An entry ID, unique within the batch request.
   * @param batchId batchId or {@code null} for none
   */
  public LocalinventoryCustomBatchRequestEntry setBatchId(java.lang.Long batchId) {
    this.batchId = batchId;
    return this;
  }

  /**
   * Local inventory of the product.
   * @return value or {@code null} for none
   */
  public LocalInventory getLocalInventory() {
    return localInventory;
  }

  /**
   * Local inventory of the product.
   * @param localInventory localInventory or {@code null} for none
   */
  public LocalinventoryCustomBatchRequestEntry setLocalInventory(LocalInventory localInventory) {
    this.localInventory = localInventory;
    return this;
  }

  /**
   * The ID of the managing account.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getMerchantId() {
    return merchantId;
  }

  /**
   * The ID of the managing account.
   * @param merchantId merchantId or {@code null} for none
   */
  public LocalinventoryCustomBatchRequestEntry setMerchantId(java.math.BigInteger merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * Method of the batch request entry. Acceptable values are: - "`insert`"
   * @return value or {@code null} for none
   */
  public java.lang.String getMethod() {
    return method;
  }

  /**
   * Method of the batch request entry. Acceptable values are: - "`insert`"
   * @param method method or {@code null} for none
   */
  public LocalinventoryCustomBatchRequestEntry setMethod(java.lang.String method) {
    this.method = method;
    return this;
  }

  /**
   * The ID of the product for which to update local inventory.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductId() {
    return productId;
  }

  /**
   * The ID of the product for which to update local inventory.
   * @param productId productId or {@code null} for none
   */
  public LocalinventoryCustomBatchRequestEntry setProductId(java.lang.String productId) {
    this.productId = productId;
    return this;
  }

  @Override
  public LocalinventoryCustomBatchRequestEntry set(String fieldName, Object value) {
    return (LocalinventoryCustomBatchRequestEntry) super.set(fieldName, value);
  }

  @Override
  public LocalinventoryCustomBatchRequestEntry clone() {
    return (LocalinventoryCustomBatchRequestEntry) super.clone();
  }

}
