/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for LoyaltyPoints.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LoyaltyPoints extends com.google.api.client.json.GenericJson {

  /**
   * Name of loyalty points program. It is recommended to limit the name to 12 full-width characters
   * or 24 Roman characters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The retailer's loyalty points in absolute value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long pointsValue;

  /**
   * The ratio of a point when converted to currency. Google assumes currency based on Merchant
   * Center settings. If ratio is left out, it defaults to 1.0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double ratio;

  /**
   * Name of loyalty points program. It is recommended to limit the name to 12 full-width characters
   * or 24 Roman characters.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of loyalty points program. It is recommended to limit the name to 12 full-width characters
   * or 24 Roman characters.
   * @param name name or {@code null} for none
   */
  public LoyaltyPoints setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The retailer's loyalty points in absolute value.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPointsValue() {
    return pointsValue;
  }

  /**
   * The retailer's loyalty points in absolute value.
   * @param pointsValue pointsValue or {@code null} for none
   */
  public LoyaltyPoints setPointsValue(java.lang.Long pointsValue) {
    this.pointsValue = pointsValue;
    return this;
  }

  /**
   * The ratio of a point when converted to currency. Google assumes currency based on Merchant
   * Center settings. If ratio is left out, it defaults to 1.0.
   * @return value or {@code null} for none
   */
  public java.lang.Double getRatio() {
    return ratio;
  }

  /**
   * The ratio of a point when converted to currency. Google assumes currency based on Merchant
   * Center settings. If ratio is left out, it defaults to 1.0.
   * @param ratio ratio or {@code null} for none
   */
  public LoyaltyPoints setRatio(java.lang.Double ratio) {
    this.ratio = ratio;
    return this;
  }

  @Override
  public LoyaltyPoints set(String fieldName, Object value) {
    return (LoyaltyPoints) super.set(fieldName, value);
  }

  @Override
  public LoyaltyPoints clone() {
    return (LoyaltyPoints) super.clone();
  }

}
