/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderPromotion.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderPromotion extends com.google.api.client.json.GenericJson {

  /**
   * Items that this promotion may be applied to. If empty, there are no restrictions on applicable
   * items and quantity. This field will also be empty for shipping promotions because shipping is
   * not tied to any specific item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderPromotionItem> applicableItems;

  /**
   * Items that this promotion have been applied to. Do not provide for `orders.createtestorder`.
   * This field will be empty for shipping promotions because shipping is not tied to any specific
   * item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderPromotionItem> appliedItems;

  /**
   * Promotion end time in ISO 8601 format. Date, time, and offset required, for example,
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String endTime;

  /**
   * Required. The party funding the promotion. Only `merchant` is supported for
   * `orders.createtestorder`. Acceptable values are: - "`google`" - "`merchant`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String funder;

  /**
   * Required. This field is used to identify promotions within merchants' own systems.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String merchantPromotionId;

  /**
   * Estimated discount applied to price. Amount is pre-tax or post-tax depending on location of
   * order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price priceValue;

  /**
   * A short title of the promotion to be shown on the checkout page. Do not provide for
   * `orders.createtestorder`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shortTitle;

  /**
   * Promotion start time in ISO 8601 format. Date, time, and offset required, for example,
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String startTime;

  /**
   * Required. The category of the promotion. Only `moneyOff` is supported for
   * `orders.createtestorder`. Acceptable values are: - "`buyMGetMoneyOff`" - "`buyMGetNMoneyOff`" -
   * "`buyMGetNPercentOff`" - "`buyMGetPercentOff`" - "`freeGift`" - "`freeGiftWithItemId`" -
   * "`freeGiftWithValue`" - "`freeShippingOvernight`" - "`freeShippingStandard`" -
   * "`freeShippingTwoDay`" - "`moneyOff`" - "`percentOff`" - "`rewardPoints`" - "`salePrice`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subtype;

  /**
   * Estimated discount applied to tax (if allowed by law). Do not provide for
   * `orders.createtestorder`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price taxValue;

  /**
   * Required. The title of the promotion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Required. The scope of the promotion. Only `product` is supported for `orders.createtestorder`.
   * Acceptable values are: - "`product`" - "`shipping`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Items that this promotion may be applied to. If empty, there are no restrictions on applicable
   * items and quantity. This field will also be empty for shipping promotions because shipping is
   * not tied to any specific item.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderPromotionItem> getApplicableItems() {
    return applicableItems;
  }

  /**
   * Items that this promotion may be applied to. If empty, there are no restrictions on applicable
   * items and quantity. This field will also be empty for shipping promotions because shipping is
   * not tied to any specific item.
   * @param applicableItems applicableItems or {@code null} for none
   */
  public OrderPromotion setApplicableItems(java.util.List<OrderPromotionItem> applicableItems) {
    this.applicableItems = applicableItems;
    return this;
  }

  /**
   * Items that this promotion have been applied to. Do not provide for `orders.createtestorder`.
   * This field will be empty for shipping promotions because shipping is not tied to any specific
   * item.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderPromotionItem> getAppliedItems() {
    return appliedItems;
  }

  /**
   * Items that this promotion have been applied to. Do not provide for `orders.createtestorder`.
   * This field will be empty for shipping promotions because shipping is not tied to any specific
   * item.
   * @param appliedItems appliedItems or {@code null} for none
   */
  public OrderPromotion setAppliedItems(java.util.List<OrderPromotionItem> appliedItems) {
    this.appliedItems = appliedItems;
    return this;
  }

  /**
   * Promotion end time in ISO 8601 format. Date, time, and offset required, for example,
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z".
   * @return value or {@code null} for none
   */
  public java.lang.String getEndTime() {
    return endTime;
  }

  /**
   * Promotion end time in ISO 8601 format. Date, time, and offset required, for example,
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z".
   * @param endTime endTime or {@code null} for none
   */
  public OrderPromotion setEndTime(java.lang.String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Required. The party funding the promotion. Only `merchant` is supported for
   * `orders.createtestorder`. Acceptable values are: - "`google`" - "`merchant`"
   * @return value or {@code null} for none
   */
  public java.lang.String getFunder() {
    return funder;
  }

  /**
   * Required. The party funding the promotion. Only `merchant` is supported for
   * `orders.createtestorder`. Acceptable values are: - "`google`" - "`merchant`"
   * @param funder funder or {@code null} for none
   */
  public OrderPromotion setFunder(java.lang.String funder) {
    this.funder = funder;
    return this;
  }

  /**
   * Required. This field is used to identify promotions within merchants' own systems.
   * @return value or {@code null} for none
   */
  public java.lang.String getMerchantPromotionId() {
    return merchantPromotionId;
  }

  /**
   * Required. This field is used to identify promotions within merchants' own systems.
   * @param merchantPromotionId merchantPromotionId or {@code null} for none
   */
  public OrderPromotion setMerchantPromotionId(java.lang.String merchantPromotionId) {
    this.merchantPromotionId = merchantPromotionId;
    return this;
  }

  /**
   * Estimated discount applied to price. Amount is pre-tax or post-tax depending on location of
   * order.
   * @return value or {@code null} for none
   */
  public Price getPriceValue() {
    return priceValue;
  }

  /**
   * Estimated discount applied to price. Amount is pre-tax or post-tax depending on location of
   * order.
   * @param priceValue priceValue or {@code null} for none
   */
  public OrderPromotion setPriceValue(Price priceValue) {
    this.priceValue = priceValue;
    return this;
  }

  /**
   * A short title of the promotion to be shown on the checkout page. Do not provide for
   * `orders.createtestorder`.
   * @return value or {@code null} for none
   */
  public java.lang.String getShortTitle() {
    return shortTitle;
  }

  /**
   * A short title of the promotion to be shown on the checkout page. Do not provide for
   * `orders.createtestorder`.
   * @param shortTitle shortTitle or {@code null} for none
   */
  public OrderPromotion setShortTitle(java.lang.String shortTitle) {
    this.shortTitle = shortTitle;
    return this;
  }

  /**
   * Promotion start time in ISO 8601 format. Date, time, and offset required, for example,
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z".
   * @return value or {@code null} for none
   */
  public java.lang.String getStartTime() {
    return startTime;
  }

  /**
   * Promotion start time in ISO 8601 format. Date, time, and offset required, for example,
   * "2020-01-02T09:00:00+01:00" or "2020-01-02T09:00:00Z".
   * @param startTime startTime or {@code null} for none
   */
  public OrderPromotion setStartTime(java.lang.String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * Required. The category of the promotion. Only `moneyOff` is supported for
   * `orders.createtestorder`. Acceptable values are: - "`buyMGetMoneyOff`" - "`buyMGetNMoneyOff`" -
   * "`buyMGetNPercentOff`" - "`buyMGetPercentOff`" - "`freeGift`" - "`freeGiftWithItemId`" -
   * "`freeGiftWithValue`" - "`freeShippingOvernight`" - "`freeShippingStandard`" -
   * "`freeShippingTwoDay`" - "`moneyOff`" - "`percentOff`" - "`rewardPoints`" - "`salePrice`"
   * @return value or {@code null} for none
   */
  public java.lang.String getSubtype() {
    return subtype;
  }

  /**
   * Required. The category of the promotion. Only `moneyOff` is supported for
   * `orders.createtestorder`. Acceptable values are: - "`buyMGetMoneyOff`" - "`buyMGetNMoneyOff`" -
   * "`buyMGetNPercentOff`" - "`buyMGetPercentOff`" - "`freeGift`" - "`freeGiftWithItemId`" -
   * "`freeGiftWithValue`" - "`freeShippingOvernight`" - "`freeShippingStandard`" -
   * "`freeShippingTwoDay`" - "`moneyOff`" - "`percentOff`" - "`rewardPoints`" - "`salePrice`"
   * @param subtype subtype or {@code null} for none
   */
  public OrderPromotion setSubtype(java.lang.String subtype) {
    this.subtype = subtype;
    return this;
  }

  /**
   * Estimated discount applied to tax (if allowed by law). Do not provide for
   * `orders.createtestorder`.
   * @return value or {@code null} for none
   */
  public Price getTaxValue() {
    return taxValue;
  }

  /**
   * Estimated discount applied to tax (if allowed by law). Do not provide for
   * `orders.createtestorder`.
   * @param taxValue taxValue or {@code null} for none
   */
  public OrderPromotion setTaxValue(Price taxValue) {
    this.taxValue = taxValue;
    return this;
  }

  /**
   * Required. The title of the promotion.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Required. The title of the promotion.
   * @param title title or {@code null} for none
   */
  public OrderPromotion setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * Required. The scope of the promotion. Only `product` is supported for `orders.createtestorder`.
   * Acceptable values are: - "`product`" - "`shipping`"
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Required. The scope of the promotion. Only `product` is supported for `orders.createtestorder`.
   * Acceptable values are: - "`product`" - "`shipping`"
   * @param type type or {@code null} for none
   */
  public OrderPromotion setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public OrderPromotion set(String fieldName, Object value) {
    return (OrderPromotion) super.set(fieldName, value);
  }

  @Override
  public OrderPromotion clone() {
    return (OrderPromotion) super.clone();
  }

}
