/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderShipmentScheduledDeliveryDetails.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderShipmentScheduledDeliveryDetails extends com.google.api.client.json.GenericJson {

  /**
   * The phone number of the carrier fulfilling the delivery. The phone number is formatted as the
   * international notation in ITU-T Recommendation E.123 (for example, "+41 44 668 1800").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrierPhoneNumber;

  /**
   * The date a shipment is scheduled for delivery, in ISO 8601 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scheduledDate;

  /**
   * The phone number of the carrier fulfilling the delivery. The phone number is formatted as the
   * international notation in ITU-T Recommendation E.123 (for example, "+41 44 668 1800").
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrierPhoneNumber() {
    return carrierPhoneNumber;
  }

  /**
   * The phone number of the carrier fulfilling the delivery. The phone number is formatted as the
   * international notation in ITU-T Recommendation E.123 (for example, "+41 44 668 1800").
   * @param carrierPhoneNumber carrierPhoneNumber or {@code null} for none
   */
  public OrderShipmentScheduledDeliveryDetails setCarrierPhoneNumber(java.lang.String carrierPhoneNumber) {
    this.carrierPhoneNumber = carrierPhoneNumber;
    return this;
  }

  /**
   * The date a shipment is scheduled for delivery, in ISO 8601 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getScheduledDate() {
    return scheduledDate;
  }

  /**
   * The date a shipment is scheduled for delivery, in ISO 8601 format.
   * @param scheduledDate scheduledDate or {@code null} for none
   */
  public OrderShipmentScheduledDeliveryDetails setScheduledDate(java.lang.String scheduledDate) {
    this.scheduledDate = scheduledDate;
    return this;
  }

  @Override
  public OrderShipmentScheduledDeliveryDetails set(String fieldName, Object value) {
    return (OrderShipmentScheduledDeliveryDetails) super.set(fieldName, value);
  }

  @Override
  public OrderShipmentScheduledDeliveryDetails clone() {
    return (OrderShipmentScheduledDeliveryDetails) super.clone();
  }

}
