/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Represents how many items are in the shipment for the given shipment_id and line_item_id.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderTrackingSignalShipmentLineItemMapping extends com.google.api.client.json.GenericJson {

  /**
   * Required. The line item ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lineItemId;

  /**
   * The line item quantity in the shipment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long quantity;

  /**
   * Required. The shipment ID. This field will be hashed in returned OrderTrackingSignal creation
   * response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String shipmentId;

  /**
   * Required. The line item ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getLineItemId() {
    return lineItemId;
  }

  /**
   * Required. The line item ID.
   * @param lineItemId lineItemId or {@code null} for none
   */
  public OrderTrackingSignalShipmentLineItemMapping setLineItemId(java.lang.String lineItemId) {
    this.lineItemId = lineItemId;
    return this;
  }

  /**
   * The line item quantity in the shipment.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuantity() {
    return quantity;
  }

  /**
   * The line item quantity in the shipment.
   * @param quantity quantity or {@code null} for none
   */
  public OrderTrackingSignalShipmentLineItemMapping setQuantity(java.lang.Long quantity) {
    this.quantity = quantity;
    return this;
  }

  /**
   * Required. The shipment ID. This field will be hashed in returned OrderTrackingSignal creation
   * response.
   * @return value or {@code null} for none
   */
  public java.lang.String getShipmentId() {
    return shipmentId;
  }

  /**
   * Required. The shipment ID. This field will be hashed in returned OrderTrackingSignal creation
   * response.
   * @param shipmentId shipmentId or {@code null} for none
   */
  public OrderTrackingSignalShipmentLineItemMapping setShipmentId(java.lang.String shipmentId) {
    this.shipmentId = shipmentId;
    return this;
  }

  @Override
  public OrderTrackingSignalShipmentLineItemMapping set(String fieldName, Object value) {
    return (OrderTrackingSignalShipmentLineItemMapping) super.set(fieldName, value);
  }

  @Override
  public OrderTrackingSignalShipmentLineItemMapping clone() {
    return (OrderTrackingSignalShipmentLineItemMapping) super.clone();
  }

}
