/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderreportsListTransactionsResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderreportsListTransactionsResponse extends com.google.api.client.json.GenericJson {

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "`content#orderreportsListTransactionsResponse`".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The token for the retrieval of the next page of transactions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The list of transactions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderReportTransaction> transactions;

  static {
    // hack to force ProGuard to consider OrderReportTransaction used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(OrderReportTransaction.class);
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "`content#orderreportsListTransactionsResponse`".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "`content#orderreportsListTransactionsResponse`".
   * @param kind kind or {@code null} for none
   */
  public OrderreportsListTransactionsResponse setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The token for the retrieval of the next page of transactions.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The token for the retrieval of the next page of transactions.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public OrderreportsListTransactionsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The list of transactions.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderReportTransaction> getTransactions() {
    return transactions;
  }

  /**
   * The list of transactions.
   * @param transactions transactions or {@code null} for none
   */
  public OrderreportsListTransactionsResponse setTransactions(java.util.List<OrderReportTransaction> transactions) {
    this.transactions = transactions;
    return this;
  }

  @Override
  public OrderreportsListTransactionsResponse set(String fieldName, Object value) {
    return (OrderreportsListTransactionsResponse) super.set(fieldName, value);
  }

  @Override
  public OrderreportsListTransactionsResponse clone() {
    return (OrderreportsListTransactionsResponse) super.clone();
  }

}
