/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrderreturnsCreateOrderReturnRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderreturnsCreateOrderReturnRequest extends com.google.api.client.json.GenericJson {

  /**
   * The list of line items to return.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderreturnsLineItem> lineItems;

  /**
   * The ID of the operation. Unique across all operations for a given order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operationId;

  /**
   * The ID of the order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orderId;

  /**
   * The way of the package being returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String returnMethodType;

  /**
   * The list of line items to return.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderreturnsLineItem> getLineItems() {
    return lineItems;
  }

  /**
   * The list of line items to return.
   * @param lineItems lineItems or {@code null} for none
   */
  public OrderreturnsCreateOrderReturnRequest setLineItems(java.util.List<OrderreturnsLineItem> lineItems) {
    this.lineItems = lineItems;
    return this;
  }

  /**
   * The ID of the operation. Unique across all operations for a given order.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperationId() {
    return operationId;
  }

  /**
   * The ID of the operation. Unique across all operations for a given order.
   * @param operationId operationId or {@code null} for none
   */
  public OrderreturnsCreateOrderReturnRequest setOperationId(java.lang.String operationId) {
    this.operationId = operationId;
    return this;
  }

  /**
   * The ID of the order.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrderId() {
    return orderId;
  }

  /**
   * The ID of the order.
   * @param orderId orderId or {@code null} for none
   */
  public OrderreturnsCreateOrderReturnRequest setOrderId(java.lang.String orderId) {
    this.orderId = orderId;
    return this;
  }

  /**
   * The way of the package being returned.
   * @return value or {@code null} for none
   */
  public java.lang.String getReturnMethodType() {
    return returnMethodType;
  }

  /**
   * The way of the package being returned.
   * @param returnMethodType returnMethodType or {@code null} for none
   */
  public OrderreturnsCreateOrderReturnRequest setReturnMethodType(java.lang.String returnMethodType) {
    this.returnMethodType = returnMethodType;
    return this;
  }

  @Override
  public OrderreturnsCreateOrderReturnRequest set(String fieldName, Object value) {
    return (OrderreturnsCreateOrderReturnRequest) super.set(fieldName, value);
  }

  @Override
  public OrderreturnsCreateOrderReturnRequest clone() {
    return (OrderreturnsCreateOrderReturnRequest) super.clone();
  }

}
