/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrdersCreateTestOrderRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrdersCreateTestOrderRequest extends com.google.api.client.json.GenericJson {

  /**
   * The CLDR territory code of the country of the test order to create. Affects the currency and
   * addresses of orders created through `template_name`, or the addresses of orders created through
   * `test_order`. Acceptable values are: - "`US`" - "`FR`" Defaults to "`US`".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * The test order template to use. Specify as an alternative to `testOrder` as a shortcut for
   * retrieving a template and then creating an order using that template. Acceptable values are: -
   * "`template1`" - "`template1a`" - "`template1b`" - "`template2`" - "`template3`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String templateName;

  /**
   * The test order to create.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TestOrder testOrder;

  /**
   * The CLDR territory code of the country of the test order to create. Affects the currency and
   * addresses of orders created through `template_name`, or the addresses of orders created through
   * `test_order`. Acceptable values are: - "`US`" - "`FR`" Defaults to "`US`".
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * The CLDR territory code of the country of the test order to create. Affects the currency and
   * addresses of orders created through `template_name`, or the addresses of orders created through
   * `test_order`. Acceptable values are: - "`US`" - "`FR`" Defaults to "`US`".
   * @param country country or {@code null} for none
   */
  public OrdersCreateTestOrderRequest setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * The test order template to use. Specify as an alternative to `testOrder` as a shortcut for
   * retrieving a template and then creating an order using that template. Acceptable values are: -
   * "`template1`" - "`template1a`" - "`template1b`" - "`template2`" - "`template3`"
   * @return value or {@code null} for none
   */
  public java.lang.String getTemplateName() {
    return templateName;
  }

  /**
   * The test order template to use. Specify as an alternative to `testOrder` as a shortcut for
   * retrieving a template and then creating an order using that template. Acceptable values are: -
   * "`template1`" - "`template1a`" - "`template1b`" - "`template2`" - "`template3`"
   * @param templateName templateName or {@code null} for none
   */
  public OrdersCreateTestOrderRequest setTemplateName(java.lang.String templateName) {
    this.templateName = templateName;
    return this;
  }

  /**
   * The test order to create.
   * @return value or {@code null} for none
   */
  public TestOrder getTestOrder() {
    return testOrder;
  }

  /**
   * The test order to create.
   * @param testOrder testOrder or {@code null} for none
   */
  public OrdersCreateTestOrderRequest setTestOrder(TestOrder testOrder) {
    this.testOrder = testOrder;
    return this;
  }

  @Override
  public OrdersCreateTestOrderRequest set(String fieldName, Object value) {
    return (OrdersCreateTestOrderRequest) super.set(fieldName, value);
  }

  @Override
  public OrdersCreateTestOrderRequest clone() {
    return (OrdersCreateTestOrderRequest) super.clone();
  }

}
