/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for OrdersRefundOrderRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrdersRefundOrderRequest extends com.google.api.client.json.GenericJson {

  /**
   * The amount that is refunded. If this is not the first refund for the order, this should be the
   * newly refunded amount.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MonetaryAmount amount;

  /**
   * If true, the full order will be refunded, including shipping. If this is true, amount shouldn't
   * be provided and will be ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean fullRefund;

  /**
   * The ID of the operation. Unique across all operations for a given order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String operationId;

  /**
   * The reason for the refund. Acceptable values are: - "`courtesyAdjustment`" - "`other`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * The explanation of the reason.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reasonText;

  /**
   * The amount that is refunded. If this is not the first refund for the order, this should be the
   * newly refunded amount.
   * @return value or {@code null} for none
   */
  public MonetaryAmount getAmount() {
    return amount;
  }

  /**
   * The amount that is refunded. If this is not the first refund for the order, this should be the
   * newly refunded amount.
   * @param amount amount or {@code null} for none
   */
  public OrdersRefundOrderRequest setAmount(MonetaryAmount amount) {
    this.amount = amount;
    return this;
  }

  /**
   * If true, the full order will be refunded, including shipping. If this is true, amount shouldn't
   * be provided and will be ignored.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFullRefund() {
    return fullRefund;
  }

  /**
   * If true, the full order will be refunded, including shipping. If this is true, amount shouldn't
   * be provided and will be ignored.
   * @param fullRefund fullRefund or {@code null} for none
   */
  public OrdersRefundOrderRequest setFullRefund(java.lang.Boolean fullRefund) {
    this.fullRefund = fullRefund;
    return this;
  }

  /**
   * The ID of the operation. Unique across all operations for a given order.
   * @return value or {@code null} for none
   */
  public java.lang.String getOperationId() {
    return operationId;
  }

  /**
   * The ID of the operation. Unique across all operations for a given order.
   * @param operationId operationId or {@code null} for none
   */
  public OrdersRefundOrderRequest setOperationId(java.lang.String operationId) {
    this.operationId = operationId;
    return this;
  }

  /**
   * The reason for the refund. Acceptable values are: - "`courtesyAdjustment`" - "`other`"
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * The reason for the refund. Acceptable values are: - "`courtesyAdjustment`" - "`other`"
   * @param reason reason or {@code null} for none
   */
  public OrdersRefundOrderRequest setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The explanation of the reason.
   * @return value or {@code null} for none
   */
  public java.lang.String getReasonText() {
    return reasonText;
  }

  /**
   * The explanation of the reason.
   * @param reasonText reasonText or {@code null} for none
   */
  public OrdersRefundOrderRequest setReasonText(java.lang.String reasonText) {
    this.reasonText = reasonText;
    return this;
  }

  @Override
  public OrdersRefundOrderRequest set(String fieldName, Object value) {
    return (OrdersRefundOrderRequest) super.set(fieldName, value);
  }

  @Override
  public OrdersRefundOrderRequest clone() {
    return (OrdersRefundOrderRequest) super.clone();
  }

}
