/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Price Competitiveness fields requested by the merchant in the query. Field values are only set if
 * the merchant queries `PriceCompetitivenessProductView`.
 * https://support.google.com/merchants/answer/9626903
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PriceCompetitiveness extends com.google.api.client.json.GenericJson {

  /**
   * The price benchmark currency (ISO 4217 code).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String benchmarkPriceCurrencyCode;

  /**
   * The latest available price benchmark in micros for the product's catalog in the benchmark
   * country.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long benchmarkPriceMicros;

  /**
   * The country of the price benchmark (ISO 3166 code).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * The price benchmark currency (ISO 4217 code).
   * @return value or {@code null} for none
   */
  public java.lang.String getBenchmarkPriceCurrencyCode() {
    return benchmarkPriceCurrencyCode;
  }

  /**
   * The price benchmark currency (ISO 4217 code).
   * @param benchmarkPriceCurrencyCode benchmarkPriceCurrencyCode or {@code null} for none
   */
  public PriceCompetitiveness setBenchmarkPriceCurrencyCode(java.lang.String benchmarkPriceCurrencyCode) {
    this.benchmarkPriceCurrencyCode = benchmarkPriceCurrencyCode;
    return this;
  }

  /**
   * The latest available price benchmark in micros for the product's catalog in the benchmark
   * country.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBenchmarkPriceMicros() {
    return benchmarkPriceMicros;
  }

  /**
   * The latest available price benchmark in micros for the product's catalog in the benchmark
   * country.
   * @param benchmarkPriceMicros benchmarkPriceMicros or {@code null} for none
   */
  public PriceCompetitiveness setBenchmarkPriceMicros(java.lang.Long benchmarkPriceMicros) {
    this.benchmarkPriceMicros = benchmarkPriceMicros;
    return this;
  }

  /**
   * The country of the price benchmark (ISO 3166 code).
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * The country of the price benchmark (ISO 3166 code).
   * @param countryCode countryCode or {@code null} for none
   */
  public PriceCompetitiveness setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  @Override
  public PriceCompetitiveness set(String fieldName, Object value) {
    return (PriceCompetitiveness) super.set(fieldName, value);
  }

  @Override
  public PriceCompetitiveness clone() {
    return (PriceCompetitiveness) super.clone();
  }

}
