/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A delivery time for this product.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductDeliveryTimeAreaDeliveryTimeDeliveryTime extends com.google.api.client.json.GenericJson {

  /**
   * Required. The maximum number of business days (inclusive) between when an order is placed and
   * when the product ships. If a product ships in the same day, set this value to 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxHandlingTimeDays;

  /**
   * Required. The maximum number of business days (inclusive) between when the product ships and
   * when the product is delivered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxTransitTimeDays;

  /**
   * Required. The minimum number of business days (inclusive) between when an order is placed and
   * when the product ships. If a product ships in the same day, set this value to 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minHandlingTimeDays;

  /**
   * Required. The minimum number of business days (inclusive) between when the product ships and
   * when the product is delivered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minTransitTimeDays;

  /**
   * Required. The maximum number of business days (inclusive) between when an order is placed and
   * when the product ships. If a product ships in the same day, set this value to 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxHandlingTimeDays() {
    return maxHandlingTimeDays;
  }

  /**
   * Required. The maximum number of business days (inclusive) between when an order is placed and
   * when the product ships. If a product ships in the same day, set this value to 0.
   * @param maxHandlingTimeDays maxHandlingTimeDays or {@code null} for none
   */
  public ProductDeliveryTimeAreaDeliveryTimeDeliveryTime setMaxHandlingTimeDays(java.lang.Integer maxHandlingTimeDays) {
    this.maxHandlingTimeDays = maxHandlingTimeDays;
    return this;
  }

  /**
   * Required. The maximum number of business days (inclusive) between when the product ships and
   * when the product is delivered.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxTransitTimeDays() {
    return maxTransitTimeDays;
  }

  /**
   * Required. The maximum number of business days (inclusive) between when the product ships and
   * when the product is delivered.
   * @param maxTransitTimeDays maxTransitTimeDays or {@code null} for none
   */
  public ProductDeliveryTimeAreaDeliveryTimeDeliveryTime setMaxTransitTimeDays(java.lang.Integer maxTransitTimeDays) {
    this.maxTransitTimeDays = maxTransitTimeDays;
    return this;
  }

  /**
   * Required. The minimum number of business days (inclusive) between when an order is placed and
   * when the product ships. If a product ships in the same day, set this value to 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinHandlingTimeDays() {
    return minHandlingTimeDays;
  }

  /**
   * Required. The minimum number of business days (inclusive) between when an order is placed and
   * when the product ships. If a product ships in the same day, set this value to 0.
   * @param minHandlingTimeDays minHandlingTimeDays or {@code null} for none
   */
  public ProductDeliveryTimeAreaDeliveryTimeDeliveryTime setMinHandlingTimeDays(java.lang.Integer minHandlingTimeDays) {
    this.minHandlingTimeDays = minHandlingTimeDays;
    return this;
  }

  /**
   * Required. The minimum number of business days (inclusive) between when the product ships and
   * when the product is delivered.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinTransitTimeDays() {
    return minTransitTimeDays;
  }

  /**
   * Required. The minimum number of business days (inclusive) between when the product ships and
   * when the product is delivered.
   * @param minTransitTimeDays minTransitTimeDays or {@code null} for none
   */
  public ProductDeliveryTimeAreaDeliveryTimeDeliveryTime setMinTransitTimeDays(java.lang.Integer minTransitTimeDays) {
    this.minTransitTimeDays = minTransitTimeDays;
    return this;
  }

  @Override
  public ProductDeliveryTimeAreaDeliveryTimeDeliveryTime set(String fieldName, Object value) {
    return (ProductDeliveryTimeAreaDeliveryTimeDeliveryTime) super.set(fieldName, value);
  }

  @Override
  public ProductDeliveryTimeAreaDeliveryTimeDeliveryTime clone() {
    return (ProductDeliveryTimeAreaDeliveryTimeDeliveryTime) super.clone();
  }

}
