/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The Content API ID of the product.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductId extends com.google.api.client.json.GenericJson {

  /**
   * The Content API ID of the product, in the form `channel:contentLanguage:targetCountry:offerId`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productId;

  /**
   * The Content API ID of the product, in the form `channel:contentLanguage:targetCountry:offerId`.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductId() {
    return productId;
  }

  /**
   * The Content API ID of the product, in the form `channel:contentLanguage:targetCountry:offerId`.
   * @param productId productId or {@code null} for none
   */
  public ProductId setProductId(java.lang.String productId) {
    this.productId = productId;
    return this;
  }

  @Override
  public ProductId set(String fieldName, Object value) {
    return (ProductId) super.set(fieldName, value);
  }

  @Override
  public ProductId clone() {
    return (ProductId) super.clone();
  }

}
