/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for ProductTax.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductTax extends com.google.api.client.json.GenericJson {

  /**
   * The country within which the item is taxed, specified as a CLDR territory code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String country;

  /**
   * The numeric ID of a location that the tax rate applies to as defined in the AdWords API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long locationId;

  /**
   * The postal code range that the tax rate applies to, represented by a ZIP code, a ZIP code
   * prefix using * wildcard, a range between two ZIP codes or two ZIP code prefixes of equal
   * length. Examples: 94114, 94*, 94002-95460, 94*-95*.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String postalCode;

  /**
   * The percentage of tax rate that applies to the item price.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double rate;

  /**
   * The geographic region to which the tax rate applies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * Should be set to true if tax is charged on shipping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean taxShip;

  /**
   * The country within which the item is taxed, specified as a CLDR territory code.
   * @return value or {@code null} for none
   */
  public java.lang.String getCountry() {
    return country;
  }

  /**
   * The country within which the item is taxed, specified as a CLDR territory code.
   * @param country country or {@code null} for none
   */
  public ProductTax setCountry(java.lang.String country) {
    this.country = country;
    return this;
  }

  /**
   * The numeric ID of a location that the tax rate applies to as defined in the AdWords API.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLocationId() {
    return locationId;
  }

  /**
   * The numeric ID of a location that the tax rate applies to as defined in the AdWords API.
   * @param locationId locationId or {@code null} for none
   */
  public ProductTax setLocationId(java.lang.Long locationId) {
    this.locationId = locationId;
    return this;
  }

  /**
   * The postal code range that the tax rate applies to, represented by a ZIP code, a ZIP code
   * prefix using * wildcard, a range between two ZIP codes or two ZIP code prefixes of equal
   * length. Examples: 94114, 94*, 94002-95460, 94*-95*.
   * @return value or {@code null} for none
   */
  public java.lang.String getPostalCode() {
    return postalCode;
  }

  /**
   * The postal code range that the tax rate applies to, represented by a ZIP code, a ZIP code
   * prefix using * wildcard, a range between two ZIP codes or two ZIP code prefixes of equal
   * length. Examples: 94114, 94*, 94002-95460, 94*-95*.
   * @param postalCode postalCode or {@code null} for none
   */
  public ProductTax setPostalCode(java.lang.String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

  /**
   * The percentage of tax rate that applies to the item price.
   * @return value or {@code null} for none
   */
  public java.lang.Double getRate() {
    return rate;
  }

  /**
   * The percentage of tax rate that applies to the item price.
   * @param rate rate or {@code null} for none
   */
  public ProductTax setRate(java.lang.Double rate) {
    this.rate = rate;
    return this;
  }

  /**
   * The geographic region to which the tax rate applies.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * The geographic region to which the tax rate applies.
   * @param region region or {@code null} for none
   */
  public ProductTax setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * Should be set to true if tax is charged on shipping.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTaxShip() {
    return taxShip;
  }

  /**
   * Should be set to true if tax is charged on shipping.
   * @param taxShip taxShip or {@code null} for none
   */
  public ProductTax setTaxShip(java.lang.Boolean taxShip) {
    this.taxShip = taxShip;
    return this;
  }

  @Override
  public ProductTax set(String fieldName, Object value) {
    return (ProductTax) super.set(fieldName, value);
  }

  @Override
  public ProductTax clone() {
    return (ProductTax) super.clone();
  }

}
