/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Item issue associated with the product.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductViewItemIssue extends com.google.api.client.json.GenericJson {

  /**
   * Item issue type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductViewItemIssueItemIssueType issueType;

  /**
   * Item issue resolution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resolution;

  /**
   * Item issue severity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProductViewItemIssueItemIssueSeverity severity;

  /**
   * Item issue type.
   * @return value or {@code null} for none
   */
  public ProductViewItemIssueItemIssueType getIssueType() {
    return issueType;
  }

  /**
   * Item issue type.
   * @param issueType issueType or {@code null} for none
   */
  public ProductViewItemIssue setIssueType(ProductViewItemIssueItemIssueType issueType) {
    this.issueType = issueType;
    return this;
  }

  /**
   * Item issue resolution.
   * @return value or {@code null} for none
   */
  public java.lang.String getResolution() {
    return resolution;
  }

  /**
   * Item issue resolution.
   * @param resolution resolution or {@code null} for none
   */
  public ProductViewItemIssue setResolution(java.lang.String resolution) {
    this.resolution = resolution;
    return this;
  }

  /**
   * Item issue severity.
   * @return value or {@code null} for none
   */
  public ProductViewItemIssueItemIssueSeverity getSeverity() {
    return severity;
  }

  /**
   * Item issue severity.
   * @param severity severity or {@code null} for none
   */
  public ProductViewItemIssue setSeverity(ProductViewItemIssueItemIssueSeverity severity) {
    this.severity = severity;
    return this;
  }

  @Override
  public ProductViewItemIssue set(String fieldName, Object value) {
    return (ProductViewItemIssue) super.set(fieldName, value);
  }

  @Override
  public ProductViewItemIssue clone() {
    return (ProductViewItemIssue) super.clone();
  }

}
