/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A range of postal codes that defines the region area.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionPostalCodeAreaPostalCodeRange extends com.google.api.client.json.GenericJson {

  /**
   * Required. A postal code or a pattern of the form prefix* denoting the inclusive lower bound of
   * the range defining the area. Examples values: "94108", "9410*", "9*".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String begin;

  /**
   * Optional. A postal code or a pattern of the form prefix* denoting the inclusive upper bound of
   * the range defining the area. It must have the same length as postalCodeRangeBegin: if
   * postalCodeRangeBegin is a postal code then postalCodeRangeEnd must be a postal code too; if
   * postalCodeRangeBegin is a pattern then postalCodeRangeEnd must be a pattern with the same
   * prefix length. Optional: if not set, then the area is defined as being all the postal codes
   * matching postalCodeRangeBegin.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String end;

  /**
   * Required. A postal code or a pattern of the form prefix* denoting the inclusive lower bound of
   * the range defining the area. Examples values: "94108", "9410*", "9*".
   * @return value or {@code null} for none
   */
  public java.lang.String getBegin() {
    return begin;
  }

  /**
   * Required. A postal code or a pattern of the form prefix* denoting the inclusive lower bound of
   * the range defining the area. Examples values: "94108", "9410*", "9*".
   * @param begin begin or {@code null} for none
   */
  public RegionPostalCodeAreaPostalCodeRange setBegin(java.lang.String begin) {
    this.begin = begin;
    return this;
  }

  /**
   * Optional. A postal code or a pattern of the form prefix* denoting the inclusive upper bound of
   * the range defining the area. It must have the same length as postalCodeRangeBegin: if
   * postalCodeRangeBegin is a postal code then postalCodeRangeEnd must be a postal code too; if
   * postalCodeRangeBegin is a pattern then postalCodeRangeEnd must be a pattern with the same
   * prefix length. Optional: if not set, then the area is defined as being all the postal codes
   * matching postalCodeRangeBegin.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnd() {
    return end;
  }

  /**
   * Optional. A postal code or a pattern of the form prefix* denoting the inclusive upper bound of
   * the range defining the area. It must have the same length as postalCodeRangeBegin: if
   * postalCodeRangeBegin is a postal code then postalCodeRangeEnd must be a postal code too; if
   * postalCodeRangeBegin is a pattern then postalCodeRangeEnd must be a pattern with the same
   * prefix length. Optional: if not set, then the area is defined as being all the postal codes
   * matching postalCodeRangeBegin.
   * @param end end or {@code null} for none
   */
  public RegionPostalCodeAreaPostalCodeRange setEnd(java.lang.String end) {
    this.end = end;
    return this;
  }

  @Override
  public RegionPostalCodeAreaPostalCodeRange set(String fieldName, Object value) {
    return (RegionPostalCodeAreaPostalCodeRange) super.set(fieldName, value);
  }

  @Override
  public RegionPostalCodeAreaPostalCodeRange clone() {
    return (RegionPostalCodeAreaPostalCodeRange) super.clone();
  }

}
