/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Resource that represents a daily Repricing product report. Each report contains stats for a
 * single type of Repricing rule for a single product on a given day. If there are multiple rules of
 * the same type for the product on that day, the report lists all the rules by rule ids, combines
 * the stats, and paginates the results by date. To retrieve the stats of a particular rule, provide
 * the rule_id in the request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RepricingProductReport extends com.google.api.client.json.GenericJson {

  /**
   * Total count of Repricer applications. This value captures how many times the rule of this type
   * was applied to this product during this reporting period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long applicationCount;

  /**
   * Stats specific to buybox winning rules for product report (deprecated).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepricingProductReportBuyboxWinningProductStats buyboxWinningProductStats;

  /**
   * Date of the stats in this report. The report starts and ends according to the merchant's
   * timezone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date date;

  /**
   * Maximum displayed price after repriced during this reporting period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PriceAmount highWatermark;

  /**
   * List of all reasons the rule did not apply to the product during the specified reporting
   * period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InapplicabilityDetails> inapplicabilityDetails;

  static {
    // hack to force ProGuard to consider InapplicabilityDetails used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(InapplicabilityDetails.class);
  }

  /**
   * Minimum displayed price after repriced during this reporting period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PriceAmount lowWatermark;

  /**
   * Total unit count of impacted products ordered while the rule was active on the date of the
   * report. This count includes all orders that were started while the rule was active, even if the
   * rule was no longer active when the order was completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer orderItemCount;

  /**
   * Ids of the Repricing rule for this report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> ruleIds;

  /**
   * Total GMV generated by impacted products while the rule was active on the date of the report.
   * This value includes all orders that were started while the rule was active, even if the rule
   * was no longer active when the order was completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PriceAmount totalGmv;

  /**
   * Type of the rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Total count of Repricer applications. This value captures how many times the rule of this type
   * was applied to this product during this reporting period.
   * @return value or {@code null} for none
   */
  public java.lang.Long getApplicationCount() {
    return applicationCount;
  }

  /**
   * Total count of Repricer applications. This value captures how many times the rule of this type
   * was applied to this product during this reporting period.
   * @param applicationCount applicationCount or {@code null} for none
   */
  public RepricingProductReport setApplicationCount(java.lang.Long applicationCount) {
    this.applicationCount = applicationCount;
    return this;
  }

  /**
   * Stats specific to buybox winning rules for product report (deprecated).
   * @return value or {@code null} for none
   */
  public RepricingProductReportBuyboxWinningProductStats getBuyboxWinningProductStats() {
    return buyboxWinningProductStats;
  }

  /**
   * Stats specific to buybox winning rules for product report (deprecated).
   * @param buyboxWinningProductStats buyboxWinningProductStats or {@code null} for none
   */
  public RepricingProductReport setBuyboxWinningProductStats(RepricingProductReportBuyboxWinningProductStats buyboxWinningProductStats) {
    this.buyboxWinningProductStats = buyboxWinningProductStats;
    return this;
  }

  /**
   * Date of the stats in this report. The report starts and ends according to the merchant's
   * timezone.
   * @return value or {@code null} for none
   */
  public Date getDate() {
    return date;
  }

  /**
   * Date of the stats in this report. The report starts and ends according to the merchant's
   * timezone.
   * @param date date or {@code null} for none
   */
  public RepricingProductReport setDate(Date date) {
    this.date = date;
    return this;
  }

  /**
   * Maximum displayed price after repriced during this reporting period.
   * @return value or {@code null} for none
   */
  public PriceAmount getHighWatermark() {
    return highWatermark;
  }

  /**
   * Maximum displayed price after repriced during this reporting period.
   * @param highWatermark highWatermark or {@code null} for none
   */
  public RepricingProductReport setHighWatermark(PriceAmount highWatermark) {
    this.highWatermark = highWatermark;
    return this;
  }

  /**
   * List of all reasons the rule did not apply to the product during the specified reporting
   * period.
   * @return value or {@code null} for none
   */
  public java.util.List<InapplicabilityDetails> getInapplicabilityDetails() {
    return inapplicabilityDetails;
  }

  /**
   * List of all reasons the rule did not apply to the product during the specified reporting
   * period.
   * @param inapplicabilityDetails inapplicabilityDetails or {@code null} for none
   */
  public RepricingProductReport setInapplicabilityDetails(java.util.List<InapplicabilityDetails> inapplicabilityDetails) {
    this.inapplicabilityDetails = inapplicabilityDetails;
    return this;
  }

  /**
   * Minimum displayed price after repriced during this reporting period.
   * @return value or {@code null} for none
   */
  public PriceAmount getLowWatermark() {
    return lowWatermark;
  }

  /**
   * Minimum displayed price after repriced during this reporting period.
   * @param lowWatermark lowWatermark or {@code null} for none
   */
  public RepricingProductReport setLowWatermark(PriceAmount lowWatermark) {
    this.lowWatermark = lowWatermark;
    return this;
  }

  /**
   * Total unit count of impacted products ordered while the rule was active on the date of the
   * report. This count includes all orders that were started while the rule was active, even if the
   * rule was no longer active when the order was completed.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOrderItemCount() {
    return orderItemCount;
  }

  /**
   * Total unit count of impacted products ordered while the rule was active on the date of the
   * report. This count includes all orders that were started while the rule was active, even if the
   * rule was no longer active when the order was completed.
   * @param orderItemCount orderItemCount or {@code null} for none
   */
  public RepricingProductReport setOrderItemCount(java.lang.Integer orderItemCount) {
    this.orderItemCount = orderItemCount;
    return this;
  }

  /**
   * Ids of the Repricing rule for this report.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRuleIds() {
    return ruleIds;
  }

  /**
   * Ids of the Repricing rule for this report.
   * @param ruleIds ruleIds or {@code null} for none
   */
  public RepricingProductReport setRuleIds(java.util.List<java.lang.String> ruleIds) {
    this.ruleIds = ruleIds;
    return this;
  }

  /**
   * Total GMV generated by impacted products while the rule was active on the date of the report.
   * This value includes all orders that were started while the rule was active, even if the rule
   * was no longer active when the order was completed.
   * @return value or {@code null} for none
   */
  public PriceAmount getTotalGmv() {
    return totalGmv;
  }

  /**
   * Total GMV generated by impacted products while the rule was active on the date of the report.
   * This value includes all orders that were started while the rule was active, even if the rule
   * was no longer active when the order was completed.
   * @param totalGmv totalGmv or {@code null} for none
   */
  public RepricingProductReport setTotalGmv(PriceAmount totalGmv) {
    this.totalGmv = totalGmv;
    return this;
  }

  /**
   * Type of the rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of the rule.
   * @param type type or {@code null} for none
   */
  public RepricingProductReport setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public RepricingProductReport set(String fieldName, Object value) {
    return (RepricingProductReport) super.set(fieldName, value);
  }

  @Override
  public RepricingProductReport clone() {
    return (RepricingProductReport) super.clone();
  }

}
