/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Represents a repricing rule. A repricing rule is used by shopping serving to adjust transactable
 * offer prices if conditions are met. Next ID: 24
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RepricingRule extends com.google.api.client.json.GenericJson {

  /**
   * The rule definition for TYPE_COGS_BASED. Required when the rule type is TYPE_COGS_BASED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepricingRuleCostOfGoodsSaleRule cogsBasedRule;

  /**
   * Required. Immutable. [CLDR country
   * code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) (e.g. "US").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String countryCode;

  /**
   * Required. Time period when the rule should take effect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepricingRuleEffectiveTime effectiveTimePeriod;

  /**
   * Required. Match criteria for the eligible offers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepricingRuleEligibleOfferMatcher eligibleOfferMatcher;

  /**
   * Required. Immutable. The two-letter ISO 639-1 language code associated with the repricing rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Output only. Immutable. Merchant that owns the repricing rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long merchantId;

  /**
   * Represents whether a rule is paused. A paused rule will behave like a non-paused rule within
   * CRUD operations, with the major difference that a paused rule will not be evaluated and will
   * have no effect on offers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean paused;

  /**
   * Required. Restriction of the rule appliance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepricingRuleRestriction restriction;

  /**
   * Output only. Immutable. The ID to uniquely identify each repricing rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ruleId;

  /**
   * The rule definition for TYPE_STATS_BASED. Required when the rule type is TYPE_STATS_BASED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepricingRuleStatsBasedRule statsBasedRule;

  /**
   * The title for the rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Required. Immutable. The type of the rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The rule definition for TYPE_COGS_BASED. Required when the rule type is TYPE_COGS_BASED.
   * @return value or {@code null} for none
   */
  public RepricingRuleCostOfGoodsSaleRule getCogsBasedRule() {
    return cogsBasedRule;
  }

  /**
   * The rule definition for TYPE_COGS_BASED. Required when the rule type is TYPE_COGS_BASED.
   * @param cogsBasedRule cogsBasedRule or {@code null} for none
   */
  public RepricingRule setCogsBasedRule(RepricingRuleCostOfGoodsSaleRule cogsBasedRule) {
    this.cogsBasedRule = cogsBasedRule;
    return this;
  }

  /**
   * Required. Immutable. [CLDR country
   * code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) (e.g. "US").
   * @return value or {@code null} for none
   */
  public java.lang.String getCountryCode() {
    return countryCode;
  }

  /**
   * Required. Immutable. [CLDR country
   * code](http://www.unicode.org/repos/cldr/tags/latest/common/main/en.xml) (e.g. "US").
   * @param countryCode countryCode or {@code null} for none
   */
  public RepricingRule setCountryCode(java.lang.String countryCode) {
    this.countryCode = countryCode;
    return this;
  }

  /**
   * Required. Time period when the rule should take effect.
   * @return value or {@code null} for none
   */
  public RepricingRuleEffectiveTime getEffectiveTimePeriod() {
    return effectiveTimePeriod;
  }

  /**
   * Required. Time period when the rule should take effect.
   * @param effectiveTimePeriod effectiveTimePeriod or {@code null} for none
   */
  public RepricingRule setEffectiveTimePeriod(RepricingRuleEffectiveTime effectiveTimePeriod) {
    this.effectiveTimePeriod = effectiveTimePeriod;
    return this;
  }

  /**
   * Required. Match criteria for the eligible offers.
   * @return value or {@code null} for none
   */
  public RepricingRuleEligibleOfferMatcher getEligibleOfferMatcher() {
    return eligibleOfferMatcher;
  }

  /**
   * Required. Match criteria for the eligible offers.
   * @param eligibleOfferMatcher eligibleOfferMatcher or {@code null} for none
   */
  public RepricingRule setEligibleOfferMatcher(RepricingRuleEligibleOfferMatcher eligibleOfferMatcher) {
    this.eligibleOfferMatcher = eligibleOfferMatcher;
    return this;
  }

  /**
   * Required. Immutable. The two-letter ISO 639-1 language code associated with the repricing rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * Required. Immutable. The two-letter ISO 639-1 language code associated with the repricing rule.
   * @param languageCode languageCode or {@code null} for none
   */
  public RepricingRule setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * Output only. Immutable. Merchant that owns the repricing rule.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMerchantId() {
    return merchantId;
  }

  /**
   * Output only. Immutable. Merchant that owns the repricing rule.
   * @param merchantId merchantId or {@code null} for none
   */
  public RepricingRule setMerchantId(java.lang.Long merchantId) {
    this.merchantId = merchantId;
    return this;
  }

  /**
   * Represents whether a rule is paused. A paused rule will behave like a non-paused rule within
   * CRUD operations, with the major difference that a paused rule will not be evaluated and will
   * have no effect on offers.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPaused() {
    return paused;
  }

  /**
   * Represents whether a rule is paused. A paused rule will behave like a non-paused rule within
   * CRUD operations, with the major difference that a paused rule will not be evaluated and will
   * have no effect on offers.
   * @param paused paused or {@code null} for none
   */
  public RepricingRule setPaused(java.lang.Boolean paused) {
    this.paused = paused;
    return this;
  }

  /**
   * Required. Restriction of the rule appliance.
   * @return value or {@code null} for none
   */
  public RepricingRuleRestriction getRestriction() {
    return restriction;
  }

  /**
   * Required. Restriction of the rule appliance.
   * @param restriction restriction or {@code null} for none
   */
  public RepricingRule setRestriction(RepricingRuleRestriction restriction) {
    this.restriction = restriction;
    return this;
  }

  /**
   * Output only. Immutable. The ID to uniquely identify each repricing rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getRuleId() {
    return ruleId;
  }

  /**
   * Output only. Immutable. The ID to uniquely identify each repricing rule.
   * @param ruleId ruleId or {@code null} for none
   */
  public RepricingRule setRuleId(java.lang.String ruleId) {
    this.ruleId = ruleId;
    return this;
  }

  /**
   * The rule definition for TYPE_STATS_BASED. Required when the rule type is TYPE_STATS_BASED.
   * @return value or {@code null} for none
   */
  public RepricingRuleStatsBasedRule getStatsBasedRule() {
    return statsBasedRule;
  }

  /**
   * The rule definition for TYPE_STATS_BASED. Required when the rule type is TYPE_STATS_BASED.
   * @param statsBasedRule statsBasedRule or {@code null} for none
   */
  public RepricingRule setStatsBasedRule(RepricingRuleStatsBasedRule statsBasedRule) {
    this.statsBasedRule = statsBasedRule;
    return this;
  }

  /**
   * The title for the rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title for the rule.
   * @param title title or {@code null} for none
   */
  public RepricingRule setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * Required. Immutable. The type of the rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Required. Immutable. The type of the rule.
   * @param type type or {@code null} for none
   */
  public RepricingRule setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public RepricingRule set(String fieldName, Object value) {
    return (RepricingRule) super.set(fieldName, value);
  }

  @Override
  public RepricingRule clone() {
    return (RepricingRule) super.clone();
  }

}
