/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A repricing rule that changes the sale price based on cost of goods sale.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RepricingRuleCostOfGoodsSaleRule extends com.google.api.client.json.GenericJson {

  /**
   * The percent change against the COGS. Ex: 20 would mean to set the adjusted price 1.2X of the
   * COGS data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer percentageDelta;

  /**
   * The price delta against the COGS. E.g. 2 means $2 more of the COGS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String priceDelta;

  /**
   * The percent change against the COGS. Ex: 20 would mean to set the adjusted price 1.2X of the
   * COGS data.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPercentageDelta() {
    return percentageDelta;
  }

  /**
   * The percent change against the COGS. Ex: 20 would mean to set the adjusted price 1.2X of the
   * COGS data.
   * @param percentageDelta percentageDelta or {@code null} for none
   */
  public RepricingRuleCostOfGoodsSaleRule setPercentageDelta(java.lang.Integer percentageDelta) {
    this.percentageDelta = percentageDelta;
    return this;
  }

  /**
   * The price delta against the COGS. E.g. 2 means $2 more of the COGS.
   * @return value or {@code null} for none
   */
  public java.lang.String getPriceDelta() {
    return priceDelta;
  }

  /**
   * The price delta against the COGS. E.g. 2 means $2 more of the COGS.
   * @param priceDelta priceDelta or {@code null} for none
   */
  public RepricingRuleCostOfGoodsSaleRule setPriceDelta(java.lang.String priceDelta) {
    this.priceDelta = priceDelta;
    return this;
  }

  @Override
  public RepricingRuleCostOfGoodsSaleRule set(String fieldName, Object value) {
    return (RepricingRuleCostOfGoodsSaleRule) super.set(fieldName, value);
  }

  @Override
  public RepricingRuleCostOfGoodsSaleRule clone() {
    return (RepricingRuleCostOfGoodsSaleRule) super.clone();
  }

}
