/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Matcher that specifies eligible offers. When the USE_FEED_ATTRIBUTE option is selected, only the
 * repricing_rule_id attribute on the product feed is used to specify offer-rule mapping. When the
 * CUSTOM_FILTER option is selected, only the *_matcher fields are used to filter the offers for
 * offer-rule mapping. If the CUSTOM_FILTER option is selected, an offer needs to satisfy each
 * custom filter matcher to be eligible for a rule. Size limit: the sum of the number of entries in
 * all the matchers should not exceed 20. For example, there can be 15 product ids and 5 brands, but
 * not 10 product ids and 11 brands.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RepricingRuleEligibleOfferMatcher extends com.google.api.client.json.GenericJson {

  /**
   * Filter by the brand.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepricingRuleEligibleOfferMatcherStringMatcher brandMatcher;

  /**
   * Filter by the item group id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepricingRuleEligibleOfferMatcherStringMatcher itemGroupIdMatcher;

  /**
   * Determines whether to use the custom matchers or the product feed attribute "repricing_rule_id"
   * to specify offer-rule mapping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String matcherOption;

  /**
   * Filter by the offer id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepricingRuleEligibleOfferMatcherStringMatcher offerIdMatcher;

  /**
   * When true, the rule won't be applied to offers with active promotions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean skipWhenOnPromotion;

  /**
   * Filter by the brand.
   * @return value or {@code null} for none
   */
  public RepricingRuleEligibleOfferMatcherStringMatcher getBrandMatcher() {
    return brandMatcher;
  }

  /**
   * Filter by the brand.
   * @param brandMatcher brandMatcher or {@code null} for none
   */
  public RepricingRuleEligibleOfferMatcher setBrandMatcher(RepricingRuleEligibleOfferMatcherStringMatcher brandMatcher) {
    this.brandMatcher = brandMatcher;
    return this;
  }

  /**
   * Filter by the item group id.
   * @return value or {@code null} for none
   */
  public RepricingRuleEligibleOfferMatcherStringMatcher getItemGroupIdMatcher() {
    return itemGroupIdMatcher;
  }

  /**
   * Filter by the item group id.
   * @param itemGroupIdMatcher itemGroupIdMatcher or {@code null} for none
   */
  public RepricingRuleEligibleOfferMatcher setItemGroupIdMatcher(RepricingRuleEligibleOfferMatcherStringMatcher itemGroupIdMatcher) {
    this.itemGroupIdMatcher = itemGroupIdMatcher;
    return this;
  }

  /**
   * Determines whether to use the custom matchers or the product feed attribute "repricing_rule_id"
   * to specify offer-rule mapping.
   * @return value or {@code null} for none
   */
  public java.lang.String getMatcherOption() {
    return matcherOption;
  }

  /**
   * Determines whether to use the custom matchers or the product feed attribute "repricing_rule_id"
   * to specify offer-rule mapping.
   * @param matcherOption matcherOption or {@code null} for none
   */
  public RepricingRuleEligibleOfferMatcher setMatcherOption(java.lang.String matcherOption) {
    this.matcherOption = matcherOption;
    return this;
  }

  /**
   * Filter by the offer id.
   * @return value or {@code null} for none
   */
  public RepricingRuleEligibleOfferMatcherStringMatcher getOfferIdMatcher() {
    return offerIdMatcher;
  }

  /**
   * Filter by the offer id.
   * @param offerIdMatcher offerIdMatcher or {@code null} for none
   */
  public RepricingRuleEligibleOfferMatcher setOfferIdMatcher(RepricingRuleEligibleOfferMatcherStringMatcher offerIdMatcher) {
    this.offerIdMatcher = offerIdMatcher;
    return this;
  }

  /**
   * When true, the rule won't be applied to offers with active promotions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSkipWhenOnPromotion() {
    return skipWhenOnPromotion;
  }

  /**
   * When true, the rule won't be applied to offers with active promotions.
   * @param skipWhenOnPromotion skipWhenOnPromotion or {@code null} for none
   */
  public RepricingRuleEligibleOfferMatcher setSkipWhenOnPromotion(java.lang.Boolean skipWhenOnPromotion) {
    this.skipWhenOnPromotion = skipWhenOnPromotion;
    return this;
  }

  @Override
  public RepricingRuleEligibleOfferMatcher set(String fieldName, Object value) {
    return (RepricingRuleEligibleOfferMatcher) super.set(fieldName, value);
  }

  @Override
  public RepricingRuleEligibleOfferMatcher clone() {
    return (RepricingRuleEligibleOfferMatcher) super.clone();
  }

}
