/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Resource that represents a daily Repricing rule report. Next ID: 11
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RepricingRuleReport extends com.google.api.client.json.GenericJson {

  /**
   * Stats specific to buybox winning rules for rule report (deprecated).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RepricingRuleReportBuyboxWinningRuleStats buyboxWinningRuleStats;

  /**
   * Date of the stats in this report. The report starts and ends according to the merchant's
   * timezone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date date;

  /**
   * List of product ids that are impacted by this rule during this reporting period. Out of stock
   * products and products not searched for by customers are examples of non-impacted products.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> impactedProducts;

  /**
   * List of all reasons the rule did not apply to the inapplicable products during the specified
   * reporting period.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InapplicabilityDetails> inapplicabilityDetails;

  static {
    // hack to force ProGuard to consider InapplicabilityDetails used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(InapplicabilityDetails.class);
  }

  /**
   * List of product ids that are inapplicable to this rule during this reporting period. To get the
   * inapplicable reason for a specific product, see RepricingProductReport.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> inapplicableProducts;

  /**
   * Total unit count of impacted products ordered while the rule was active on the date of the
   * report. This count includes all orders that were started while the rule was active, even if the
   * rule was no longer active when the order was completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer orderItemCount;

  /**
   * Id of the Repricing rule for this report.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ruleId;

  /**
   * Total GMV generated by impacted products while the rule was active on the date of the report.
   * This value includes all orders that were started while the rule was active, even if the rule
   * was no longer active when the order was completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PriceAmount totalGmv;

  /**
   * Type of the rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Stats specific to buybox winning rules for rule report (deprecated).
   * @return value or {@code null} for none
   */
  public RepricingRuleReportBuyboxWinningRuleStats getBuyboxWinningRuleStats() {
    return buyboxWinningRuleStats;
  }

  /**
   * Stats specific to buybox winning rules for rule report (deprecated).
   * @param buyboxWinningRuleStats buyboxWinningRuleStats or {@code null} for none
   */
  public RepricingRuleReport setBuyboxWinningRuleStats(RepricingRuleReportBuyboxWinningRuleStats buyboxWinningRuleStats) {
    this.buyboxWinningRuleStats = buyboxWinningRuleStats;
    return this;
  }

  /**
   * Date of the stats in this report. The report starts and ends according to the merchant's
   * timezone.
   * @return value or {@code null} for none
   */
  public Date getDate() {
    return date;
  }

  /**
   * Date of the stats in this report. The report starts and ends according to the merchant's
   * timezone.
   * @param date date or {@code null} for none
   */
  public RepricingRuleReport setDate(Date date) {
    this.date = date;
    return this;
  }

  /**
   * List of product ids that are impacted by this rule during this reporting period. Out of stock
   * products and products not searched for by customers are examples of non-impacted products.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getImpactedProducts() {
    return impactedProducts;
  }

  /**
   * List of product ids that are impacted by this rule during this reporting period. Out of stock
   * products and products not searched for by customers are examples of non-impacted products.
   * @param impactedProducts impactedProducts or {@code null} for none
   */
  public RepricingRuleReport setImpactedProducts(java.util.List<java.lang.String> impactedProducts) {
    this.impactedProducts = impactedProducts;
    return this;
  }

  /**
   * List of all reasons the rule did not apply to the inapplicable products during the specified
   * reporting period.
   * @return value or {@code null} for none
   */
  public java.util.List<InapplicabilityDetails> getInapplicabilityDetails() {
    return inapplicabilityDetails;
  }

  /**
   * List of all reasons the rule did not apply to the inapplicable products during the specified
   * reporting period.
   * @param inapplicabilityDetails inapplicabilityDetails or {@code null} for none
   */
  public RepricingRuleReport setInapplicabilityDetails(java.util.List<InapplicabilityDetails> inapplicabilityDetails) {
    this.inapplicabilityDetails = inapplicabilityDetails;
    return this;
  }

  /**
   * List of product ids that are inapplicable to this rule during this reporting period. To get the
   * inapplicable reason for a specific product, see RepricingProductReport.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getInapplicableProducts() {
    return inapplicableProducts;
  }

  /**
   * List of product ids that are inapplicable to this rule during this reporting period. To get the
   * inapplicable reason for a specific product, see RepricingProductReport.
   * @param inapplicableProducts inapplicableProducts or {@code null} for none
   */
  public RepricingRuleReport setInapplicableProducts(java.util.List<java.lang.String> inapplicableProducts) {
    this.inapplicableProducts = inapplicableProducts;
    return this;
  }

  /**
   * Total unit count of impacted products ordered while the rule was active on the date of the
   * report. This count includes all orders that were started while the rule was active, even if the
   * rule was no longer active when the order was completed.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getOrderItemCount() {
    return orderItemCount;
  }

  /**
   * Total unit count of impacted products ordered while the rule was active on the date of the
   * report. This count includes all orders that were started while the rule was active, even if the
   * rule was no longer active when the order was completed.
   * @param orderItemCount orderItemCount or {@code null} for none
   */
  public RepricingRuleReport setOrderItemCount(java.lang.Integer orderItemCount) {
    this.orderItemCount = orderItemCount;
    return this;
  }

  /**
   * Id of the Repricing rule for this report.
   * @return value or {@code null} for none
   */
  public java.lang.String getRuleId() {
    return ruleId;
  }

  /**
   * Id of the Repricing rule for this report.
   * @param ruleId ruleId or {@code null} for none
   */
  public RepricingRuleReport setRuleId(java.lang.String ruleId) {
    this.ruleId = ruleId;
    return this;
  }

  /**
   * Total GMV generated by impacted products while the rule was active on the date of the report.
   * This value includes all orders that were started while the rule was active, even if the rule
   * was no longer active when the order was completed.
   * @return value or {@code null} for none
   */
  public PriceAmount getTotalGmv() {
    return totalGmv;
  }

  /**
   * Total GMV generated by impacted products while the rule was active on the date of the report.
   * This value includes all orders that were started while the rule was active, even if the rule
   * was no longer active when the order was completed.
   * @param totalGmv totalGmv or {@code null} for none
   */
  public RepricingRuleReport setTotalGmv(PriceAmount totalGmv) {
    this.totalGmv = totalGmv;
    return this;
  }

  /**
   * Type of the rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of the rule.
   * @param type type or {@code null} for none
   */
  public RepricingRuleReport setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public RepricingRuleReport set(String fieldName, Object value) {
    return (RepricingRuleReport) super.set(fieldName, value);
  }

  @Override
  public RepricingRuleReport clone() {
    return (RepricingRuleReport) super.clone();
  }

}
