/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Definition of a boundary.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RepricingRuleRestrictionBoundary extends com.google.api.client.json.GenericJson {

  /**
   * The percentage delta relative to the offer selling price. This field is signed. It must be
   * negative in floor. When it is used in floor, it should be > -100. For example, if an offer is
   * selling at $10 and this field is -30 in floor, the repricing rule only applies if the
   * calculated new price is >= $7.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer percentageDelta;

  /**
   * The price micros relative to the offer selling price. This field is signed. It must be negative
   * in floor. For example, if an offer is selling at $10 and this field is -$2 in floor, the
   * repricing rule only applies if the calculated new price is >= $8.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String priceDelta;

  /**
   * The percentage delta relative to the offer selling price. This field is signed. It must be
   * negative in floor. When it is used in floor, it should be > -100. For example, if an offer is
   * selling at $10 and this field is -30 in floor, the repricing rule only applies if the
   * calculated new price is >= $7.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPercentageDelta() {
    return percentageDelta;
  }

  /**
   * The percentage delta relative to the offer selling price. This field is signed. It must be
   * negative in floor. When it is used in floor, it should be > -100. For example, if an offer is
   * selling at $10 and this field is -30 in floor, the repricing rule only applies if the
   * calculated new price is >= $7.
   * @param percentageDelta percentageDelta or {@code null} for none
   */
  public RepricingRuleRestrictionBoundary setPercentageDelta(java.lang.Integer percentageDelta) {
    this.percentageDelta = percentageDelta;
    return this;
  }

  /**
   * The price micros relative to the offer selling price. This field is signed. It must be negative
   * in floor. For example, if an offer is selling at $10 and this field is -$2 in floor, the
   * repricing rule only applies if the calculated new price is >= $8.
   * @return value or {@code null} for none
   */
  public java.lang.String getPriceDelta() {
    return priceDelta;
  }

  /**
   * The price micros relative to the offer selling price. This field is signed. It must be negative
   * in floor. For example, if an offer is selling at $10 and this field is -$2 in floor, the
   * repricing rule only applies if the calculated new price is >= $8.
   * @param priceDelta priceDelta or {@code null} for none
   */
  public RepricingRuleRestrictionBoundary setPriceDelta(java.lang.String priceDelta) {
    this.priceDelta = priceDelta;
    return this;
  }

  @Override
  public RepricingRuleRestrictionBoundary set(String fieldName, Object value) {
    return (RepricingRuleRestrictionBoundary) super.set(fieldName, value);
  }

  @Override
  public RepricingRuleRestrictionBoundary clone() {
    return (RepricingRuleRestrictionBoundary) super.clone();
  }

}
