/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Definition of stats based rule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RepricingRuleStatsBasedRule extends com.google.api.client.json.GenericJson {

  /**
   * The percent change against the price target. Valid from 0 to 100 inclusively.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer percentageDelta;

  /**
   * The price delta against the above price target. A positive value means the price should be
   * adjusted to be above statistical measure, and a negative value means below. Currency code must
   * not be included.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String priceDelta;

  /**
   * The percent change against the price target. Valid from 0 to 100 inclusively.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPercentageDelta() {
    return percentageDelta;
  }

  /**
   * The percent change against the price target. Valid from 0 to 100 inclusively.
   * @param percentageDelta percentageDelta or {@code null} for none
   */
  public RepricingRuleStatsBasedRule setPercentageDelta(java.lang.Integer percentageDelta) {
    this.percentageDelta = percentageDelta;
    return this;
  }

  /**
   * The price delta against the above price target. A positive value means the price should be
   * adjusted to be above statistical measure, and a negative value means below. Currency code must
   * not be included.
   * @return value or {@code null} for none
   */
  public java.lang.String getPriceDelta() {
    return priceDelta;
  }

  /**
   * The price delta against the above price target. A positive value means the price should be
   * adjusted to be above statistical measure, and a negative value means below. Currency code must
   * not be included.
   * @param priceDelta priceDelta or {@code null} for none
   */
  public RepricingRuleStatsBasedRule setPriceDelta(java.lang.String priceDelta) {
    this.priceDelta = priceDelta;
    return this;
  }

  @Override
  public RepricingRuleStatsBasedRule set(String fieldName, Object value) {
    return (RepricingRuleStatsBasedRule) super.set(fieldName, value);
  }

  @Override
  public RepricingRuleStatsBasedRule clone() {
    return (RepricingRuleStatsBasedRule) super.clone();
  }

}
