/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The available policies.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReturnPolicyOnlinePolicy extends com.google.api.client.json.GenericJson {

  /**
   * The number of days items can be returned after delivery, where one day is defined to be 24
   * hours after the delivery timestamp. Required for `numberOfDaysAfterDelivery` returns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long days;

  /**
   * Policy type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The number of days items can be returned after delivery, where one day is defined to be 24
   * hours after the delivery timestamp. Required for `numberOfDaysAfterDelivery` returns.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDays() {
    return days;
  }

  /**
   * The number of days items can be returned after delivery, where one day is defined to be 24
   * hours after the delivery timestamp. Required for `numberOfDaysAfterDelivery` returns.
   * @param days days or {@code null} for none
   */
  public ReturnPolicyOnlinePolicy setDays(java.lang.Long days) {
    this.days = days;
    return this;
  }

  /**
   * Policy type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Policy type.
   * @param type type or {@code null} for none
   */
  public ReturnPolicyOnlinePolicy setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ReturnPolicyOnlinePolicy set(String fieldName, Object value) {
    return (ReturnPolicyOnlinePolicy) super.set(fieldName, value);
  }

  @Override
  public ReturnPolicyOnlinePolicy clone() {
    return (ReturnPolicyOnlinePolicy) super.clone();
  }

}
