/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The restocking fee. This can either be a fixed fee or a micro percent.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReturnPolicyOnlineRestockingFee extends com.google.api.client.json.GenericJson {

  /**
   * Fixed restocking fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PriceAmount fixedFee;

  /**
   * Percent of total price in micros. 15,000,000 means 15% of the total price would be charged.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer microPercent;

  /**
   * Fixed restocking fee.
   * @return value or {@code null} for none
   */
  public PriceAmount getFixedFee() {
    return fixedFee;
  }

  /**
   * Fixed restocking fee.
   * @param fixedFee fixedFee or {@code null} for none
   */
  public ReturnPolicyOnlineRestockingFee setFixedFee(PriceAmount fixedFee) {
    this.fixedFee = fixedFee;
    return this;
  }

  /**
   * Percent of total price in micros. 15,000,000 means 15% of the total price would be charged.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMicroPercent() {
    return microPercent;
  }

  /**
   * Percent of total price in micros. 15,000,000 means 15% of the total price would be charged.
   * @param microPercent microPercent or {@code null} for none
   */
  public ReturnPolicyOnlineRestockingFee setMicroPercent(java.lang.Integer microPercent) {
    this.microPercent = microPercent;
    return this;
  }

  @Override
  public ReturnPolicyOnlineRestockingFee set(String fieldName, Object value) {
    return (ReturnPolicyOnlineRestockingFee) super.set(fieldName, value);
  }

  @Override
  public ReturnPolicyOnlineRestockingFee clone() {
    return (ReturnPolicyOnlineRestockingFee) super.clone();
  }

}
