/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The return reason category info wrapper.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReturnPolicyOnlineReturnReasonCategoryInfo extends com.google.api.client.json.GenericJson {

  /**
   * The corresponding return label source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String returnLabelSource;

  /**
   * The return reason category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String returnReasonCategory;

  /**
   * The corresponding return shipping fee. This is only applicable when returnLabelSource is not
   * the customer's responsibility.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ReturnPolicyOnlineReturnShippingFee returnShippingFee;

  /**
   * The corresponding return label source.
   * @return value or {@code null} for none
   */
  public java.lang.String getReturnLabelSource() {
    return returnLabelSource;
  }

  /**
   * The corresponding return label source.
   * @param returnLabelSource returnLabelSource or {@code null} for none
   */
  public ReturnPolicyOnlineReturnReasonCategoryInfo setReturnLabelSource(java.lang.String returnLabelSource) {
    this.returnLabelSource = returnLabelSource;
    return this;
  }

  /**
   * The return reason category.
   * @return value or {@code null} for none
   */
  public java.lang.String getReturnReasonCategory() {
    return returnReasonCategory;
  }

  /**
   * The return reason category.
   * @param returnReasonCategory returnReasonCategory or {@code null} for none
   */
  public ReturnPolicyOnlineReturnReasonCategoryInfo setReturnReasonCategory(java.lang.String returnReasonCategory) {
    this.returnReasonCategory = returnReasonCategory;
    return this;
  }

  /**
   * The corresponding return shipping fee. This is only applicable when returnLabelSource is not
   * the customer's responsibility.
   * @return value or {@code null} for none
   */
  public ReturnPolicyOnlineReturnShippingFee getReturnShippingFee() {
    return returnShippingFee;
  }

  /**
   * The corresponding return shipping fee. This is only applicable when returnLabelSource is not
   * the customer's responsibility.
   * @param returnShippingFee returnShippingFee or {@code null} for none
   */
  public ReturnPolicyOnlineReturnReasonCategoryInfo setReturnShippingFee(ReturnPolicyOnlineReturnShippingFee returnShippingFee) {
    this.returnShippingFee = returnShippingFee;
    return this;
  }

  @Override
  public ReturnPolicyOnlineReturnReasonCategoryInfo set(String fieldName, Object value) {
    return (ReturnPolicyOnlineReturnReasonCategoryInfo) super.set(fieldName, value);
  }

  @Override
  public ReturnPolicyOnlineReturnReasonCategoryInfo clone() {
    return (ReturnPolicyOnlineReturnReasonCategoryInfo) super.clone();
  }

}
