/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The return shipping fee. This can either be a fixed fee or a boolean to indicate that the
 * customer pays the actual shipping cost.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReturnPolicyOnlineReturnShippingFee extends com.google.api.client.json.GenericJson {

  /**
   * Fixed return shipping fee amount. This value is only applicable when type is FIXED. We will
   * treat the return shipping fee as free if type is FIXED and this value is not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PriceAmount fixedFee;

  /**
   * Type of return shipping fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Fixed return shipping fee amount. This value is only applicable when type is FIXED. We will
   * treat the return shipping fee as free if type is FIXED and this value is not set.
   * @return value or {@code null} for none
   */
  public PriceAmount getFixedFee() {
    return fixedFee;
  }

  /**
   * Fixed return shipping fee amount. This value is only applicable when type is FIXED. We will
   * treat the return shipping fee as free if type is FIXED and this value is not set.
   * @param fixedFee fixedFee or {@code null} for none
   */
  public ReturnPolicyOnlineReturnShippingFee setFixedFee(PriceAmount fixedFee) {
    this.fixedFee = fixedFee;
    return this;
  }

  /**
   * Type of return shipping fee.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Type of return shipping fee.
   * @param type type or {@code null} for none
   */
  public ReturnPolicyOnlineReturnShippingFee setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ReturnPolicyOnlineReturnShippingFee set(String fieldName, Object value) {
    return (ReturnPolicyOnlineReturnShippingFee) super.set(fieldName, value);
  }

  @Override
  public ReturnPolicyOnlineReturnShippingFee clone() {
    return (ReturnPolicyOnlineReturnShippingFee) super.clone();
  }

}
