/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Return shipping label for a Buy on Google merchant-managed return.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReturnShippingLabel extends com.google.api.client.json.GenericJson {

  /**
   * Name of the carrier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carrier;

  /**
   * The URL for the return shipping label in PDF format
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String labelUri;

  /**
   * The tracking id of this return label.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String trackingId;

  /**
   * Name of the carrier.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarrier() {
    return carrier;
  }

  /**
   * Name of the carrier.
   * @param carrier carrier or {@code null} for none
   */
  public ReturnShippingLabel setCarrier(java.lang.String carrier) {
    this.carrier = carrier;
    return this;
  }

  /**
   * The URL for the return shipping label in PDF format
   * @return value or {@code null} for none
   */
  public java.lang.String getLabelUri() {
    return labelUri;
  }

  /**
   * The URL for the return shipping label in PDF format
   * @param labelUri labelUri or {@code null} for none
   */
  public ReturnShippingLabel setLabelUri(java.lang.String labelUri) {
    this.labelUri = labelUri;
    return this;
  }

  /**
   * The tracking id of this return label.
   * @return value or {@code null} for none
   */
  public java.lang.String getTrackingId() {
    return trackingId;
  }

  /**
   * The tracking id of this return label.
   * @param trackingId trackingId or {@code null} for none
   */
  public ReturnShippingLabel setTrackingId(java.lang.String trackingId) {
    this.trackingId = trackingId;
    return this;
  }

  @Override
  public ReturnShippingLabel set(String fieldName, Object value) {
    return (ReturnShippingLabel) super.set(fieldName, value);
  }

  @Override
  public ReturnShippingLabel clone() {
    return (ReturnShippingLabel) super.clone();
  }

}
