/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for SettlementTransactionIdentifiers.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SettlementTransactionIdentifiers extends com.google.api.client.json.GenericJson {

  /**
   * The identifier of the adjustments, if it's available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String adjustmentId;

  /**
   * The merchant provided order ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String merchantOrderId;

  /**
   * The identifier of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orderItemId;

  /**
   * The unique ID of the settlement transaction entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String settlementEntryId;

  /**
   * The shipment ids for the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> shipmentIds;

  /**
   * The Google transaction ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String transactionId;

  /**
   * The identifier of the adjustments, if it's available.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdjustmentId() {
    return adjustmentId;
  }

  /**
   * The identifier of the adjustments, if it's available.
   * @param adjustmentId adjustmentId or {@code null} for none
   */
  public SettlementTransactionIdentifiers setAdjustmentId(java.lang.String adjustmentId) {
    this.adjustmentId = adjustmentId;
    return this;
  }

  /**
   * The merchant provided order ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getMerchantOrderId() {
    return merchantOrderId;
  }

  /**
   * The merchant provided order ID.
   * @param merchantOrderId merchantOrderId or {@code null} for none
   */
  public SettlementTransactionIdentifiers setMerchantOrderId(java.lang.String merchantOrderId) {
    this.merchantOrderId = merchantOrderId;
    return this;
  }

  /**
   * The identifier of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrderItemId() {
    return orderItemId;
  }

  /**
   * The identifier of the item.
   * @param orderItemId orderItemId or {@code null} for none
   */
  public SettlementTransactionIdentifiers setOrderItemId(java.lang.String orderItemId) {
    this.orderItemId = orderItemId;
    return this;
  }

  /**
   * The unique ID of the settlement transaction entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getSettlementEntryId() {
    return settlementEntryId;
  }

  /**
   * The unique ID of the settlement transaction entry.
   * @param settlementEntryId settlementEntryId or {@code null} for none
   */
  public SettlementTransactionIdentifiers setSettlementEntryId(java.lang.String settlementEntryId) {
    this.settlementEntryId = settlementEntryId;
    return this;
  }

  /**
   * The shipment ids for the item.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getShipmentIds() {
    return shipmentIds;
  }

  /**
   * The shipment ids for the item.
   * @param shipmentIds shipmentIds or {@code null} for none
   */
  public SettlementTransactionIdentifiers setShipmentIds(java.util.List<java.lang.String> shipmentIds) {
    this.shipmentIds = shipmentIds;
    return this;
  }

  /**
   * The Google transaction ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getTransactionId() {
    return transactionId;
  }

  /**
   * The Google transaction ID.
   * @param transactionId transactionId or {@code null} for none
   */
  public SettlementTransactionIdentifiers setTransactionId(java.lang.String transactionId) {
    this.transactionId = transactionId;
    return this;
  }

  @Override
  public SettlementTransactionIdentifiers set(String fieldName, Object value) {
    return (SettlementTransactionIdentifiers) super.set(fieldName, value);
  }

  @Override
  public SettlementTransactionIdentifiers clone() {
    return (SettlementTransactionIdentifiers) super.clone();
  }

}
