/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The merchant account's shipping settings. All methods except getsupportedcarriers and
 * getsupportedholidays require the admin role.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ShippingSettings extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the account to which these account shipping settings belong. Ignored upon update,
   * always present in get request responses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger accountId;

  /**
   * A list of postal code groups that can be referred to in `services`. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PostalCodeGroup> postalCodeGroups;

  static {
    // hack to force ProGuard to consider PostalCodeGroup used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PostalCodeGroup.class);
  }

  /**
   * The target account's list of services. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Service> services;

  static {
    // hack to force ProGuard to consider Service used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Service.class);
  }

  /**
   * Optional. A list of warehouses which can be referred to in `services`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Warehouse> warehouses;

  /**
   * The ID of the account to which these account shipping settings belong. Ignored upon update,
   * always present in get request responses.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getAccountId() {
    return accountId;
  }

  /**
   * The ID of the account to which these account shipping settings belong. Ignored upon update,
   * always present in get request responses.
   * @param accountId accountId or {@code null} for none
   */
  public ShippingSettings setAccountId(java.math.BigInteger accountId) {
    this.accountId = accountId;
    return this;
  }

  /**
   * A list of postal code groups that can be referred to in `services`. Optional.
   * @return value or {@code null} for none
   */
  public java.util.List<PostalCodeGroup> getPostalCodeGroups() {
    return postalCodeGroups;
  }

  /**
   * A list of postal code groups that can be referred to in `services`. Optional.
   * @param postalCodeGroups postalCodeGroups or {@code null} for none
   */
  public ShippingSettings setPostalCodeGroups(java.util.List<PostalCodeGroup> postalCodeGroups) {
    this.postalCodeGroups = postalCodeGroups;
    return this;
  }

  /**
   * The target account's list of services. Optional.
   * @return value or {@code null} for none
   */
  public java.util.List<Service> getServices() {
    return services;
  }

  /**
   * The target account's list of services. Optional.
   * @param services services or {@code null} for none
   */
  public ShippingSettings setServices(java.util.List<Service> services) {
    this.services = services;
    return this;
  }

  /**
   * Optional. A list of warehouses which can be referred to in `services`.
   * @return value or {@code null} for none
   */
  public java.util.List<Warehouse> getWarehouses() {
    return warehouses;
  }

  /**
   * Optional. A list of warehouses which can be referred to in `services`.
   * @param warehouses warehouses or {@code null} for none
   */
  public ShippingSettings setWarehouses(java.util.List<Warehouse> warehouses) {
    this.warehouses = warehouses;
    return this;
  }

  @Override
  public ShippingSettings set(String fieldName, Object value) {
    return (ShippingSettings) super.set(fieldName, value);
  }

  @Override
  public ShippingSettings clone() {
    return (ShippingSettings) super.clone();
  }

}
