/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Model definition for UnitInvoiceTaxLine.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UnitInvoiceTaxLine extends com.google.api.client.json.GenericJson {

  /**
   * [required] Tax amount for the tax type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Price taxAmount;

  /**
   * Optional name of the tax type. This should only be provided if `taxType` is `otherFeeTax`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String taxName;

  /**
   * [required] Type of the tax. Acceptable values are: - "`otherFee`" - "`otherFeeTax`" - "`sales`"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String taxType;

  /**
   * [required] Tax amount for the tax type.
   * @return value or {@code null} for none
   */
  public Price getTaxAmount() {
    return taxAmount;
  }

  /**
   * [required] Tax amount for the tax type.
   * @param taxAmount taxAmount or {@code null} for none
   */
  public UnitInvoiceTaxLine setTaxAmount(Price taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

  /**
   * Optional name of the tax type. This should only be provided if `taxType` is `otherFeeTax`.
   * @return value or {@code null} for none
   */
  public java.lang.String getTaxName() {
    return taxName;
  }

  /**
   * Optional name of the tax type. This should only be provided if `taxType` is `otherFeeTax`.
   * @param taxName taxName or {@code null} for none
   */
  public UnitInvoiceTaxLine setTaxName(java.lang.String taxName) {
    this.taxName = taxName;
    return this;
  }

  /**
   * [required] Type of the tax. Acceptable values are: - "`otherFee`" - "`otherFeeTax`" - "`sales`"
   * @return value or {@code null} for none
   */
  public java.lang.String getTaxType() {
    return taxType;
  }

  /**
   * [required] Type of the tax. Acceptable values are: - "`otherFee`" - "`otherFeeTax`" - "`sales`"
   * @param taxType taxType or {@code null} for none
   */
  public UnitInvoiceTaxLine setTaxType(java.lang.String taxType) {
    this.taxType = taxType;
    return this;
  }

  @Override
  public UnitInvoiceTaxLine set(String fieldName, Object value) {
    return (UnitInvoiceTaxLine) super.set(fieldName, value);
  }

  @Override
  public UnitInvoiceTaxLine clone() {
    return (UnitInvoiceTaxLine) super.clone();
  }

}
