/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * A fulfillment warehouse, which stores and handles inventory.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Warehouse extends com.google.api.client.json.GenericJson {

  /**
   * Business days of the warehouse. If not set, will be Monday to Friday by default.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BusinessDayConfig businessDayConfig;

  /**
   * Required. The latest time of day that an order can be accepted and begin processing. Later
   * orders will be processed in the next day. The time is based on the warehouse postal code.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WarehouseCutoffTime cutoffTime;

  /**
   * Required. The number of days it takes for this warehouse to pack up and ship an item. This is
   * on the warehouse level, but can be overridden on the offer level based on the attributes of an
   * item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long handlingDays;

  /**
   * Required. The name of the warehouse. Must be unique within account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Required. Shipping address of the warehouse.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Address shippingAddress;

  /**
   * Business days of the warehouse. If not set, will be Monday to Friday by default.
   * @return value or {@code null} for none
   */
  public BusinessDayConfig getBusinessDayConfig() {
    return businessDayConfig;
  }

  /**
   * Business days of the warehouse. If not set, will be Monday to Friday by default.
   * @param businessDayConfig businessDayConfig or {@code null} for none
   */
  public Warehouse setBusinessDayConfig(BusinessDayConfig businessDayConfig) {
    this.businessDayConfig = businessDayConfig;
    return this;
  }

  /**
   * Required. The latest time of day that an order can be accepted and begin processing. Later
   * orders will be processed in the next day. The time is based on the warehouse postal code.
   * @return value or {@code null} for none
   */
  public WarehouseCutoffTime getCutoffTime() {
    return cutoffTime;
  }

  /**
   * Required. The latest time of day that an order can be accepted and begin processing. Later
   * orders will be processed in the next day. The time is based on the warehouse postal code.
   * @param cutoffTime cutoffTime or {@code null} for none
   */
  public Warehouse setCutoffTime(WarehouseCutoffTime cutoffTime) {
    this.cutoffTime = cutoffTime;
    return this;
  }

  /**
   * Required. The number of days it takes for this warehouse to pack up and ship an item. This is
   * on the warehouse level, but can be overridden on the offer level based on the attributes of an
   * item.
   * @return value or {@code null} for none
   */
  public java.lang.Long getHandlingDays() {
    return handlingDays;
  }

  /**
   * Required. The number of days it takes for this warehouse to pack up and ship an item. This is
   * on the warehouse level, but can be overridden on the offer level based on the attributes of an
   * item.
   * @param handlingDays handlingDays or {@code null} for none
   */
  public Warehouse setHandlingDays(java.lang.Long handlingDays) {
    this.handlingDays = handlingDays;
    return this;
  }

  /**
   * Required. The name of the warehouse. Must be unique within account.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The name of the warehouse. Must be unique within account.
   * @param name name or {@code null} for none
   */
  public Warehouse setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Required. Shipping address of the warehouse.
   * @return value or {@code null} for none
   */
  public Address getShippingAddress() {
    return shippingAddress;
  }

  /**
   * Required. Shipping address of the warehouse.
   * @param shippingAddress shippingAddress or {@code null} for none
   */
  public Warehouse setShippingAddress(Address shippingAddress) {
    this.shippingAddress = shippingAddress;
    return this;
  }

  @Override
  public Warehouse set(String fieldName, Object value) {
    return (Warehouse) super.set(fieldName, value);
  }

  @Override
  public Warehouse clone() {
    return (Warehouse) super.clone();
  }

}
