/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.content;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.content.ShoppingContentRequest;
import com.google.api.services.content.ShoppingContentRequestInitializer;
import com.google.api.services.content.model.Account;
import com.google.api.services.content.model.AccountCredentials;
import com.google.api.services.content.model.AccountLabel;
import com.google.api.services.content.model.AccountReturnCarrier;
import com.google.api.services.content.model.AccountStatus;
import com.google.api.services.content.model.AccountTax;
import com.google.api.services.content.model.AccountsAuthInfoResponse;
import com.google.api.services.content.model.AccountsClaimWebsiteResponse;
import com.google.api.services.content.model.AccountsCustomBatchRequest;
import com.google.api.services.content.model.AccountsCustomBatchResponse;
import com.google.api.services.content.model.AccountsLinkRequest;
import com.google.api.services.content.model.AccountsLinkResponse;
import com.google.api.services.content.model.AccountsListLinksResponse;
import com.google.api.services.content.model.AccountsListResponse;
import com.google.api.services.content.model.AccountsUpdateLabelsRequest;
import com.google.api.services.content.model.AccountsUpdateLabelsResponse;
import com.google.api.services.content.model.AccountstatusesCustomBatchRequest;
import com.google.api.services.content.model.AccountstatusesCustomBatchResponse;
import com.google.api.services.content.model.AccountstatusesListResponse;
import com.google.api.services.content.model.AccounttaxCustomBatchRequest;
import com.google.api.services.content.model.AccounttaxCustomBatchResponse;
import com.google.api.services.content.model.AccounttaxListResponse;
import com.google.api.services.content.model.ActivateBuyOnGoogleProgramRequest;
import com.google.api.services.content.model.BuyOnGoogleProgramStatus;
import com.google.api.services.content.model.CaptureOrderRequest;
import com.google.api.services.content.model.CaptureOrderResponse;
import com.google.api.services.content.model.Collection;
import com.google.api.services.content.model.CollectionStatus;
import com.google.api.services.content.model.Css;
import com.google.api.services.content.model.Datafeed;
import com.google.api.services.content.model.DatafeedStatus;
import com.google.api.services.content.model.DatafeedsCustomBatchRequest;
import com.google.api.services.content.model.DatafeedsCustomBatchResponse;
import com.google.api.services.content.model.DatafeedsFetchNowResponse;
import com.google.api.services.content.model.DatafeedsListResponse;
import com.google.api.services.content.model.DatafeedstatusesCustomBatchRequest;
import com.google.api.services.content.model.DatafeedstatusesCustomBatchResponse;
import com.google.api.services.content.model.DatafeedstatusesListResponse;
import com.google.api.services.content.model.FreeListingsProgramStatus;
import com.google.api.services.content.model.LabelIds;
import com.google.api.services.content.model.LiaSettings;
import com.google.api.services.content.model.LiasettingsCustomBatchRequest;
import com.google.api.services.content.model.LiasettingsCustomBatchResponse;
import com.google.api.services.content.model.LiasettingsGetAccessibleGmbAccountsResponse;
import com.google.api.services.content.model.LiasettingsListPosDataProvidersResponse;
import com.google.api.services.content.model.LiasettingsListResponse;
import com.google.api.services.content.model.LiasettingsRequestGmbAccessResponse;
import com.google.api.services.content.model.LiasettingsRequestInventoryVerificationResponse;
import com.google.api.services.content.model.LiasettingsSetInventoryVerificationContactResponse;
import com.google.api.services.content.model.LiasettingsSetPosDataProviderResponse;
import com.google.api.services.content.model.ListAccountLabelsResponse;
import com.google.api.services.content.model.ListAccountReturnCarrierResponse;
import com.google.api.services.content.model.ListCollectionStatusesResponse;
import com.google.api.services.content.model.ListCollectionsResponse;
import com.google.api.services.content.model.ListCssesResponse;
import com.google.api.services.content.model.ListMethodQuotasResponse;
import com.google.api.services.content.model.ListRegionsResponse;
import com.google.api.services.content.model.ListRepricingProductReportsResponse;
import com.google.api.services.content.model.ListRepricingRuleReportsResponse;
import com.google.api.services.content.model.ListRepricingRulesResponse;
import com.google.api.services.content.model.ListReturnPolicyOnlineResponse;
import com.google.api.services.content.model.LocalInventory;
import com.google.api.services.content.model.LocalinventoryCustomBatchRequest;
import com.google.api.services.content.model.LocalinventoryCustomBatchResponse;
import com.google.api.services.content.model.MerchantOrderReturn;
import com.google.api.services.content.model.OnboardBuyOnGoogleProgramRequest;
import com.google.api.services.content.model.Order;
import com.google.api.services.content.model.OrderTrackingSignal;
import com.google.api.services.content.model.OrderinvoicesCreateChargeInvoiceRequest;
import com.google.api.services.content.model.OrderinvoicesCreateChargeInvoiceResponse;
import com.google.api.services.content.model.OrderinvoicesCreateRefundInvoiceRequest;
import com.google.api.services.content.model.OrderinvoicesCreateRefundInvoiceResponse;
import com.google.api.services.content.model.OrderreportsListDisbursementsResponse;
import com.google.api.services.content.model.OrderreportsListTransactionsResponse;
import com.google.api.services.content.model.OrderreturnsAcknowledgeRequest;
import com.google.api.services.content.model.OrderreturnsAcknowledgeResponse;
import com.google.api.services.content.model.OrderreturnsCreateOrderReturnRequest;
import com.google.api.services.content.model.OrderreturnsCreateOrderReturnResponse;
import com.google.api.services.content.model.OrderreturnsListResponse;
import com.google.api.services.content.model.OrderreturnsProcessRequest;
import com.google.api.services.content.model.OrderreturnsProcessResponse;
import com.google.api.services.content.model.OrdersAcknowledgeRequest;
import com.google.api.services.content.model.OrdersAcknowledgeResponse;
import com.google.api.services.content.model.OrdersAdvanceTestOrderResponse;
import com.google.api.services.content.model.OrdersCancelLineItemRequest;
import com.google.api.services.content.model.OrdersCancelLineItemResponse;
import com.google.api.services.content.model.OrdersCancelRequest;
import com.google.api.services.content.model.OrdersCancelResponse;
import com.google.api.services.content.model.OrdersCancelTestOrderByCustomerRequest;
import com.google.api.services.content.model.OrdersCancelTestOrderByCustomerResponse;
import com.google.api.services.content.model.OrdersCreateTestOrderRequest;
import com.google.api.services.content.model.OrdersCreateTestOrderResponse;
import com.google.api.services.content.model.OrdersCreateTestReturnRequest;
import com.google.api.services.content.model.OrdersCreateTestReturnResponse;
import com.google.api.services.content.model.OrdersGetByMerchantOrderIdResponse;
import com.google.api.services.content.model.OrdersGetTestOrderTemplateResponse;
import com.google.api.services.content.model.OrdersInStoreRefundLineItemRequest;
import com.google.api.services.content.model.OrdersInStoreRefundLineItemResponse;
import com.google.api.services.content.model.OrdersListResponse;
import com.google.api.services.content.model.OrdersRefundItemRequest;
import com.google.api.services.content.model.OrdersRefundItemResponse;
import com.google.api.services.content.model.OrdersRefundOrderRequest;
import com.google.api.services.content.model.OrdersRefundOrderResponse;
import com.google.api.services.content.model.OrdersRejectReturnLineItemRequest;
import com.google.api.services.content.model.OrdersRejectReturnLineItemResponse;
import com.google.api.services.content.model.OrdersReturnRefundLineItemRequest;
import com.google.api.services.content.model.OrdersReturnRefundLineItemResponse;
import com.google.api.services.content.model.OrdersSetLineItemMetadataRequest;
import com.google.api.services.content.model.OrdersSetLineItemMetadataResponse;
import com.google.api.services.content.model.OrdersShipLineItemsRequest;
import com.google.api.services.content.model.OrdersShipLineItemsResponse;
import com.google.api.services.content.model.OrdersUpdateLineItemShippingDetailsRequest;
import com.google.api.services.content.model.OrdersUpdateLineItemShippingDetailsResponse;
import com.google.api.services.content.model.OrdersUpdateMerchantOrderIdRequest;
import com.google.api.services.content.model.OrdersUpdateMerchantOrderIdResponse;
import com.google.api.services.content.model.OrdersUpdateShipmentRequest;
import com.google.api.services.content.model.OrdersUpdateShipmentResponse;
import com.google.api.services.content.model.PauseBuyOnGoogleProgramRequest;
import com.google.api.services.content.model.PosCustomBatchRequest;
import com.google.api.services.content.model.PosCustomBatchResponse;
import com.google.api.services.content.model.PosInventoryRequest;
import com.google.api.services.content.model.PosInventoryResponse;
import com.google.api.services.content.model.PosListResponse;
import com.google.api.services.content.model.PosSaleRequest;
import com.google.api.services.content.model.PosSaleResponse;
import com.google.api.services.content.model.PosStore;
import com.google.api.services.content.model.Product;
import com.google.api.services.content.model.ProductDeliveryTime;
import com.google.api.services.content.model.ProductStatus;
import com.google.api.services.content.model.ProductsCustomBatchRequest;
import com.google.api.services.content.model.ProductsCustomBatchResponse;
import com.google.api.services.content.model.ProductsListResponse;
import com.google.api.services.content.model.ProductstatusesCustomBatchRequest;
import com.google.api.services.content.model.ProductstatusesCustomBatchResponse;
import com.google.api.services.content.model.ProductstatusesListResponse;
import com.google.api.services.content.model.Promotion;
import com.google.api.services.content.model.PubsubNotificationSettings;
import com.google.api.services.content.model.Region;
import com.google.api.services.content.model.RegionalInventory;
import com.google.api.services.content.model.RegionalinventoryCustomBatchRequest;
import com.google.api.services.content.model.RegionalinventoryCustomBatchResponse;
import com.google.api.services.content.model.RepricingRule;
import com.google.api.services.content.model.RequestPhoneVerificationRequest;
import com.google.api.services.content.model.RequestPhoneVerificationResponse;
import com.google.api.services.content.model.RequestReviewBuyOnGoogleProgramRequest;
import com.google.api.services.content.model.RequestReviewFreeListingsRequest;
import com.google.api.services.content.model.RequestReviewShoppingAdsRequest;
import com.google.api.services.content.model.ReturnAddress;
import com.google.api.services.content.model.ReturnPolicy;
import com.google.api.services.content.model.ReturnPolicyOnline;
import com.google.api.services.content.model.ReturnShippingLabel;
import com.google.api.services.content.model.ReturnaddressCustomBatchRequest;
import com.google.api.services.content.model.ReturnaddressCustomBatchResponse;
import com.google.api.services.content.model.ReturnaddressListResponse;
import com.google.api.services.content.model.ReturnpolicyCustomBatchRequest;
import com.google.api.services.content.model.ReturnpolicyCustomBatchResponse;
import com.google.api.services.content.model.ReturnpolicyListResponse;
import com.google.api.services.content.model.SearchRequest;
import com.google.api.services.content.model.SearchResponse;
import com.google.api.services.content.model.SettlementReport;
import com.google.api.services.content.model.SettlementreportsListResponse;
import com.google.api.services.content.model.SettlementtransactionsListResponse;
import com.google.api.services.content.model.ShippingSettings;
import com.google.api.services.content.model.ShippingsettingsCustomBatchRequest;
import com.google.api.services.content.model.ShippingsettingsCustomBatchResponse;
import com.google.api.services.content.model.ShippingsettingsGetSupportedCarriersResponse;
import com.google.api.services.content.model.ShippingsettingsGetSupportedHolidaysResponse;
import com.google.api.services.content.model.ShippingsettingsGetSupportedPickupServicesResponse;
import com.google.api.services.content.model.ShippingsettingsListResponse;
import com.google.api.services.content.model.ShoppingAdsProgramStatus;
import com.google.api.services.content.model.VerifyPhoneNumberRequest;
import com.google.api.services.content.model.VerifyPhoneNumberResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;

public class ShoppingContent
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://shoppingcontent.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://shoppingcontent.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "content/v2.1/";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://shoppingcontent.googleapis.com/content/v2.1/";

    public ShoppingContent(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    ShoppingContent(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Accounts accounts() {
        return new Accounts();
    }

    public Accountstatuses accountstatuses() {
        return new Accountstatuses();
    }

    public Accounttax accounttax() {
        return new Accounttax();
    }

    public Buyongoogleprograms buyongoogleprograms() {
        return new Buyongoogleprograms();
    }

    public Collections collections() {
        return new Collections();
    }

    public Collectionstatuses collectionstatuses() {
        return new Collectionstatuses();
    }

    public Csses csses() {
        return new Csses();
    }

    public Datafeeds datafeeds() {
        return new Datafeeds();
    }

    public Datafeedstatuses datafeedstatuses() {
        return new Datafeedstatuses();
    }

    public Freelistingsprogram freelistingsprogram() {
        return new Freelistingsprogram();
    }

    public Liasettings liasettings() {
        return new Liasettings();
    }

    public Localinventory localinventory() {
        return new Localinventory();
    }

    public Orderinvoices orderinvoices() {
        return new Orderinvoices();
    }

    public Orderreports orderreports() {
        return new Orderreports();
    }

    public Orderreturns orderreturns() {
        return new Orderreturns();
    }

    public Orders orders() {
        return new Orders();
    }

    public Ordertrackingsignals ordertrackingsignals() {
        return new Ordertrackingsignals();
    }

    public Pos pos() {
        return new Pos();
    }

    public Productdeliverytime productdeliverytime() {
        return new Productdeliverytime();
    }

    public Products products() {
        return new Products();
    }

    public Productstatuses productstatuses() {
        return new Productstatuses();
    }

    public Promotions promotions() {
        return new Promotions();
    }

    public Pubsubnotificationsettings pubsubnotificationsettings() {
        return new Pubsubnotificationsettings();
    }

    public Quotas quotas() {
        return new Quotas();
    }

    public Regionalinventory regionalinventory() {
        return new Regionalinventory();
    }

    public Regions regions() {
        return new Regions();
    }

    public Reports reports() {
        return new Reports();
    }

    public Repricingrules repricingrules() {
        return new Repricingrules();
    }

    public Returnaddress returnaddress() {
        return new Returnaddress();
    }

    public Returnpolicy returnpolicy() {
        return new Returnpolicy();
    }

    public Returnpolicyonline returnpolicyonline() {
        return new Returnpolicyonline();
    }

    public Settlementreports settlementreports() {
        return new Settlementreports();
    }

    public Settlementtransactions settlementtransactions() {
        return new Settlementtransactions();
    }

    public Shippingsettings shippingsettings() {
        return new Shippingsettings();
    }

    public Shoppingadsprogram shoppingadsprogram() {
        return new Shoppingadsprogram();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Content API for Shopping library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return ShoppingContent.DEFAULT_MTLS_ROOT_URL;
            }
            return ShoppingContent.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), ShoppingContent.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ShoppingContent.DEFAULT_BATCH_PATH);
        }

        public ShoppingContent build() {
            return new ShoppingContent(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setShoppingContentRequestInitializer(ShoppingContentRequestInitializer shoppingcontentRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)shoppingcontentRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Shoppingadsprogram {
        public Get get(Long merchantId) throws IOException {
            Get result = new Get(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestreview requestreview(Long merchantId, RequestReviewShoppingAdsRequest content) throws IOException {
            Requestreview result = new Requestreview(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Requestreview
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/shoppingadsprogram/requestreview";
            @Key
            private Long merchantId;

            protected Requestreview(Long merchantId, RequestReviewShoppingAdsRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Requestreview set$Xgafv(String $Xgafv) {
                return (Requestreview)super.set$Xgafv($Xgafv);
            }

            public Requestreview setAccessToken(String accessToken) {
                return (Requestreview)super.setAccessToken(accessToken);
            }

            public Requestreview setAlt(String alt) {
                return (Requestreview)super.setAlt(alt);
            }

            public Requestreview setCallback(String callback) {
                return (Requestreview)super.setCallback(callback);
            }

            public Requestreview setFields(String fields) {
                return (Requestreview)super.setFields(fields);
            }

            public Requestreview setKey(String key) {
                return (Requestreview)super.setKey(key);
            }

            public Requestreview setOauthToken(String oauthToken) {
                return (Requestreview)super.setOauthToken(oauthToken);
            }

            public Requestreview setPrettyPrint(Boolean prettyPrint) {
                return (Requestreview)super.setPrettyPrint(prettyPrint);
            }

            public Requestreview setQuotaUser(String quotaUser) {
                return (Requestreview)super.setQuotaUser(quotaUser);
            }

            public Requestreview setUploadType(String uploadType) {
                return (Requestreview)super.setUploadType(uploadType);
            }

            public Requestreview setUploadProtocol(String uploadProtocol) {
                return (Requestreview)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Requestreview setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Requestreview set(String parameterName, Object value) {
                return (Requestreview)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ShoppingAdsProgramStatus> {
            private static final String REST_PATH = "{merchantId}/shoppingadsprogram";
            @Key
            private Long merchantId;

            protected Get(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShoppingAdsProgramStatus.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Shippingsettings {
        public Custombatch custombatch(ShippingsettingsCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger accountId) throws IOException {
            Get result = new Get(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Getsupportedcarriers getsupportedcarriers(BigInteger merchantId) throws IOException {
            Getsupportedcarriers result = new Getsupportedcarriers(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Getsupportedholidays getsupportedholidays(BigInteger merchantId) throws IOException {
            Getsupportedholidays result = new Getsupportedholidays(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Getsupportedpickupservices getsupportedpickupservices(BigInteger merchantId) throws IOException {
            Getsupportedpickupservices result = new Getsupportedpickupservices(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, BigInteger accountId, ShippingSettings content) throws IOException {
            Update result = new Update(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<ShippingSettings> {
            private static final String REST_PATH = "{merchantId}/shippingsettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Update(BigInteger merchantId, BigInteger accountId, ShippingSettings content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, ShippingSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ShippingsettingsListResponse> {
            private static final String REST_PATH = "{merchantId}/shippingsettings";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Getsupportedpickupservices
        extends ShoppingContentRequest<ShippingsettingsGetSupportedPickupServicesResponse> {
            private static final String REST_PATH = "{merchantId}/supportedPickupServices";
            @Key
            private BigInteger merchantId;

            protected Getsupportedpickupservices(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsGetSupportedPickupServicesResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getsupportedpickupservices set$Xgafv(String $Xgafv) {
                return (Getsupportedpickupservices)super.set$Xgafv($Xgafv);
            }

            public Getsupportedpickupservices setAccessToken(String accessToken) {
                return (Getsupportedpickupservices)super.setAccessToken(accessToken);
            }

            public Getsupportedpickupservices setAlt(String alt) {
                return (Getsupportedpickupservices)super.setAlt(alt);
            }

            public Getsupportedpickupservices setCallback(String callback) {
                return (Getsupportedpickupservices)super.setCallback(callback);
            }

            public Getsupportedpickupservices setFields(String fields) {
                return (Getsupportedpickupservices)super.setFields(fields);
            }

            public Getsupportedpickupservices setKey(String key) {
                return (Getsupportedpickupservices)super.setKey(key);
            }

            public Getsupportedpickupservices setOauthToken(String oauthToken) {
                return (Getsupportedpickupservices)super.setOauthToken(oauthToken);
            }

            public Getsupportedpickupservices setPrettyPrint(Boolean prettyPrint) {
                return (Getsupportedpickupservices)super.setPrettyPrint(prettyPrint);
            }

            public Getsupportedpickupservices setQuotaUser(String quotaUser) {
                return (Getsupportedpickupservices)super.setQuotaUser(quotaUser);
            }

            public Getsupportedpickupservices setUploadType(String uploadType) {
                return (Getsupportedpickupservices)super.setUploadType(uploadType);
            }

            public Getsupportedpickupservices setUploadProtocol(String uploadProtocol) {
                return (Getsupportedpickupservices)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getsupportedpickupservices setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Getsupportedpickupservices set(String parameterName, Object value) {
                return (Getsupportedpickupservices)super.set(parameterName, value);
            }
        }

        public class Getsupportedholidays
        extends ShoppingContentRequest<ShippingsettingsGetSupportedHolidaysResponse> {
            private static final String REST_PATH = "{merchantId}/supportedHolidays";
            @Key
            private BigInteger merchantId;

            protected Getsupportedholidays(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsGetSupportedHolidaysResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getsupportedholidays set$Xgafv(String $Xgafv) {
                return (Getsupportedholidays)super.set$Xgafv($Xgafv);
            }

            public Getsupportedholidays setAccessToken(String accessToken) {
                return (Getsupportedholidays)super.setAccessToken(accessToken);
            }

            public Getsupportedholidays setAlt(String alt) {
                return (Getsupportedholidays)super.setAlt(alt);
            }

            public Getsupportedholidays setCallback(String callback) {
                return (Getsupportedholidays)super.setCallback(callback);
            }

            public Getsupportedholidays setFields(String fields) {
                return (Getsupportedholidays)super.setFields(fields);
            }

            public Getsupportedholidays setKey(String key) {
                return (Getsupportedholidays)super.setKey(key);
            }

            public Getsupportedholidays setOauthToken(String oauthToken) {
                return (Getsupportedholidays)super.setOauthToken(oauthToken);
            }

            public Getsupportedholidays setPrettyPrint(Boolean prettyPrint) {
                return (Getsupportedholidays)super.setPrettyPrint(prettyPrint);
            }

            public Getsupportedholidays setQuotaUser(String quotaUser) {
                return (Getsupportedholidays)super.setQuotaUser(quotaUser);
            }

            public Getsupportedholidays setUploadType(String uploadType) {
                return (Getsupportedholidays)super.setUploadType(uploadType);
            }

            public Getsupportedholidays setUploadProtocol(String uploadProtocol) {
                return (Getsupportedholidays)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getsupportedholidays setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Getsupportedholidays set(String parameterName, Object value) {
                return (Getsupportedholidays)super.set(parameterName, value);
            }
        }

        public class Getsupportedcarriers
        extends ShoppingContentRequest<ShippingsettingsGetSupportedCarriersResponse> {
            private static final String REST_PATH = "{merchantId}/supportedCarriers";
            @Key
            private BigInteger merchantId;

            protected Getsupportedcarriers(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingsettingsGetSupportedCarriersResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getsupportedcarriers set$Xgafv(String $Xgafv) {
                return (Getsupportedcarriers)super.set$Xgafv($Xgafv);
            }

            public Getsupportedcarriers setAccessToken(String accessToken) {
                return (Getsupportedcarriers)super.setAccessToken(accessToken);
            }

            public Getsupportedcarriers setAlt(String alt) {
                return (Getsupportedcarriers)super.setAlt(alt);
            }

            public Getsupportedcarriers setCallback(String callback) {
                return (Getsupportedcarriers)super.setCallback(callback);
            }

            public Getsupportedcarriers setFields(String fields) {
                return (Getsupportedcarriers)super.setFields(fields);
            }

            public Getsupportedcarriers setKey(String key) {
                return (Getsupportedcarriers)super.setKey(key);
            }

            public Getsupportedcarriers setOauthToken(String oauthToken) {
                return (Getsupportedcarriers)super.setOauthToken(oauthToken);
            }

            public Getsupportedcarriers setPrettyPrint(Boolean prettyPrint) {
                return (Getsupportedcarriers)super.setPrettyPrint(prettyPrint);
            }

            public Getsupportedcarriers setQuotaUser(String quotaUser) {
                return (Getsupportedcarriers)super.setQuotaUser(quotaUser);
            }

            public Getsupportedcarriers setUploadType(String uploadType) {
                return (Getsupportedcarriers)super.setUploadType(uploadType);
            }

            public Getsupportedcarriers setUploadProtocol(String uploadProtocol) {
                return (Getsupportedcarriers)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getsupportedcarriers setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Getsupportedcarriers set(String parameterName, Object value) {
                return (Getsupportedcarriers)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ShippingSettings> {
            private static final String REST_PATH = "{merchantId}/shippingsettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Get(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ShippingSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<ShippingsettingsCustomBatchResponse> {
            private static final String REST_PATH = "shippingsettings/batch";

            protected Custombatch(ShippingsettingsCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ShippingsettingsCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Settlementtransactions {
        public List list(BigInteger merchantId, String settlementId) throws IOException {
            List result = new List(merchantId, settlementId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<SettlementtransactionsListResponse> {
            private static final String REST_PATH = "{merchantId}/settlementreports/{settlementId}/transactions";
            @Key
            private BigInteger merchantId;
            @Key
            private String settlementId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private java.util.List<String> transactionIds;

            protected List(BigInteger merchantId, String settlementId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, SettlementtransactionsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.settlementId = (String)Preconditions.checkNotNull((Object)settlementId, (Object)"Required parameter settlementId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getSettlementId() {
                return this.settlementId;
            }

            public List setSettlementId(String settlementId) {
                this.settlementId = settlementId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public java.util.List<String> getTransactionIds() {
                return this.transactionIds;
            }

            public List setTransactionIds(java.util.List<String> transactionIds) {
                this.transactionIds = transactionIds;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Settlementreports {
        public Get get(BigInteger merchantId, String settlementId) throws IOException {
            Get result = new Get(merchantId, settlementId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<SettlementreportsListResponse> {
            private static final String REST_PATH = "{merchantId}/settlementreports";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String transferEndDate;
            @Key
            private String transferStartDate;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, SettlementreportsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getTransferEndDate() {
                return this.transferEndDate;
            }

            public List setTransferEndDate(String transferEndDate) {
                this.transferEndDate = transferEndDate;
                return this;
            }

            public String getTransferStartDate() {
                return this.transferStartDate;
            }

            public List setTransferStartDate(String transferStartDate) {
                this.transferStartDate = transferStartDate;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<SettlementReport> {
            private static final String REST_PATH = "{merchantId}/settlementreports/{settlementId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String settlementId;

            protected Get(BigInteger merchantId, String settlementId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, SettlementReport.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.settlementId = (String)Preconditions.checkNotNull((Object)settlementId, (Object)"Required parameter settlementId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getSettlementId() {
                return this.settlementId;
            }

            public Get setSettlementId(String settlementId) {
                this.settlementId = settlementId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Returnpolicyonline {
        public Create create(Long merchantId, ReturnPolicyOnline content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long merchantId, String returnPolicyId) throws IOException {
            Delete result = new Delete(merchantId, returnPolicyId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String returnPolicyId) throws IOException {
            Get result = new Get(merchantId, returnPolicyId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long merchantId, String returnPolicyId, ReturnPolicyOnline content) throws IOException {
            Patch result = new Patch(merchantId, returnPolicyId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends ShoppingContentRequest<ReturnPolicyOnline> {
            private static final String REST_PATH = "{merchantId}/returnpolicyonline/{returnPolicyId}";
            @Key
            private Long merchantId;
            @Key
            private String returnPolicyId;

            protected Patch(Long merchantId, String returnPolicyId, ReturnPolicyOnline content) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, ReturnPolicyOnline.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnPolicyId = (String)Preconditions.checkNotNull((Object)returnPolicyId, (Object)"Required parameter returnPolicyId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnPolicyId() {
                return this.returnPolicyId;
            }

            public Patch setReturnPolicyId(String returnPolicyId) {
                this.returnPolicyId = returnPolicyId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ListReturnPolicyOnlineResponse> {
            private static final String REST_PATH = "{merchantId}/returnpolicyonline";
            @Key
            private Long merchantId;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListReturnPolicyOnlineResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ReturnPolicyOnline> {
            private static final String REST_PATH = "{merchantId}/returnpolicyonline/{returnPolicyId}";
            @Key
            private Long merchantId;
            @Key
            private String returnPolicyId;

            protected Get(Long merchantId, String returnPolicyId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ReturnPolicyOnline.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnPolicyId = (String)Preconditions.checkNotNull((Object)returnPolicyId, (Object)"Required parameter returnPolicyId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnPolicyId() {
                return this.returnPolicyId;
            }

            public Get setReturnPolicyId(String returnPolicyId) {
                this.returnPolicyId = returnPolicyId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/returnpolicyonline/{returnPolicyId}";
            @Key
            private Long merchantId;
            @Key
            private String returnPolicyId;

            protected Delete(Long merchantId, String returnPolicyId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnPolicyId = (String)Preconditions.checkNotNull((Object)returnPolicyId, (Object)"Required parameter returnPolicyId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnPolicyId() {
                return this.returnPolicyId;
            }

            public Delete setReturnPolicyId(String returnPolicyId) {
                this.returnPolicyId = returnPolicyId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<ReturnPolicyOnline> {
            private static final String REST_PATH = "{merchantId}/returnpolicyonline";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, ReturnPolicyOnline content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnPolicyOnline.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Returnpolicy {
        public Custombatch custombatch(ReturnpolicyCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, String returnPolicyId) throws IOException {
            Delete result = new Delete(merchantId, returnPolicyId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, String returnPolicyId) throws IOException {
            Get result = new Get(merchantId, returnPolicyId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, ReturnPolicy content) throws IOException {
            Insert result = new Insert(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ReturnpolicyListResponse> {
            private static final String REST_PATH = "{merchantId}/returnpolicy";
            @Key
            private BigInteger merchantId;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ReturnpolicyListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<ReturnPolicy> {
            private static final String REST_PATH = "{merchantId}/returnpolicy";
            @Key
            private BigInteger merchantId;

            protected Insert(BigInteger merchantId, ReturnPolicy content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnPolicy.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ReturnPolicy> {
            private static final String REST_PATH = "{merchantId}/returnpolicy/{returnPolicyId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnPolicyId;

            protected Get(BigInteger merchantId, String returnPolicyId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ReturnPolicy.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnPolicyId = (String)Preconditions.checkNotNull((Object)returnPolicyId, (Object)"Required parameter returnPolicyId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnPolicyId() {
                return this.returnPolicyId;
            }

            public Get setReturnPolicyId(String returnPolicyId) {
                this.returnPolicyId = returnPolicyId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/returnpolicy/{returnPolicyId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnPolicyId;

            protected Delete(BigInteger merchantId, String returnPolicyId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnPolicyId = (String)Preconditions.checkNotNull((Object)returnPolicyId, (Object)"Required parameter returnPolicyId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnPolicyId() {
                return this.returnPolicyId;
            }

            public Delete setReturnPolicyId(String returnPolicyId) {
                this.returnPolicyId = returnPolicyId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<ReturnpolicyCustomBatchResponse> {
            private static final String REST_PATH = "returnpolicy/batch";

            protected Custombatch(ReturnpolicyCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnpolicyCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Returnaddress {
        public Custombatch custombatch(ReturnaddressCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, String returnAddressId) throws IOException {
            Delete result = new Delete(merchantId, returnAddressId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, String returnAddressId) throws IOException {
            Get result = new Get(merchantId, returnAddressId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, ReturnAddress content) throws IOException {
            Insert result = new Insert(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ReturnaddressListResponse> {
            private static final String REST_PATH = "{merchantId}/returnaddress";
            @Key
            private BigInteger merchantId;
            @Key
            private String country;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ReturnaddressListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public List setCountry(String country) {
                this.country = country;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<ReturnAddress> {
            private static final String REST_PATH = "{merchantId}/returnaddress";
            @Key
            private BigInteger merchantId;

            protected Insert(BigInteger merchantId, ReturnAddress content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnAddress.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ReturnAddress> {
            private static final String REST_PATH = "{merchantId}/returnaddress/{returnAddressId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnAddressId;

            protected Get(BigInteger merchantId, String returnAddressId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ReturnAddress.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnAddressId = (String)Preconditions.checkNotNull((Object)returnAddressId, (Object)"Required parameter returnAddressId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnAddressId() {
                return this.returnAddressId;
            }

            public Get setReturnAddressId(String returnAddressId) {
                this.returnAddressId = returnAddressId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/returnaddress/{returnAddressId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnAddressId;

            protected Delete(BigInteger merchantId, String returnAddressId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnAddressId = (String)Preconditions.checkNotNull((Object)returnAddressId, (Object)"Required parameter returnAddressId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnAddressId() {
                return this.returnAddressId;
            }

            public Delete setReturnAddressId(String returnAddressId) {
                this.returnAddressId = returnAddressId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<ReturnaddressCustomBatchResponse> {
            private static final String REST_PATH = "returnaddress/batch";

            protected Custombatch(ReturnaddressCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnaddressCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Repricingrules {
        public Create create(Long merchantId, RepricingRule content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long merchantId, String ruleId) throws IOException {
            Delete result = new Delete(merchantId, ruleId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String ruleId) throws IOException {
            Get result = new Get(merchantId, ruleId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long merchantId, String ruleId, RepricingRule content) throws IOException {
            Patch result = new Patch(merchantId, ruleId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Repricingreports repricingreports() {
            return new Repricingreports();
        }

        public class Repricingreports {
            public List list(Long merchantId, String ruleId) throws IOException {
                List result = new List(merchantId, ruleId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends ShoppingContentRequest<ListRepricingRuleReportsResponse> {
                private static final String REST_PATH = "{merchantId}/repricingrules/{ruleId}/repricingreports";
                @Key
                private Long merchantId;
                @Key
                private String ruleId;
                @Key
                private String endDate;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String startDate;

                protected List(Long merchantId, String ruleId) {
                    super(ShoppingContent.this, "GET", REST_PATH, null, ListRepricingRuleReportsResponse.class);
                    this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                    this.ruleId = (String)Preconditions.checkNotNull((Object)ruleId, (Object)"Required parameter ruleId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getMerchantId() {
                    return this.merchantId;
                }

                public List setMerchantId(Long merchantId) {
                    this.merchantId = merchantId;
                    return this;
                }

                public String getRuleId() {
                    return this.ruleId;
                }

                public List setRuleId(String ruleId) {
                    this.ruleId = ruleId;
                    return this;
                }

                public String getEndDate() {
                    return this.endDate;
                }

                public List setEndDate(String endDate) {
                    this.endDate = endDate;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getStartDate() {
                    return this.startDate;
                }

                public List setStartDate(String startDate) {
                    this.startDate = startDate;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class Patch
        extends ShoppingContentRequest<RepricingRule> {
            private static final String REST_PATH = "{merchantId}/repricingrules/{ruleId}";
            @Key
            private Long merchantId;
            @Key
            private String ruleId;

            protected Patch(Long merchantId, String ruleId, RepricingRule content) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, RepricingRule.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)ruleId, (Object)"Required parameter ruleId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Patch setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ListRepricingRulesResponse> {
            private static final String REST_PATH = "{merchantId}/repricingrules";
            @Key
            private Long merchantId;
            @Key
            private String countryCode;
            @Key
            private String languageCode;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListRepricingRulesResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getCountryCode() {
                return this.countryCode;
            }

            public List setCountryCode(String countryCode) {
                this.countryCode = countryCode;
                return this;
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public List setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<RepricingRule> {
            private static final String REST_PATH = "{merchantId}/repricingrules/{ruleId}";
            @Key
            private Long merchantId;
            @Key
            private String ruleId;

            protected Get(Long merchantId, String ruleId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, RepricingRule.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)ruleId, (Object)"Required parameter ruleId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Get setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/repricingrules/{ruleId}";
            @Key
            private Long merchantId;
            @Key
            private String ruleId;

            protected Delete(Long merchantId, String ruleId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.ruleId = (String)Preconditions.checkNotNull((Object)ruleId, (Object)"Required parameter ruleId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Delete setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<RepricingRule> {
            private static final String REST_PATH = "{merchantId}/repricingrules";
            @Key
            private Long merchantId;
            @Key
            private String ruleId;

            protected Create(Long merchantId, RepricingRule content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, RepricingRule.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Create setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Reports {
        public Search search(Long merchantId, SearchRequest content) throws IOException {
            Search result = new Search(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Search
        extends ShoppingContentRequest<SearchResponse> {
            private static final String REST_PATH = "{merchantId}/reports/search";
            @Key
            private Long merchantId;

            protected Search(Long merchantId, SearchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, SearchResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Search setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }
    }

    public class Regions {
        public Create create(Long merchantId, Region content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long merchantId, String regionId) throws IOException {
            Delete result = new Delete(merchantId, regionId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String regionId) throws IOException {
            Get result = new Get(merchantId, regionId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long merchantId, String regionId, Region content) throws IOException {
            Patch result = new Patch(merchantId, regionId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends ShoppingContentRequest<Region> {
            private static final String REST_PATH = "{merchantId}/regions/{regionId}";
            @Key
            private Long merchantId;
            @Key
            private String regionId;
            @Key
            private String updateMask;

            protected Patch(Long merchantId, String regionId, Region content) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, Region.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionId = (String)Preconditions.checkNotNull((Object)regionId, (Object)"Required parameter regionId must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionId() {
                return this.regionId;
            }

            public Patch setRegionId(String regionId) {
                this.regionId = regionId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ListRegionsResponse> {
            private static final String REST_PATH = "{merchantId}/regions";
            @Key
            private Long merchantId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListRegionsResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Region> {
            private static final String REST_PATH = "{merchantId}/regions/{regionId}";
            @Key
            private Long merchantId;
            @Key
            private String regionId;

            protected Get(Long merchantId, String regionId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Region.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionId = (String)Preconditions.checkNotNull((Object)regionId, (Object)"Required parameter regionId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionId() {
                return this.regionId;
            }

            public Get setRegionId(String regionId) {
                this.regionId = regionId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/regions/{regionId}";
            @Key
            private Long merchantId;
            @Key
            private String regionId;

            protected Delete(Long merchantId, String regionId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionId = (String)Preconditions.checkNotNull((Object)regionId, (Object)"Required parameter regionId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionId() {
                return this.regionId;
            }

            public Delete setRegionId(String regionId) {
                this.regionId = regionId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<Region> {
            private static final String REST_PATH = "{merchantId}/regions";
            @Key
            private Long merchantId;
            @Key
            private String regionId;

            protected Create(Long merchantId, Region content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Region.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionId() {
                return this.regionId;
            }

            public Create setRegionId(String regionId) {
                this.regionId = regionId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Regionalinventory {
        public Custombatch custombatch(RegionalinventoryCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, String productId, RegionalInventory content) throws IOException {
            Insert result = new Insert(merchantId, productId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Insert
        extends ShoppingContentRequest<RegionalInventory> {
            private static final String REST_PATH = "{merchantId}/products/{productId}/regionalinventory";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;

            protected Insert(BigInteger merchantId, String productId, RegionalInventory content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, RegionalInventory.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Insert setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<RegionalinventoryCustomBatchResponse> {
            private static final String REST_PATH = "regionalinventory/batch";

            protected Custombatch(RegionalinventoryCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, RegionalinventoryCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Quotas {
        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ListMethodQuotasResponse> {
            private static final String REST_PATH = "{merchantId}/quotas";
            @Key
            private Long merchantId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListMethodQuotasResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Pubsubnotificationsettings {
        public Get get(BigInteger merchantId) throws IOException {
            Get result = new Get(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, PubsubNotificationSettings content) throws IOException {
            Update result = new Update(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<PubsubNotificationSettings> {
            private static final String REST_PATH = "{merchantId}/pubsubnotificationsettings";
            @Key
            private BigInteger merchantId;

            protected Update(BigInteger merchantId, PubsubNotificationSettings content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, PubsubNotificationSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<PubsubNotificationSettings> {
            private static final String REST_PATH = "{merchantId}/pubsubnotificationsettings";
            @Key
            private BigInteger merchantId;

            protected Get(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, PubsubNotificationSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Promotions {
        public Create create(Long merchantId, Promotion content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String id) throws IOException {
            Get result = new Get(merchantId, id);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends ShoppingContentRequest<Promotion> {
            private static final String REST_PATH = "{merchantId}/promotions/{id}";
            @Key
            private Long merchantId;
            @Key
            private String id;

            protected Get(Long merchantId, String id) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Promotion.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"Required parameter id must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getId() {
                return this.id;
            }

            public Get setId(String id) {
                this.id = id;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<Promotion> {
            private static final String REST_PATH = "{merchantId}/promotions";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, Promotion content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Promotion.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Productstatuses {
        public Custombatch custombatch(ProductstatusesCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, String productId) throws IOException {
            Get result = new Get(merchantId, productId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Repricingreports repricingreports() {
            return new Repricingreports();
        }

        public class Repricingreports {
            public List list(Long merchantId, String productId) throws IOException {
                List result = new List(merchantId, productId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends ShoppingContentRequest<ListRepricingProductReportsResponse> {
                private static final String REST_PATH = "{merchantId}/productstatuses/{productId}/repricingreports";
                @Key
                private Long merchantId;
                @Key
                private String productId;
                @Key
                private String endDate;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;
                @Key
                private String ruleId;
                @Key
                private String startDate;

                protected List(Long merchantId, String productId) {
                    super(ShoppingContent.this, "GET", REST_PATH, null, ListRepricingProductReportsResponse.class);
                    this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                    this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getMerchantId() {
                    return this.merchantId;
                }

                public List setMerchantId(Long merchantId) {
                    this.merchantId = merchantId;
                    return this;
                }

                public String getProductId() {
                    return this.productId;
                }

                public List setProductId(String productId) {
                    this.productId = productId;
                    return this;
                }

                public String getEndDate() {
                    return this.endDate;
                }

                public List setEndDate(String endDate) {
                    this.endDate = endDate;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public String getRuleId() {
                    return this.ruleId;
                }

                public List setRuleId(String ruleId) {
                    this.ruleId = ruleId;
                    return this;
                }

                public String getStartDate() {
                    return this.startDate;
                }

                public List setStartDate(String startDate) {
                    this.startDate = startDate;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class List
        extends ShoppingContentRequest<ProductstatusesListResponse> {
            private static final String REST_PATH = "{merchantId}/productstatuses";
            @Key
            private BigInteger merchantId;
            @Key
            private java.util.List<String> destinations;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductstatusesListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public List setDestinations(java.util.List<String> destinations) {
                this.destinations = destinations;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<ProductStatus> {
            private static final String REST_PATH = "{merchantId}/productstatuses/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;
            @Key
            private java.util.List<String> destinations;

            protected Get(BigInteger merchantId, String productId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductStatus.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Get setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public Get setDestinations(java.util.List<String> destinations) {
                this.destinations = destinations;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<ProductstatusesCustomBatchResponse> {
            private static final String REST_PATH = "productstatuses/batch";

            protected Custombatch(ProductstatusesCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ProductstatusesCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Products {
        public Custombatch custombatch(ProductsCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, String productId) throws IOException {
            Delete result = new Delete(merchantId, productId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, String productId) throws IOException {
            Get result = new Get(merchantId, productId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, Product content) throws IOException {
            Insert result = new Insert(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, String productId, Product content) throws IOException {
            Update result = new Update(merchantId, productId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<Product> {
            private static final String REST_PATH = "{merchantId}/products/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;
            @Key
            private String updateMask;

            protected Update(BigInteger merchantId, String productId, Product content) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, Product.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Update setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Update setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ProductsListResponse> {
            private static final String REST_PATH = "{merchantId}/products";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<Product> {
            private static final String REST_PATH = "{merchantId}/products";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger feedId;

            protected Insert(BigInteger merchantId, Product content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Product.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getFeedId() {
                return this.feedId;
            }

            public Insert setFeedId(BigInteger feedId) {
                this.feedId = feedId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Product> {
            private static final String REST_PATH = "{merchantId}/products/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;

            protected Get(BigInteger merchantId, String productId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Product.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Get setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/products/{productId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;
            @Key
            private BigInteger feedId;

            protected Delete(BigInteger merchantId, String productId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Delete setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            public BigInteger getFeedId() {
                return this.feedId;
            }

            public Delete setFeedId(BigInteger feedId) {
                this.feedId = feedId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<ProductsCustomBatchResponse> {
            private static final String REST_PATH = "products/batch";

            protected Custombatch(ProductsCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ProductsCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Productdeliverytime {
        public Create create(Long merchantId, ProductDeliveryTime content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long merchantId, String productId) throws IOException {
            Delete result = new Delete(merchantId, productId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String productId) throws IOException {
            Get result = new Get(merchantId, productId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Get
        extends ShoppingContentRequest<ProductDeliveryTime> {
            private static final String REST_PATH = "{merchantId}/productdeliverytime/{productId}";
            @Key
            private Long merchantId;
            @Key
            private String productId;

            protected Get(Long merchantId, String productId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ProductDeliveryTime.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Get setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/productdeliverytime/{productId}";
            @Key
            private Long merchantId;
            @Key
            private String productId;

            protected Delete(Long merchantId, String productId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Delete setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<ProductDeliveryTime> {
            private static final String REST_PATH = "{merchantId}/productdeliverytime";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, ProductDeliveryTime content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ProductDeliveryTime.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Pos {
        public Custombatch custombatch(PosCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, BigInteger targetMerchantId, String storeCode) throws IOException {
            Delete result = new Delete(merchantId, targetMerchantId, storeCode);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger targetMerchantId, String storeCode) throws IOException {
            Get result = new Get(merchantId, targetMerchantId, storeCode);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, BigInteger targetMerchantId, PosStore content) throws IOException {
            Insert result = new Insert(merchantId, targetMerchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Inventory inventory(BigInteger merchantId, BigInteger targetMerchantId, PosInventoryRequest content) throws IOException {
            Inventory result = new Inventory(merchantId, targetMerchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId, BigInteger targetMerchantId) throws IOException {
            List result = new List(merchantId, targetMerchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Sale sale(BigInteger merchantId, BigInteger targetMerchantId, PosSaleRequest content) throws IOException {
            Sale result = new Sale(merchantId, targetMerchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Sale
        extends ShoppingContentRequest<PosSaleResponse> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/sale";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;

            protected Sale(BigInteger merchantId, BigInteger targetMerchantId, PosSaleRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, PosSaleResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
            }

            public Sale set$Xgafv(String $Xgafv) {
                return (Sale)super.set$Xgafv($Xgafv);
            }

            public Sale setAccessToken(String accessToken) {
                return (Sale)super.setAccessToken(accessToken);
            }

            public Sale setAlt(String alt) {
                return (Sale)super.setAlt(alt);
            }

            public Sale setCallback(String callback) {
                return (Sale)super.setCallback(callback);
            }

            public Sale setFields(String fields) {
                return (Sale)super.setFields(fields);
            }

            public Sale setKey(String key) {
                return (Sale)super.setKey(key);
            }

            public Sale setOauthToken(String oauthToken) {
                return (Sale)super.setOauthToken(oauthToken);
            }

            public Sale setPrettyPrint(Boolean prettyPrint) {
                return (Sale)super.setPrettyPrint(prettyPrint);
            }

            public Sale setQuotaUser(String quotaUser) {
                return (Sale)super.setQuotaUser(quotaUser);
            }

            public Sale setUploadType(String uploadType) {
                return (Sale)super.setUploadType(uploadType);
            }

            public Sale setUploadProtocol(String uploadProtocol) {
                return (Sale)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Sale setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Sale setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            @Override
            public Sale set(String parameterName, Object value) {
                return (Sale)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<PosListResponse> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;

            protected List(BigInteger merchantId, BigInteger targetMerchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, PosListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public List setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Inventory
        extends ShoppingContentRequest<PosInventoryResponse> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/inventory";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;

            protected Inventory(BigInteger merchantId, BigInteger targetMerchantId, PosInventoryRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, PosInventoryResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
            }

            public Inventory set$Xgafv(String $Xgafv) {
                return (Inventory)super.set$Xgafv($Xgafv);
            }

            public Inventory setAccessToken(String accessToken) {
                return (Inventory)super.setAccessToken(accessToken);
            }

            public Inventory setAlt(String alt) {
                return (Inventory)super.setAlt(alt);
            }

            public Inventory setCallback(String callback) {
                return (Inventory)super.setCallback(callback);
            }

            public Inventory setFields(String fields) {
                return (Inventory)super.setFields(fields);
            }

            public Inventory setKey(String key) {
                return (Inventory)super.setKey(key);
            }

            public Inventory setOauthToken(String oauthToken) {
                return (Inventory)super.setOauthToken(oauthToken);
            }

            public Inventory setPrettyPrint(Boolean prettyPrint) {
                return (Inventory)super.setPrettyPrint(prettyPrint);
            }

            public Inventory setQuotaUser(String quotaUser) {
                return (Inventory)super.setQuotaUser(quotaUser);
            }

            public Inventory setUploadType(String uploadType) {
                return (Inventory)super.setUploadType(uploadType);
            }

            public Inventory setUploadProtocol(String uploadProtocol) {
                return (Inventory)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Inventory setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Inventory setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            @Override
            public Inventory set(String parameterName, Object value) {
                return (Inventory)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<PosStore> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;

            protected Insert(BigInteger merchantId, BigInteger targetMerchantId, PosStore content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, PosStore.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Insert setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<PosStore> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store/{storeCode}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;
            @Key
            private String storeCode;

            protected Get(BigInteger merchantId, BigInteger targetMerchantId, String storeCode) {
                super(ShoppingContent.this, "GET", REST_PATH, null, PosStore.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
                this.storeCode = (String)Preconditions.checkNotNull((Object)storeCode, (Object)"Required parameter storeCode must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Get setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            public String getStoreCode() {
                return this.storeCode;
            }

            public Get setStoreCode(String storeCode) {
                this.storeCode = storeCode;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/pos/{targetMerchantId}/store/{storeCode}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger targetMerchantId;
            @Key
            private String storeCode;

            protected Delete(BigInteger merchantId, BigInteger targetMerchantId, String storeCode) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.targetMerchantId = (BigInteger)Preconditions.checkNotNull((Object)targetMerchantId, (Object)"Required parameter targetMerchantId must be specified.");
                this.storeCode = (String)Preconditions.checkNotNull((Object)storeCode, (Object)"Required parameter storeCode must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getTargetMerchantId() {
                return this.targetMerchantId;
            }

            public Delete setTargetMerchantId(BigInteger targetMerchantId) {
                this.targetMerchantId = targetMerchantId;
                return this;
            }

            public String getStoreCode() {
                return this.storeCode;
            }

            public Delete setStoreCode(String storeCode) {
                this.storeCode = storeCode;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<PosCustomBatchResponse> {
            private static final String REST_PATH = "pos/batch";

            protected Custombatch(PosCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, PosCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Ordertrackingsignals {
        public Create create(Long merchantId, OrderTrackingSignal content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Create
        extends ShoppingContentRequest<OrderTrackingSignal> {
            private static final String REST_PATH = "{merchantId}/ordertrackingsignals";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, OrderTrackingSignal content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrderTrackingSignal.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Orders {
        public Acknowledge acknowledge(BigInteger merchantId, String orderId, OrdersAcknowledgeRequest content) throws IOException {
            Acknowledge result = new Acknowledge(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Advancetestorder advancetestorder(BigInteger merchantId, String orderId) throws IOException {
            Advancetestorder result = new Advancetestorder(merchantId, orderId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Cancel cancel(BigInteger merchantId, String orderId, OrdersCancelRequest content) throws IOException {
            Cancel result = new Cancel(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Cancellineitem cancellineitem(BigInteger merchantId, String orderId, OrdersCancelLineItemRequest content) throws IOException {
            Cancellineitem result = new Cancellineitem(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Canceltestorderbycustomer canceltestorderbycustomer(BigInteger merchantId, String orderId, OrdersCancelTestOrderByCustomerRequest content) throws IOException {
            Canceltestorderbycustomer result = new Canceltestorderbycustomer(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public CaptureOrder captureOrder(Long merchantId, String orderId, CaptureOrderRequest content) throws IOException {
            CaptureOrder result = new CaptureOrder(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Createtestorder createtestorder(BigInteger merchantId, OrdersCreateTestOrderRequest content) throws IOException {
            Createtestorder result = new Createtestorder(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Createtestreturn createtestreturn(BigInteger merchantId, String orderId, OrdersCreateTestReturnRequest content) throws IOException {
            Createtestreturn result = new Createtestreturn(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, String orderId) throws IOException {
            Get result = new Get(merchantId, orderId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Getbymerchantorderid getbymerchantorderid(BigInteger merchantId, String merchantOrderId) throws IOException {
            Getbymerchantorderid result = new Getbymerchantorderid(merchantId, merchantOrderId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Gettestordertemplate gettestordertemplate(BigInteger merchantId, String templateName) throws IOException {
            Gettestordertemplate result = new Gettestordertemplate(merchantId, templateName);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Instorerefundlineitem instorerefundlineitem(BigInteger merchantId, String orderId, OrdersInStoreRefundLineItemRequest content) throws IOException {
            Instorerefundlineitem result = new Instorerefundlineitem(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Refunditem refunditem(BigInteger merchantId, String orderId, OrdersRefundItemRequest content) throws IOException {
            Refunditem result = new Refunditem(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Refundorder refundorder(BigInteger merchantId, String orderId, OrdersRefundOrderRequest content) throws IOException {
            Refundorder result = new Refundorder(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Rejectreturnlineitem rejectreturnlineitem(BigInteger merchantId, String orderId, OrdersRejectReturnLineItemRequest content) throws IOException {
            Rejectreturnlineitem result = new Rejectreturnlineitem(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Returnrefundlineitem returnrefundlineitem(BigInteger merchantId, String orderId, OrdersReturnRefundLineItemRequest content) throws IOException {
            Returnrefundlineitem result = new Returnrefundlineitem(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Setlineitemmetadata setlineitemmetadata(BigInteger merchantId, String orderId, OrdersSetLineItemMetadataRequest content) throws IOException {
            Setlineitemmetadata result = new Setlineitemmetadata(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Shiplineitems shiplineitems(BigInteger merchantId, String orderId, OrdersShipLineItemsRequest content) throws IOException {
            Shiplineitems result = new Shiplineitems(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Updatelineitemshippingdetails updatelineitemshippingdetails(BigInteger merchantId, String orderId, OrdersUpdateLineItemShippingDetailsRequest content) throws IOException {
            Updatelineitemshippingdetails result = new Updatelineitemshippingdetails(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Updatemerchantorderid updatemerchantorderid(BigInteger merchantId, String orderId, OrdersUpdateMerchantOrderIdRequest content) throws IOException {
            Updatemerchantorderid result = new Updatemerchantorderid(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Updateshipment updateshipment(BigInteger merchantId, String orderId, OrdersUpdateShipmentRequest content) throws IOException {
            Updateshipment result = new Updateshipment(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Updateshipment
        extends ShoppingContentRequest<OrdersUpdateShipmentResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/updateShipment";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Updateshipment(BigInteger merchantId, String orderId, OrdersUpdateShipmentRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersUpdateShipmentResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Updateshipment set$Xgafv(String $Xgafv) {
                return (Updateshipment)super.set$Xgafv($Xgafv);
            }

            public Updateshipment setAccessToken(String accessToken) {
                return (Updateshipment)super.setAccessToken(accessToken);
            }

            public Updateshipment setAlt(String alt) {
                return (Updateshipment)super.setAlt(alt);
            }

            public Updateshipment setCallback(String callback) {
                return (Updateshipment)super.setCallback(callback);
            }

            public Updateshipment setFields(String fields) {
                return (Updateshipment)super.setFields(fields);
            }

            public Updateshipment setKey(String key) {
                return (Updateshipment)super.setKey(key);
            }

            public Updateshipment setOauthToken(String oauthToken) {
                return (Updateshipment)super.setOauthToken(oauthToken);
            }

            public Updateshipment setPrettyPrint(Boolean prettyPrint) {
                return (Updateshipment)super.setPrettyPrint(prettyPrint);
            }

            public Updateshipment setQuotaUser(String quotaUser) {
                return (Updateshipment)super.setQuotaUser(quotaUser);
            }

            public Updateshipment setUploadType(String uploadType) {
                return (Updateshipment)super.setUploadType(uploadType);
            }

            public Updateshipment setUploadProtocol(String uploadProtocol) {
                return (Updateshipment)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Updateshipment setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Updateshipment setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Updateshipment set(String parameterName, Object value) {
                return (Updateshipment)super.set(parameterName, value);
            }
        }

        public class Updatemerchantorderid
        extends ShoppingContentRequest<OrdersUpdateMerchantOrderIdResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/updateMerchantOrderId";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Updatemerchantorderid(BigInteger merchantId, String orderId, OrdersUpdateMerchantOrderIdRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersUpdateMerchantOrderIdResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Updatemerchantorderid set$Xgafv(String $Xgafv) {
                return (Updatemerchantorderid)super.set$Xgafv($Xgafv);
            }

            public Updatemerchantorderid setAccessToken(String accessToken) {
                return (Updatemerchantorderid)super.setAccessToken(accessToken);
            }

            public Updatemerchantorderid setAlt(String alt) {
                return (Updatemerchantorderid)super.setAlt(alt);
            }

            public Updatemerchantorderid setCallback(String callback) {
                return (Updatemerchantorderid)super.setCallback(callback);
            }

            public Updatemerchantorderid setFields(String fields) {
                return (Updatemerchantorderid)super.setFields(fields);
            }

            public Updatemerchantorderid setKey(String key) {
                return (Updatemerchantorderid)super.setKey(key);
            }

            public Updatemerchantorderid setOauthToken(String oauthToken) {
                return (Updatemerchantorderid)super.setOauthToken(oauthToken);
            }

            public Updatemerchantorderid setPrettyPrint(Boolean prettyPrint) {
                return (Updatemerchantorderid)super.setPrettyPrint(prettyPrint);
            }

            public Updatemerchantorderid setQuotaUser(String quotaUser) {
                return (Updatemerchantorderid)super.setQuotaUser(quotaUser);
            }

            public Updatemerchantorderid setUploadType(String uploadType) {
                return (Updatemerchantorderid)super.setUploadType(uploadType);
            }

            public Updatemerchantorderid setUploadProtocol(String uploadProtocol) {
                return (Updatemerchantorderid)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Updatemerchantorderid setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Updatemerchantorderid setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Updatemerchantorderid set(String parameterName, Object value) {
                return (Updatemerchantorderid)super.set(parameterName, value);
            }
        }

        public class Updatelineitemshippingdetails
        extends ShoppingContentRequest<OrdersUpdateLineItemShippingDetailsResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/updateLineItemShippingDetails";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Updatelineitemshippingdetails(BigInteger merchantId, String orderId, OrdersUpdateLineItemShippingDetailsRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersUpdateLineItemShippingDetailsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Updatelineitemshippingdetails set$Xgafv(String $Xgafv) {
                return (Updatelineitemshippingdetails)super.set$Xgafv($Xgafv);
            }

            public Updatelineitemshippingdetails setAccessToken(String accessToken) {
                return (Updatelineitemshippingdetails)super.setAccessToken(accessToken);
            }

            public Updatelineitemshippingdetails setAlt(String alt) {
                return (Updatelineitemshippingdetails)super.setAlt(alt);
            }

            public Updatelineitemshippingdetails setCallback(String callback) {
                return (Updatelineitemshippingdetails)super.setCallback(callback);
            }

            public Updatelineitemshippingdetails setFields(String fields) {
                return (Updatelineitemshippingdetails)super.setFields(fields);
            }

            public Updatelineitemshippingdetails setKey(String key) {
                return (Updatelineitemshippingdetails)super.setKey(key);
            }

            public Updatelineitemshippingdetails setOauthToken(String oauthToken) {
                return (Updatelineitemshippingdetails)super.setOauthToken(oauthToken);
            }

            public Updatelineitemshippingdetails setPrettyPrint(Boolean prettyPrint) {
                return (Updatelineitemshippingdetails)super.setPrettyPrint(prettyPrint);
            }

            public Updatelineitemshippingdetails setQuotaUser(String quotaUser) {
                return (Updatelineitemshippingdetails)super.setQuotaUser(quotaUser);
            }

            public Updatelineitemshippingdetails setUploadType(String uploadType) {
                return (Updatelineitemshippingdetails)super.setUploadType(uploadType);
            }

            public Updatelineitemshippingdetails setUploadProtocol(String uploadProtocol) {
                return (Updatelineitemshippingdetails)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Updatelineitemshippingdetails setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Updatelineitemshippingdetails setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Updatelineitemshippingdetails set(String parameterName, Object value) {
                return (Updatelineitemshippingdetails)super.set(parameterName, value);
            }
        }

        public class Shiplineitems
        extends ShoppingContentRequest<OrdersShipLineItemsResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/shipLineItems";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Shiplineitems(BigInteger merchantId, String orderId, OrdersShipLineItemsRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersShipLineItemsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Shiplineitems set$Xgafv(String $Xgafv) {
                return (Shiplineitems)super.set$Xgafv($Xgafv);
            }

            public Shiplineitems setAccessToken(String accessToken) {
                return (Shiplineitems)super.setAccessToken(accessToken);
            }

            public Shiplineitems setAlt(String alt) {
                return (Shiplineitems)super.setAlt(alt);
            }

            public Shiplineitems setCallback(String callback) {
                return (Shiplineitems)super.setCallback(callback);
            }

            public Shiplineitems setFields(String fields) {
                return (Shiplineitems)super.setFields(fields);
            }

            public Shiplineitems setKey(String key) {
                return (Shiplineitems)super.setKey(key);
            }

            public Shiplineitems setOauthToken(String oauthToken) {
                return (Shiplineitems)super.setOauthToken(oauthToken);
            }

            public Shiplineitems setPrettyPrint(Boolean prettyPrint) {
                return (Shiplineitems)super.setPrettyPrint(prettyPrint);
            }

            public Shiplineitems setQuotaUser(String quotaUser) {
                return (Shiplineitems)super.setQuotaUser(quotaUser);
            }

            public Shiplineitems setUploadType(String uploadType) {
                return (Shiplineitems)super.setUploadType(uploadType);
            }

            public Shiplineitems setUploadProtocol(String uploadProtocol) {
                return (Shiplineitems)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Shiplineitems setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Shiplineitems setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Shiplineitems set(String parameterName, Object value) {
                return (Shiplineitems)super.set(parameterName, value);
            }
        }

        public class Setlineitemmetadata
        extends ShoppingContentRequest<OrdersSetLineItemMetadataResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/setLineItemMetadata";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Setlineitemmetadata(BigInteger merchantId, String orderId, OrdersSetLineItemMetadataRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersSetLineItemMetadataResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Setlineitemmetadata set$Xgafv(String $Xgafv) {
                return (Setlineitemmetadata)super.set$Xgafv($Xgafv);
            }

            public Setlineitemmetadata setAccessToken(String accessToken) {
                return (Setlineitemmetadata)super.setAccessToken(accessToken);
            }

            public Setlineitemmetadata setAlt(String alt) {
                return (Setlineitemmetadata)super.setAlt(alt);
            }

            public Setlineitemmetadata setCallback(String callback) {
                return (Setlineitemmetadata)super.setCallback(callback);
            }

            public Setlineitemmetadata setFields(String fields) {
                return (Setlineitemmetadata)super.setFields(fields);
            }

            public Setlineitemmetadata setKey(String key) {
                return (Setlineitemmetadata)super.setKey(key);
            }

            public Setlineitemmetadata setOauthToken(String oauthToken) {
                return (Setlineitemmetadata)super.setOauthToken(oauthToken);
            }

            public Setlineitemmetadata setPrettyPrint(Boolean prettyPrint) {
                return (Setlineitemmetadata)super.setPrettyPrint(prettyPrint);
            }

            public Setlineitemmetadata setQuotaUser(String quotaUser) {
                return (Setlineitemmetadata)super.setQuotaUser(quotaUser);
            }

            public Setlineitemmetadata setUploadType(String uploadType) {
                return (Setlineitemmetadata)super.setUploadType(uploadType);
            }

            public Setlineitemmetadata setUploadProtocol(String uploadProtocol) {
                return (Setlineitemmetadata)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Setlineitemmetadata setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Setlineitemmetadata setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Setlineitemmetadata set(String parameterName, Object value) {
                return (Setlineitemmetadata)super.set(parameterName, value);
            }
        }

        public class Returnrefundlineitem
        extends ShoppingContentRequest<OrdersReturnRefundLineItemResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/returnRefundLineItem";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Returnrefundlineitem(BigInteger merchantId, String orderId, OrdersReturnRefundLineItemRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersReturnRefundLineItemResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Returnrefundlineitem set$Xgafv(String $Xgafv) {
                return (Returnrefundlineitem)super.set$Xgafv($Xgafv);
            }

            public Returnrefundlineitem setAccessToken(String accessToken) {
                return (Returnrefundlineitem)super.setAccessToken(accessToken);
            }

            public Returnrefundlineitem setAlt(String alt) {
                return (Returnrefundlineitem)super.setAlt(alt);
            }

            public Returnrefundlineitem setCallback(String callback) {
                return (Returnrefundlineitem)super.setCallback(callback);
            }

            public Returnrefundlineitem setFields(String fields) {
                return (Returnrefundlineitem)super.setFields(fields);
            }

            public Returnrefundlineitem setKey(String key) {
                return (Returnrefundlineitem)super.setKey(key);
            }

            public Returnrefundlineitem setOauthToken(String oauthToken) {
                return (Returnrefundlineitem)super.setOauthToken(oauthToken);
            }

            public Returnrefundlineitem setPrettyPrint(Boolean prettyPrint) {
                return (Returnrefundlineitem)super.setPrettyPrint(prettyPrint);
            }

            public Returnrefundlineitem setQuotaUser(String quotaUser) {
                return (Returnrefundlineitem)super.setQuotaUser(quotaUser);
            }

            public Returnrefundlineitem setUploadType(String uploadType) {
                return (Returnrefundlineitem)super.setUploadType(uploadType);
            }

            public Returnrefundlineitem setUploadProtocol(String uploadProtocol) {
                return (Returnrefundlineitem)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Returnrefundlineitem setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Returnrefundlineitem setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Returnrefundlineitem set(String parameterName, Object value) {
                return (Returnrefundlineitem)super.set(parameterName, value);
            }
        }

        public class Rejectreturnlineitem
        extends ShoppingContentRequest<OrdersRejectReturnLineItemResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/rejectReturnLineItem";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Rejectreturnlineitem(BigInteger merchantId, String orderId, OrdersRejectReturnLineItemRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersRejectReturnLineItemResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Rejectreturnlineitem set$Xgafv(String $Xgafv) {
                return (Rejectreturnlineitem)super.set$Xgafv($Xgafv);
            }

            public Rejectreturnlineitem setAccessToken(String accessToken) {
                return (Rejectreturnlineitem)super.setAccessToken(accessToken);
            }

            public Rejectreturnlineitem setAlt(String alt) {
                return (Rejectreturnlineitem)super.setAlt(alt);
            }

            public Rejectreturnlineitem setCallback(String callback) {
                return (Rejectreturnlineitem)super.setCallback(callback);
            }

            public Rejectreturnlineitem setFields(String fields) {
                return (Rejectreturnlineitem)super.setFields(fields);
            }

            public Rejectreturnlineitem setKey(String key) {
                return (Rejectreturnlineitem)super.setKey(key);
            }

            public Rejectreturnlineitem setOauthToken(String oauthToken) {
                return (Rejectreturnlineitem)super.setOauthToken(oauthToken);
            }

            public Rejectreturnlineitem setPrettyPrint(Boolean prettyPrint) {
                return (Rejectreturnlineitem)super.setPrettyPrint(prettyPrint);
            }

            public Rejectreturnlineitem setQuotaUser(String quotaUser) {
                return (Rejectreturnlineitem)super.setQuotaUser(quotaUser);
            }

            public Rejectreturnlineitem setUploadType(String uploadType) {
                return (Rejectreturnlineitem)super.setUploadType(uploadType);
            }

            public Rejectreturnlineitem setUploadProtocol(String uploadProtocol) {
                return (Rejectreturnlineitem)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Rejectreturnlineitem setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Rejectreturnlineitem setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Rejectreturnlineitem set(String parameterName, Object value) {
                return (Rejectreturnlineitem)super.set(parameterName, value);
            }
        }

        public class Refundorder
        extends ShoppingContentRequest<OrdersRefundOrderResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/refundorder";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Refundorder(BigInteger merchantId, String orderId, OrdersRefundOrderRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersRefundOrderResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Refundorder set$Xgafv(String $Xgafv) {
                return (Refundorder)super.set$Xgafv($Xgafv);
            }

            public Refundorder setAccessToken(String accessToken) {
                return (Refundorder)super.setAccessToken(accessToken);
            }

            public Refundorder setAlt(String alt) {
                return (Refundorder)super.setAlt(alt);
            }

            public Refundorder setCallback(String callback) {
                return (Refundorder)super.setCallback(callback);
            }

            public Refundorder setFields(String fields) {
                return (Refundorder)super.setFields(fields);
            }

            public Refundorder setKey(String key) {
                return (Refundorder)super.setKey(key);
            }

            public Refundorder setOauthToken(String oauthToken) {
                return (Refundorder)super.setOauthToken(oauthToken);
            }

            public Refundorder setPrettyPrint(Boolean prettyPrint) {
                return (Refundorder)super.setPrettyPrint(prettyPrint);
            }

            public Refundorder setQuotaUser(String quotaUser) {
                return (Refundorder)super.setQuotaUser(quotaUser);
            }

            public Refundorder setUploadType(String uploadType) {
                return (Refundorder)super.setUploadType(uploadType);
            }

            public Refundorder setUploadProtocol(String uploadProtocol) {
                return (Refundorder)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Refundorder setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Refundorder setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Refundorder set(String parameterName, Object value) {
                return (Refundorder)super.set(parameterName, value);
            }
        }

        public class Refunditem
        extends ShoppingContentRequest<OrdersRefundItemResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/refunditem";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Refunditem(BigInteger merchantId, String orderId, OrdersRefundItemRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersRefundItemResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Refunditem set$Xgafv(String $Xgafv) {
                return (Refunditem)super.set$Xgafv($Xgafv);
            }

            public Refunditem setAccessToken(String accessToken) {
                return (Refunditem)super.setAccessToken(accessToken);
            }

            public Refunditem setAlt(String alt) {
                return (Refunditem)super.setAlt(alt);
            }

            public Refunditem setCallback(String callback) {
                return (Refunditem)super.setCallback(callback);
            }

            public Refunditem setFields(String fields) {
                return (Refunditem)super.setFields(fields);
            }

            public Refunditem setKey(String key) {
                return (Refunditem)super.setKey(key);
            }

            public Refunditem setOauthToken(String oauthToken) {
                return (Refunditem)super.setOauthToken(oauthToken);
            }

            public Refunditem setPrettyPrint(Boolean prettyPrint) {
                return (Refunditem)super.setPrettyPrint(prettyPrint);
            }

            public Refunditem setQuotaUser(String quotaUser) {
                return (Refunditem)super.setQuotaUser(quotaUser);
            }

            public Refunditem setUploadType(String uploadType) {
                return (Refunditem)super.setUploadType(uploadType);
            }

            public Refunditem setUploadProtocol(String uploadProtocol) {
                return (Refunditem)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Refunditem setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Refunditem setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Refunditem set(String parameterName, Object value) {
                return (Refunditem)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<OrdersListResponse> {
            private static final String REST_PATH = "{merchantId}/orders";
            @Key
            private BigInteger merchantId;
            @Key
            private Boolean acknowledged;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private String placedDateEnd;
            @Key
            private String placedDateStart;
            @Key
            private java.util.List<String> statuses;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrdersListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Boolean getAcknowledged() {
                return this.acknowledged;
            }

            public List setAcknowledged(Boolean acknowledged) {
                this.acknowledged = acknowledged;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getPlacedDateEnd() {
                return this.placedDateEnd;
            }

            public List setPlacedDateEnd(String placedDateEnd) {
                this.placedDateEnd = placedDateEnd;
                return this;
            }

            public String getPlacedDateStart() {
                return this.placedDateStart;
            }

            public List setPlacedDateStart(String placedDateStart) {
                this.placedDateStart = placedDateStart;
                return this;
            }

            public java.util.List<String> getStatuses() {
                return this.statuses;
            }

            public List setStatuses(java.util.List<String> statuses) {
                this.statuses = statuses;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Instorerefundlineitem
        extends ShoppingContentRequest<OrdersInStoreRefundLineItemResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/inStoreRefundLineItem";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Instorerefundlineitem(BigInteger merchantId, String orderId, OrdersInStoreRefundLineItemRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersInStoreRefundLineItemResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Instorerefundlineitem set$Xgafv(String $Xgafv) {
                return (Instorerefundlineitem)super.set$Xgafv($Xgafv);
            }

            public Instorerefundlineitem setAccessToken(String accessToken) {
                return (Instorerefundlineitem)super.setAccessToken(accessToken);
            }

            public Instorerefundlineitem setAlt(String alt) {
                return (Instorerefundlineitem)super.setAlt(alt);
            }

            public Instorerefundlineitem setCallback(String callback) {
                return (Instorerefundlineitem)super.setCallback(callback);
            }

            public Instorerefundlineitem setFields(String fields) {
                return (Instorerefundlineitem)super.setFields(fields);
            }

            public Instorerefundlineitem setKey(String key) {
                return (Instorerefundlineitem)super.setKey(key);
            }

            public Instorerefundlineitem setOauthToken(String oauthToken) {
                return (Instorerefundlineitem)super.setOauthToken(oauthToken);
            }

            public Instorerefundlineitem setPrettyPrint(Boolean prettyPrint) {
                return (Instorerefundlineitem)super.setPrettyPrint(prettyPrint);
            }

            public Instorerefundlineitem setQuotaUser(String quotaUser) {
                return (Instorerefundlineitem)super.setQuotaUser(quotaUser);
            }

            public Instorerefundlineitem setUploadType(String uploadType) {
                return (Instorerefundlineitem)super.setUploadType(uploadType);
            }

            public Instorerefundlineitem setUploadProtocol(String uploadProtocol) {
                return (Instorerefundlineitem)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Instorerefundlineitem setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Instorerefundlineitem setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Instorerefundlineitem set(String parameterName, Object value) {
                return (Instorerefundlineitem)super.set(parameterName, value);
            }
        }

        public class Gettestordertemplate
        extends ShoppingContentRequest<OrdersGetTestOrderTemplateResponse> {
            private static final String REST_PATH = "{merchantId}/testordertemplates/{templateName}";
            @Key
            private BigInteger merchantId;
            @Key
            private String templateName;
            @Key
            private String country;

            protected Gettestordertemplate(BigInteger merchantId, String templateName) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrdersGetTestOrderTemplateResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.templateName = (String)Preconditions.checkNotNull((Object)templateName, (Object)"Required parameter templateName must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Gettestordertemplate set$Xgafv(String $Xgafv) {
                return (Gettestordertemplate)super.set$Xgafv($Xgafv);
            }

            public Gettestordertemplate setAccessToken(String accessToken) {
                return (Gettestordertemplate)super.setAccessToken(accessToken);
            }

            public Gettestordertemplate setAlt(String alt) {
                return (Gettestordertemplate)super.setAlt(alt);
            }

            public Gettestordertemplate setCallback(String callback) {
                return (Gettestordertemplate)super.setCallback(callback);
            }

            public Gettestordertemplate setFields(String fields) {
                return (Gettestordertemplate)super.setFields(fields);
            }

            public Gettestordertemplate setKey(String key) {
                return (Gettestordertemplate)super.setKey(key);
            }

            public Gettestordertemplate setOauthToken(String oauthToken) {
                return (Gettestordertemplate)super.setOauthToken(oauthToken);
            }

            public Gettestordertemplate setPrettyPrint(Boolean prettyPrint) {
                return (Gettestordertemplate)super.setPrettyPrint(prettyPrint);
            }

            public Gettestordertemplate setQuotaUser(String quotaUser) {
                return (Gettestordertemplate)super.setQuotaUser(quotaUser);
            }

            public Gettestordertemplate setUploadType(String uploadType) {
                return (Gettestordertemplate)super.setUploadType(uploadType);
            }

            public Gettestordertemplate setUploadProtocol(String uploadProtocol) {
                return (Gettestordertemplate)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Gettestordertemplate setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getTemplateName() {
                return this.templateName;
            }

            public Gettestordertemplate setTemplateName(String templateName) {
                this.templateName = templateName;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Gettestordertemplate setCountry(String country) {
                this.country = country;
                return this;
            }

            @Override
            public Gettestordertemplate set(String parameterName, Object value) {
                return (Gettestordertemplate)super.set(parameterName, value);
            }
        }

        public class Getbymerchantorderid
        extends ShoppingContentRequest<OrdersGetByMerchantOrderIdResponse> {
            private static final String REST_PATH = "{merchantId}/ordersbymerchantid/{merchantOrderId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String merchantOrderId;

            protected Getbymerchantorderid(BigInteger merchantId, String merchantOrderId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrdersGetByMerchantOrderIdResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.merchantOrderId = (String)Preconditions.checkNotNull((Object)merchantOrderId, (Object)"Required parameter merchantOrderId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getbymerchantorderid set$Xgafv(String $Xgafv) {
                return (Getbymerchantorderid)super.set$Xgafv($Xgafv);
            }

            public Getbymerchantorderid setAccessToken(String accessToken) {
                return (Getbymerchantorderid)super.setAccessToken(accessToken);
            }

            public Getbymerchantorderid setAlt(String alt) {
                return (Getbymerchantorderid)super.setAlt(alt);
            }

            public Getbymerchantorderid setCallback(String callback) {
                return (Getbymerchantorderid)super.setCallback(callback);
            }

            public Getbymerchantorderid setFields(String fields) {
                return (Getbymerchantorderid)super.setFields(fields);
            }

            public Getbymerchantorderid setKey(String key) {
                return (Getbymerchantorderid)super.setKey(key);
            }

            public Getbymerchantorderid setOauthToken(String oauthToken) {
                return (Getbymerchantorderid)super.setOauthToken(oauthToken);
            }

            public Getbymerchantorderid setPrettyPrint(Boolean prettyPrint) {
                return (Getbymerchantorderid)super.setPrettyPrint(prettyPrint);
            }

            public Getbymerchantorderid setQuotaUser(String quotaUser) {
                return (Getbymerchantorderid)super.setQuotaUser(quotaUser);
            }

            public Getbymerchantorderid setUploadType(String uploadType) {
                return (Getbymerchantorderid)super.setUploadType(uploadType);
            }

            public Getbymerchantorderid setUploadProtocol(String uploadProtocol) {
                return (Getbymerchantorderid)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getbymerchantorderid setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getMerchantOrderId() {
                return this.merchantOrderId;
            }

            public Getbymerchantorderid setMerchantOrderId(String merchantOrderId) {
                this.merchantOrderId = merchantOrderId;
                return this;
            }

            @Override
            public Getbymerchantorderid set(String parameterName, Object value) {
                return (Getbymerchantorderid)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Order> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Get(BigInteger merchantId, String orderId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Order.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Get setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Createtestreturn
        extends ShoppingContentRequest<OrdersCreateTestReturnResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/testreturn";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Createtestreturn(BigInteger merchantId, String orderId, OrdersCreateTestReturnRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersCreateTestReturnResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Createtestreturn set$Xgafv(String $Xgafv) {
                return (Createtestreturn)super.set$Xgafv($Xgafv);
            }

            public Createtestreturn setAccessToken(String accessToken) {
                return (Createtestreturn)super.setAccessToken(accessToken);
            }

            public Createtestreturn setAlt(String alt) {
                return (Createtestreturn)super.setAlt(alt);
            }

            public Createtestreturn setCallback(String callback) {
                return (Createtestreturn)super.setCallback(callback);
            }

            public Createtestreturn setFields(String fields) {
                return (Createtestreturn)super.setFields(fields);
            }

            public Createtestreturn setKey(String key) {
                return (Createtestreturn)super.setKey(key);
            }

            public Createtestreturn setOauthToken(String oauthToken) {
                return (Createtestreturn)super.setOauthToken(oauthToken);
            }

            public Createtestreturn setPrettyPrint(Boolean prettyPrint) {
                return (Createtestreturn)super.setPrettyPrint(prettyPrint);
            }

            public Createtestreturn setQuotaUser(String quotaUser) {
                return (Createtestreturn)super.setQuotaUser(quotaUser);
            }

            public Createtestreturn setUploadType(String uploadType) {
                return (Createtestreturn)super.setUploadType(uploadType);
            }

            public Createtestreturn setUploadProtocol(String uploadProtocol) {
                return (Createtestreturn)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Createtestreturn setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Createtestreturn setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Createtestreturn set(String parameterName, Object value) {
                return (Createtestreturn)super.set(parameterName, value);
            }
        }

        public class Createtestorder
        extends ShoppingContentRequest<OrdersCreateTestOrderResponse> {
            private static final String REST_PATH = "{merchantId}/testorders";
            @Key
            private BigInteger merchantId;

            protected Createtestorder(BigInteger merchantId, OrdersCreateTestOrderRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersCreateTestOrderResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Createtestorder set$Xgafv(String $Xgafv) {
                return (Createtestorder)super.set$Xgafv($Xgafv);
            }

            public Createtestorder setAccessToken(String accessToken) {
                return (Createtestorder)super.setAccessToken(accessToken);
            }

            public Createtestorder setAlt(String alt) {
                return (Createtestorder)super.setAlt(alt);
            }

            public Createtestorder setCallback(String callback) {
                return (Createtestorder)super.setCallback(callback);
            }

            public Createtestorder setFields(String fields) {
                return (Createtestorder)super.setFields(fields);
            }

            public Createtestorder setKey(String key) {
                return (Createtestorder)super.setKey(key);
            }

            public Createtestorder setOauthToken(String oauthToken) {
                return (Createtestorder)super.setOauthToken(oauthToken);
            }

            public Createtestorder setPrettyPrint(Boolean prettyPrint) {
                return (Createtestorder)super.setPrettyPrint(prettyPrint);
            }

            public Createtestorder setQuotaUser(String quotaUser) {
                return (Createtestorder)super.setQuotaUser(quotaUser);
            }

            public Createtestorder setUploadType(String uploadType) {
                return (Createtestorder)super.setUploadType(uploadType);
            }

            public Createtestorder setUploadProtocol(String uploadProtocol) {
                return (Createtestorder)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Createtestorder setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Createtestorder set(String parameterName, Object value) {
                return (Createtestorder)super.set(parameterName, value);
            }
        }

        public class CaptureOrder
        extends ShoppingContentRequest<CaptureOrderResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/captureOrder";
            @Key
            private Long merchantId;
            @Key
            private String orderId;

            protected CaptureOrder(Long merchantId, String orderId, CaptureOrderRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, CaptureOrderResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public CaptureOrder set$Xgafv(String $Xgafv) {
                return (CaptureOrder)super.set$Xgafv($Xgafv);
            }

            public CaptureOrder setAccessToken(String accessToken) {
                return (CaptureOrder)super.setAccessToken(accessToken);
            }

            public CaptureOrder setAlt(String alt) {
                return (CaptureOrder)super.setAlt(alt);
            }

            public CaptureOrder setCallback(String callback) {
                return (CaptureOrder)super.setCallback(callback);
            }

            public CaptureOrder setFields(String fields) {
                return (CaptureOrder)super.setFields(fields);
            }

            public CaptureOrder setKey(String key) {
                return (CaptureOrder)super.setKey(key);
            }

            public CaptureOrder setOauthToken(String oauthToken) {
                return (CaptureOrder)super.setOauthToken(oauthToken);
            }

            public CaptureOrder setPrettyPrint(Boolean prettyPrint) {
                return (CaptureOrder)super.setPrettyPrint(prettyPrint);
            }

            public CaptureOrder setQuotaUser(String quotaUser) {
                return (CaptureOrder)super.setQuotaUser(quotaUser);
            }

            public CaptureOrder setUploadType(String uploadType) {
                return (CaptureOrder)super.setUploadType(uploadType);
            }

            public CaptureOrder setUploadProtocol(String uploadProtocol) {
                return (CaptureOrder)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public CaptureOrder setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public CaptureOrder setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public CaptureOrder set(String parameterName, Object value) {
                return (CaptureOrder)super.set(parameterName, value);
            }
        }

        public class Canceltestorderbycustomer
        extends ShoppingContentRequest<OrdersCancelTestOrderByCustomerResponse> {
            private static final String REST_PATH = "{merchantId}/testorders/{orderId}/cancelByCustomer";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Canceltestorderbycustomer(BigInteger merchantId, String orderId, OrdersCancelTestOrderByCustomerRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersCancelTestOrderByCustomerResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Canceltestorderbycustomer set$Xgafv(String $Xgafv) {
                return (Canceltestorderbycustomer)super.set$Xgafv($Xgafv);
            }

            public Canceltestorderbycustomer setAccessToken(String accessToken) {
                return (Canceltestorderbycustomer)super.setAccessToken(accessToken);
            }

            public Canceltestorderbycustomer setAlt(String alt) {
                return (Canceltestorderbycustomer)super.setAlt(alt);
            }

            public Canceltestorderbycustomer setCallback(String callback) {
                return (Canceltestorderbycustomer)super.setCallback(callback);
            }

            public Canceltestorderbycustomer setFields(String fields) {
                return (Canceltestorderbycustomer)super.setFields(fields);
            }

            public Canceltestorderbycustomer setKey(String key) {
                return (Canceltestorderbycustomer)super.setKey(key);
            }

            public Canceltestorderbycustomer setOauthToken(String oauthToken) {
                return (Canceltestorderbycustomer)super.setOauthToken(oauthToken);
            }

            public Canceltestorderbycustomer setPrettyPrint(Boolean prettyPrint) {
                return (Canceltestorderbycustomer)super.setPrettyPrint(prettyPrint);
            }

            public Canceltestorderbycustomer setQuotaUser(String quotaUser) {
                return (Canceltestorderbycustomer)super.setQuotaUser(quotaUser);
            }

            public Canceltestorderbycustomer setUploadType(String uploadType) {
                return (Canceltestorderbycustomer)super.setUploadType(uploadType);
            }

            public Canceltestorderbycustomer setUploadProtocol(String uploadProtocol) {
                return (Canceltestorderbycustomer)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Canceltestorderbycustomer setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Canceltestorderbycustomer setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Canceltestorderbycustomer set(String parameterName, Object value) {
                return (Canceltestorderbycustomer)super.set(parameterName, value);
            }
        }

        public class Cancellineitem
        extends ShoppingContentRequest<OrdersCancelLineItemResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/cancelLineItem";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Cancellineitem(BigInteger merchantId, String orderId, OrdersCancelLineItemRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersCancelLineItemResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Cancellineitem set$Xgafv(String $Xgafv) {
                return (Cancellineitem)super.set$Xgafv($Xgafv);
            }

            public Cancellineitem setAccessToken(String accessToken) {
                return (Cancellineitem)super.setAccessToken(accessToken);
            }

            public Cancellineitem setAlt(String alt) {
                return (Cancellineitem)super.setAlt(alt);
            }

            public Cancellineitem setCallback(String callback) {
                return (Cancellineitem)super.setCallback(callback);
            }

            public Cancellineitem setFields(String fields) {
                return (Cancellineitem)super.setFields(fields);
            }

            public Cancellineitem setKey(String key) {
                return (Cancellineitem)super.setKey(key);
            }

            public Cancellineitem setOauthToken(String oauthToken) {
                return (Cancellineitem)super.setOauthToken(oauthToken);
            }

            public Cancellineitem setPrettyPrint(Boolean prettyPrint) {
                return (Cancellineitem)super.setPrettyPrint(prettyPrint);
            }

            public Cancellineitem setQuotaUser(String quotaUser) {
                return (Cancellineitem)super.setQuotaUser(quotaUser);
            }

            public Cancellineitem setUploadType(String uploadType) {
                return (Cancellineitem)super.setUploadType(uploadType);
            }

            public Cancellineitem setUploadProtocol(String uploadProtocol) {
                return (Cancellineitem)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Cancellineitem setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Cancellineitem setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Cancellineitem set(String parameterName, Object value) {
                return (Cancellineitem)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends ShoppingContentRequest<OrdersCancelResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/cancel";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Cancel(BigInteger merchantId, String orderId, OrdersCancelRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersCancelResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Cancel set$Xgafv(String $Xgafv) {
                return (Cancel)super.set$Xgafv($Xgafv);
            }

            public Cancel setAccessToken(String accessToken) {
                return (Cancel)super.setAccessToken(accessToken);
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setCallback(String callback) {
                return (Cancel)super.setCallback(callback);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUploadType(String uploadType) {
                return (Cancel)super.setUploadType(uploadType);
            }

            public Cancel setUploadProtocol(String uploadProtocol) {
                return (Cancel)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Cancel setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Cancel setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }

        public class Advancetestorder
        extends ShoppingContentRequest<OrdersAdvanceTestOrderResponse> {
            private static final String REST_PATH = "{merchantId}/testorders/{orderId}/advance";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Advancetestorder(BigInteger merchantId, String orderId) {
                super(ShoppingContent.this, "POST", REST_PATH, null, OrdersAdvanceTestOrderResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Advancetestorder set$Xgafv(String $Xgafv) {
                return (Advancetestorder)super.set$Xgafv($Xgafv);
            }

            public Advancetestorder setAccessToken(String accessToken) {
                return (Advancetestorder)super.setAccessToken(accessToken);
            }

            public Advancetestorder setAlt(String alt) {
                return (Advancetestorder)super.setAlt(alt);
            }

            public Advancetestorder setCallback(String callback) {
                return (Advancetestorder)super.setCallback(callback);
            }

            public Advancetestorder setFields(String fields) {
                return (Advancetestorder)super.setFields(fields);
            }

            public Advancetestorder setKey(String key) {
                return (Advancetestorder)super.setKey(key);
            }

            public Advancetestorder setOauthToken(String oauthToken) {
                return (Advancetestorder)super.setOauthToken(oauthToken);
            }

            public Advancetestorder setPrettyPrint(Boolean prettyPrint) {
                return (Advancetestorder)super.setPrettyPrint(prettyPrint);
            }

            public Advancetestorder setQuotaUser(String quotaUser) {
                return (Advancetestorder)super.setQuotaUser(quotaUser);
            }

            public Advancetestorder setUploadType(String uploadType) {
                return (Advancetestorder)super.setUploadType(uploadType);
            }

            public Advancetestorder setUploadProtocol(String uploadProtocol) {
                return (Advancetestorder)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Advancetestorder setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Advancetestorder setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Advancetestorder set(String parameterName, Object value) {
                return (Advancetestorder)super.set(parameterName, value);
            }
        }

        public class Acknowledge
        extends ShoppingContentRequest<OrdersAcknowledgeResponse> {
            private static final String REST_PATH = "{merchantId}/orders/{orderId}/acknowledge";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Acknowledge(BigInteger merchantId, String orderId, OrdersAcknowledgeRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrdersAcknowledgeResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Acknowledge set$Xgafv(String $Xgafv) {
                return (Acknowledge)super.set$Xgafv($Xgafv);
            }

            public Acknowledge setAccessToken(String accessToken) {
                return (Acknowledge)super.setAccessToken(accessToken);
            }

            public Acknowledge setAlt(String alt) {
                return (Acknowledge)super.setAlt(alt);
            }

            public Acknowledge setCallback(String callback) {
                return (Acknowledge)super.setCallback(callback);
            }

            public Acknowledge setFields(String fields) {
                return (Acknowledge)super.setFields(fields);
            }

            public Acknowledge setKey(String key) {
                return (Acknowledge)super.setKey(key);
            }

            public Acknowledge setOauthToken(String oauthToken) {
                return (Acknowledge)super.setOauthToken(oauthToken);
            }

            public Acknowledge setPrettyPrint(Boolean prettyPrint) {
                return (Acknowledge)super.setPrettyPrint(prettyPrint);
            }

            public Acknowledge setQuotaUser(String quotaUser) {
                return (Acknowledge)super.setQuotaUser(quotaUser);
            }

            public Acknowledge setUploadType(String uploadType) {
                return (Acknowledge)super.setUploadType(uploadType);
            }

            public Acknowledge setUploadProtocol(String uploadProtocol) {
                return (Acknowledge)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Acknowledge setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Acknowledge setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Acknowledge set(String parameterName, Object value) {
                return (Acknowledge)super.set(parameterName, value);
            }
        }
    }

    public class Orderreturns {
        public Acknowledge acknowledge(BigInteger merchantId, String returnId, OrderreturnsAcknowledgeRequest content) throws IOException {
            Acknowledge result = new Acknowledge(merchantId, returnId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Createorderreturn createorderreturn(BigInteger merchantId, OrderreturnsCreateOrderReturnRequest content) throws IOException {
            Createorderreturn result = new Createorderreturn(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, String returnId) throws IOException {
            Get result = new Get(merchantId, returnId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Process process(BigInteger merchantId, String returnId, OrderreturnsProcessRequest content) throws IOException {
            Process result = new Process(merchantId, returnId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Labels labels() {
            return new Labels();
        }

        public class Labels {
            public Create create(Long merchantId, String returnId, ReturnShippingLabel content) throws IOException {
                Create result = new Create(merchantId, returnId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Create
            extends ShoppingContentRequest<ReturnShippingLabel> {
                private static final String REST_PATH = "{merchantId}/orderreturns/{returnId}/labels";
                @Key
                private Long merchantId;
                @Key
                private String returnId;

                protected Create(Long merchantId, String returnId, ReturnShippingLabel content) {
                    super(ShoppingContent.this, "POST", REST_PATH, (Object)content, ReturnShippingLabel.class);
                    this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                    this.returnId = (String)Preconditions.checkNotNull((Object)returnId, (Object)"Required parameter returnId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getMerchantId() {
                    return this.merchantId;
                }

                public Create setMerchantId(Long merchantId) {
                    this.merchantId = merchantId;
                    return this;
                }

                public String getReturnId() {
                    return this.returnId;
                }

                public Create setReturnId(String returnId) {
                    this.returnId = returnId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Process
        extends ShoppingContentRequest<OrderreturnsProcessResponse> {
            private static final String REST_PATH = "{merchantId}/orderreturns/{returnId}/process";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnId;

            protected Process(BigInteger merchantId, String returnId, OrderreturnsProcessRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrderreturnsProcessResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnId = (String)Preconditions.checkNotNull((Object)returnId, (Object)"Required parameter returnId must be specified.");
            }

            public Process set$Xgafv(String $Xgafv) {
                return (Process)super.set$Xgafv($Xgafv);
            }

            public Process setAccessToken(String accessToken) {
                return (Process)super.setAccessToken(accessToken);
            }

            public Process setAlt(String alt) {
                return (Process)super.setAlt(alt);
            }

            public Process setCallback(String callback) {
                return (Process)super.setCallback(callback);
            }

            public Process setFields(String fields) {
                return (Process)super.setFields(fields);
            }

            public Process setKey(String key) {
                return (Process)super.setKey(key);
            }

            public Process setOauthToken(String oauthToken) {
                return (Process)super.setOauthToken(oauthToken);
            }

            public Process setPrettyPrint(Boolean prettyPrint) {
                return (Process)super.setPrettyPrint(prettyPrint);
            }

            public Process setQuotaUser(String quotaUser) {
                return (Process)super.setQuotaUser(quotaUser);
            }

            public Process setUploadType(String uploadType) {
                return (Process)super.setUploadType(uploadType);
            }

            public Process setUploadProtocol(String uploadProtocol) {
                return (Process)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Process setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnId() {
                return this.returnId;
            }

            public Process setReturnId(String returnId) {
                this.returnId = returnId;
                return this;
            }

            @Override
            public Process set(String parameterName, Object value) {
                return (Process)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<OrderreturnsListResponse> {
            private static final String REST_PATH = "{merchantId}/orderreturns";
            @Key
            private BigInteger merchantId;
            @Key
            private Boolean acknowledged;
            @Key
            private String createdEndDate;
            @Key
            private String createdStartDate;
            @Key
            private java.util.List<String> googleOrderIds;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private java.util.List<String> shipmentStates;
            @Key
            private java.util.List<String> shipmentStatus;
            @Key
            private java.util.List<String> shipmentTrackingNumbers;
            @Key
            private java.util.List<String> shipmentTypes;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrderreturnsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Boolean getAcknowledged() {
                return this.acknowledged;
            }

            public List setAcknowledged(Boolean acknowledged) {
                this.acknowledged = acknowledged;
                return this;
            }

            public String getCreatedEndDate() {
                return this.createdEndDate;
            }

            public List setCreatedEndDate(String createdEndDate) {
                this.createdEndDate = createdEndDate;
                return this;
            }

            public String getCreatedStartDate() {
                return this.createdStartDate;
            }

            public List setCreatedStartDate(String createdStartDate) {
                this.createdStartDate = createdStartDate;
                return this;
            }

            public java.util.List<String> getGoogleOrderIds() {
                return this.googleOrderIds;
            }

            public List setGoogleOrderIds(java.util.List<String> googleOrderIds) {
                this.googleOrderIds = googleOrderIds;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public java.util.List<String> getShipmentStates() {
                return this.shipmentStates;
            }

            public List setShipmentStates(java.util.List<String> shipmentStates) {
                this.shipmentStates = shipmentStates;
                return this;
            }

            public java.util.List<String> getShipmentStatus() {
                return this.shipmentStatus;
            }

            public List setShipmentStatus(java.util.List<String> shipmentStatus) {
                this.shipmentStatus = shipmentStatus;
                return this;
            }

            public java.util.List<String> getShipmentTrackingNumbers() {
                return this.shipmentTrackingNumbers;
            }

            public List setShipmentTrackingNumbers(java.util.List<String> shipmentTrackingNumbers) {
                this.shipmentTrackingNumbers = shipmentTrackingNumbers;
                return this;
            }

            public java.util.List<String> getShipmentTypes() {
                return this.shipmentTypes;
            }

            public List setShipmentTypes(java.util.List<String> shipmentTypes) {
                this.shipmentTypes = shipmentTypes;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<MerchantOrderReturn> {
            private static final String REST_PATH = "{merchantId}/orderreturns/{returnId}";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnId;

            protected Get(BigInteger merchantId, String returnId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, MerchantOrderReturn.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnId = (String)Preconditions.checkNotNull((Object)returnId, (Object)"Required parameter returnId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnId() {
                return this.returnId;
            }

            public Get setReturnId(String returnId) {
                this.returnId = returnId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Createorderreturn
        extends ShoppingContentRequest<OrderreturnsCreateOrderReturnResponse> {
            private static final String REST_PATH = "{merchantId}/orderreturns/createOrderReturn";
            @Key
            private BigInteger merchantId;

            protected Createorderreturn(BigInteger merchantId, OrderreturnsCreateOrderReturnRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrderreturnsCreateOrderReturnResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Createorderreturn set$Xgafv(String $Xgafv) {
                return (Createorderreturn)super.set$Xgafv($Xgafv);
            }

            public Createorderreturn setAccessToken(String accessToken) {
                return (Createorderreturn)super.setAccessToken(accessToken);
            }

            public Createorderreturn setAlt(String alt) {
                return (Createorderreturn)super.setAlt(alt);
            }

            public Createorderreturn setCallback(String callback) {
                return (Createorderreturn)super.setCallback(callback);
            }

            public Createorderreturn setFields(String fields) {
                return (Createorderreturn)super.setFields(fields);
            }

            public Createorderreturn setKey(String key) {
                return (Createorderreturn)super.setKey(key);
            }

            public Createorderreturn setOauthToken(String oauthToken) {
                return (Createorderreturn)super.setOauthToken(oauthToken);
            }

            public Createorderreturn setPrettyPrint(Boolean prettyPrint) {
                return (Createorderreturn)super.setPrettyPrint(prettyPrint);
            }

            public Createorderreturn setQuotaUser(String quotaUser) {
                return (Createorderreturn)super.setQuotaUser(quotaUser);
            }

            public Createorderreturn setUploadType(String uploadType) {
                return (Createorderreturn)super.setUploadType(uploadType);
            }

            public Createorderreturn setUploadProtocol(String uploadProtocol) {
                return (Createorderreturn)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Createorderreturn setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Createorderreturn set(String parameterName, Object value) {
                return (Createorderreturn)super.set(parameterName, value);
            }
        }

        public class Acknowledge
        extends ShoppingContentRequest<OrderreturnsAcknowledgeResponse> {
            private static final String REST_PATH = "{merchantId}/orderreturns/{returnId}/acknowledge";
            @Key
            private BigInteger merchantId;
            @Key
            private String returnId;

            protected Acknowledge(BigInteger merchantId, String returnId, OrderreturnsAcknowledgeRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrderreturnsAcknowledgeResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.returnId = (String)Preconditions.checkNotNull((Object)returnId, (Object)"Required parameter returnId must be specified.");
            }

            public Acknowledge set$Xgafv(String $Xgafv) {
                return (Acknowledge)super.set$Xgafv($Xgafv);
            }

            public Acknowledge setAccessToken(String accessToken) {
                return (Acknowledge)super.setAccessToken(accessToken);
            }

            public Acknowledge setAlt(String alt) {
                return (Acknowledge)super.setAlt(alt);
            }

            public Acknowledge setCallback(String callback) {
                return (Acknowledge)super.setCallback(callback);
            }

            public Acknowledge setFields(String fields) {
                return (Acknowledge)super.setFields(fields);
            }

            public Acknowledge setKey(String key) {
                return (Acknowledge)super.setKey(key);
            }

            public Acknowledge setOauthToken(String oauthToken) {
                return (Acknowledge)super.setOauthToken(oauthToken);
            }

            public Acknowledge setPrettyPrint(Boolean prettyPrint) {
                return (Acknowledge)super.setPrettyPrint(prettyPrint);
            }

            public Acknowledge setQuotaUser(String quotaUser) {
                return (Acknowledge)super.setQuotaUser(quotaUser);
            }

            public Acknowledge setUploadType(String uploadType) {
                return (Acknowledge)super.setUploadType(uploadType);
            }

            public Acknowledge setUploadProtocol(String uploadProtocol) {
                return (Acknowledge)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Acknowledge setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getReturnId() {
                return this.returnId;
            }

            public Acknowledge setReturnId(String returnId) {
                this.returnId = returnId;
                return this;
            }

            @Override
            public Acknowledge set(String parameterName, Object value) {
                return (Acknowledge)super.set(parameterName, value);
            }
        }
    }

    public class Orderreports {
        public Listdisbursements listdisbursements(BigInteger merchantId) throws IOException {
            Listdisbursements result = new Listdisbursements(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Listtransactions listtransactions(BigInteger merchantId, String disbursementId) throws IOException {
            Listtransactions result = new Listtransactions(merchantId, disbursementId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Listtransactions
        extends ShoppingContentRequest<OrderreportsListTransactionsResponse> {
            private static final String REST_PATH = "{merchantId}/orderreports/disbursements/{disbursementId}/transactions";
            @Key
            private BigInteger merchantId;
            @Key
            private String disbursementId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String transactionEndDate;
            @Key
            private String transactionStartDate;

            protected Listtransactions(BigInteger merchantId, String disbursementId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrderreportsListTransactionsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.disbursementId = (String)Preconditions.checkNotNull((Object)disbursementId, (Object)"Required parameter disbursementId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Listtransactions set$Xgafv(String $Xgafv) {
                return (Listtransactions)super.set$Xgafv($Xgafv);
            }

            public Listtransactions setAccessToken(String accessToken) {
                return (Listtransactions)super.setAccessToken(accessToken);
            }

            public Listtransactions setAlt(String alt) {
                return (Listtransactions)super.setAlt(alt);
            }

            public Listtransactions setCallback(String callback) {
                return (Listtransactions)super.setCallback(callback);
            }

            public Listtransactions setFields(String fields) {
                return (Listtransactions)super.setFields(fields);
            }

            public Listtransactions setKey(String key) {
                return (Listtransactions)super.setKey(key);
            }

            public Listtransactions setOauthToken(String oauthToken) {
                return (Listtransactions)super.setOauthToken(oauthToken);
            }

            public Listtransactions setPrettyPrint(Boolean prettyPrint) {
                return (Listtransactions)super.setPrettyPrint(prettyPrint);
            }

            public Listtransactions setQuotaUser(String quotaUser) {
                return (Listtransactions)super.setQuotaUser(quotaUser);
            }

            public Listtransactions setUploadType(String uploadType) {
                return (Listtransactions)super.setUploadType(uploadType);
            }

            public Listtransactions setUploadProtocol(String uploadProtocol) {
                return (Listtransactions)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Listtransactions setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getDisbursementId() {
                return this.disbursementId;
            }

            public Listtransactions setDisbursementId(String disbursementId) {
                this.disbursementId = disbursementId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Listtransactions setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Listtransactions setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getTransactionEndDate() {
                return this.transactionEndDate;
            }

            public Listtransactions setTransactionEndDate(String transactionEndDate) {
                this.transactionEndDate = transactionEndDate;
                return this;
            }

            public String getTransactionStartDate() {
                return this.transactionStartDate;
            }

            public Listtransactions setTransactionStartDate(String transactionStartDate) {
                this.transactionStartDate = transactionStartDate;
                return this;
            }

            @Override
            public Listtransactions set(String parameterName, Object value) {
                return (Listtransactions)super.set(parameterName, value);
            }
        }

        public class Listdisbursements
        extends ShoppingContentRequest<OrderreportsListDisbursementsResponse> {
            private static final String REST_PATH = "{merchantId}/orderreports/disbursements";
            @Key
            private BigInteger merchantId;
            @Key
            private String disbursementEndDate;
            @Key
            private String disbursementStartDate;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected Listdisbursements(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, OrderreportsListDisbursementsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Listdisbursements set$Xgafv(String $Xgafv) {
                return (Listdisbursements)super.set$Xgafv($Xgafv);
            }

            public Listdisbursements setAccessToken(String accessToken) {
                return (Listdisbursements)super.setAccessToken(accessToken);
            }

            public Listdisbursements setAlt(String alt) {
                return (Listdisbursements)super.setAlt(alt);
            }

            public Listdisbursements setCallback(String callback) {
                return (Listdisbursements)super.setCallback(callback);
            }

            public Listdisbursements setFields(String fields) {
                return (Listdisbursements)super.setFields(fields);
            }

            public Listdisbursements setKey(String key) {
                return (Listdisbursements)super.setKey(key);
            }

            public Listdisbursements setOauthToken(String oauthToken) {
                return (Listdisbursements)super.setOauthToken(oauthToken);
            }

            public Listdisbursements setPrettyPrint(Boolean prettyPrint) {
                return (Listdisbursements)super.setPrettyPrint(prettyPrint);
            }

            public Listdisbursements setQuotaUser(String quotaUser) {
                return (Listdisbursements)super.setQuotaUser(quotaUser);
            }

            public Listdisbursements setUploadType(String uploadType) {
                return (Listdisbursements)super.setUploadType(uploadType);
            }

            public Listdisbursements setUploadProtocol(String uploadProtocol) {
                return (Listdisbursements)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Listdisbursements setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getDisbursementEndDate() {
                return this.disbursementEndDate;
            }

            public Listdisbursements setDisbursementEndDate(String disbursementEndDate) {
                this.disbursementEndDate = disbursementEndDate;
                return this;
            }

            public String getDisbursementStartDate() {
                return this.disbursementStartDate;
            }

            public Listdisbursements setDisbursementStartDate(String disbursementStartDate) {
                this.disbursementStartDate = disbursementStartDate;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Listdisbursements setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Listdisbursements setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public Listdisbursements set(String parameterName, Object value) {
                return (Listdisbursements)super.set(parameterName, value);
            }
        }
    }

    public class Orderinvoices {
        public Createchargeinvoice createchargeinvoice(BigInteger merchantId, String orderId, OrderinvoicesCreateChargeInvoiceRequest content) throws IOException {
            Createchargeinvoice result = new Createchargeinvoice(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Createrefundinvoice createrefundinvoice(BigInteger merchantId, String orderId, OrderinvoicesCreateRefundInvoiceRequest content) throws IOException {
            Createrefundinvoice result = new Createrefundinvoice(merchantId, orderId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Createrefundinvoice
        extends ShoppingContentRequest<OrderinvoicesCreateRefundInvoiceResponse> {
            private static final String REST_PATH = "{merchantId}/orderinvoices/{orderId}/createRefundInvoice";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Createrefundinvoice(BigInteger merchantId, String orderId, OrderinvoicesCreateRefundInvoiceRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrderinvoicesCreateRefundInvoiceResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Createrefundinvoice set$Xgafv(String $Xgafv) {
                return (Createrefundinvoice)super.set$Xgafv($Xgafv);
            }

            public Createrefundinvoice setAccessToken(String accessToken) {
                return (Createrefundinvoice)super.setAccessToken(accessToken);
            }

            public Createrefundinvoice setAlt(String alt) {
                return (Createrefundinvoice)super.setAlt(alt);
            }

            public Createrefundinvoice setCallback(String callback) {
                return (Createrefundinvoice)super.setCallback(callback);
            }

            public Createrefundinvoice setFields(String fields) {
                return (Createrefundinvoice)super.setFields(fields);
            }

            public Createrefundinvoice setKey(String key) {
                return (Createrefundinvoice)super.setKey(key);
            }

            public Createrefundinvoice setOauthToken(String oauthToken) {
                return (Createrefundinvoice)super.setOauthToken(oauthToken);
            }

            public Createrefundinvoice setPrettyPrint(Boolean prettyPrint) {
                return (Createrefundinvoice)super.setPrettyPrint(prettyPrint);
            }

            public Createrefundinvoice setQuotaUser(String quotaUser) {
                return (Createrefundinvoice)super.setQuotaUser(quotaUser);
            }

            public Createrefundinvoice setUploadType(String uploadType) {
                return (Createrefundinvoice)super.setUploadType(uploadType);
            }

            public Createrefundinvoice setUploadProtocol(String uploadProtocol) {
                return (Createrefundinvoice)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Createrefundinvoice setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Createrefundinvoice setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Createrefundinvoice set(String parameterName, Object value) {
                return (Createrefundinvoice)super.set(parameterName, value);
            }
        }

        public class Createchargeinvoice
        extends ShoppingContentRequest<OrderinvoicesCreateChargeInvoiceResponse> {
            private static final String REST_PATH = "{merchantId}/orderinvoices/{orderId}/createChargeInvoice";
            @Key
            private BigInteger merchantId;
            @Key
            private String orderId;

            protected Createchargeinvoice(BigInteger merchantId, String orderId, OrderinvoicesCreateChargeInvoiceRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, OrderinvoicesCreateChargeInvoiceResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.orderId = (String)Preconditions.checkNotNull((Object)orderId, (Object)"Required parameter orderId must be specified.");
            }

            public Createchargeinvoice set$Xgafv(String $Xgafv) {
                return (Createchargeinvoice)super.set$Xgafv($Xgafv);
            }

            public Createchargeinvoice setAccessToken(String accessToken) {
                return (Createchargeinvoice)super.setAccessToken(accessToken);
            }

            public Createchargeinvoice setAlt(String alt) {
                return (Createchargeinvoice)super.setAlt(alt);
            }

            public Createchargeinvoice setCallback(String callback) {
                return (Createchargeinvoice)super.setCallback(callback);
            }

            public Createchargeinvoice setFields(String fields) {
                return (Createchargeinvoice)super.setFields(fields);
            }

            public Createchargeinvoice setKey(String key) {
                return (Createchargeinvoice)super.setKey(key);
            }

            public Createchargeinvoice setOauthToken(String oauthToken) {
                return (Createchargeinvoice)super.setOauthToken(oauthToken);
            }

            public Createchargeinvoice setPrettyPrint(Boolean prettyPrint) {
                return (Createchargeinvoice)super.setPrettyPrint(prettyPrint);
            }

            public Createchargeinvoice setQuotaUser(String quotaUser) {
                return (Createchargeinvoice)super.setQuotaUser(quotaUser);
            }

            public Createchargeinvoice setUploadType(String uploadType) {
                return (Createchargeinvoice)super.setUploadType(uploadType);
            }

            public Createchargeinvoice setUploadProtocol(String uploadProtocol) {
                return (Createchargeinvoice)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Createchargeinvoice setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getOrderId() {
                return this.orderId;
            }

            public Createchargeinvoice setOrderId(String orderId) {
                this.orderId = orderId;
                return this;
            }

            @Override
            public Createchargeinvoice set(String parameterName, Object value) {
                return (Createchargeinvoice)super.set(parameterName, value);
            }
        }
    }

    public class Localinventory {
        public Custombatch custombatch(LocalinventoryCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, String productId, LocalInventory content) throws IOException {
            Insert result = new Insert(merchantId, productId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Insert
        extends ShoppingContentRequest<LocalInventory> {
            private static final String REST_PATH = "{merchantId}/products/{productId}/localinventory";
            @Key
            private BigInteger merchantId;
            @Key
            private String productId;

            protected Insert(BigInteger merchantId, String productId, LocalInventory content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, LocalInventory.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.productId = (String)Preconditions.checkNotNull((Object)productId, (Object)"Required parameter productId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getProductId() {
                return this.productId;
            }

            public Insert setProductId(String productId) {
                this.productId = productId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<LocalinventoryCustomBatchResponse> {
            private static final String REST_PATH = "localinventory/batch";

            protected Custombatch(LocalinventoryCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, LocalinventoryCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Liasettings {
        public Custombatch custombatch(LiasettingsCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger accountId) throws IOException {
            Get result = new Get(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Getaccessiblegmbaccounts getaccessiblegmbaccounts(BigInteger merchantId, BigInteger accountId) throws IOException {
            Getaccessiblegmbaccounts result = new Getaccessiblegmbaccounts(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Listposdataproviders listposdataproviders() throws IOException {
            Listposdataproviders result = new Listposdataproviders();
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestgmbaccess requestgmbaccess(BigInteger merchantId, BigInteger accountId, String gmbEmail) throws IOException {
            Requestgmbaccess result = new Requestgmbaccess(merchantId, accountId, gmbEmail);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestinventoryverification requestinventoryverification(BigInteger merchantId, BigInteger accountId, String country) throws IOException {
            Requestinventoryverification result = new Requestinventoryverification(merchantId, accountId, country);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Setinventoryverificationcontact setinventoryverificationcontact(BigInteger merchantId, BigInteger accountId, String country, String language, String contactName, String contactEmail) throws IOException {
            Setinventoryverificationcontact result = new Setinventoryverificationcontact(merchantId, accountId, country, language, contactName, contactEmail);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Setposdataprovider setposdataprovider(BigInteger merchantId, BigInteger accountId, String country) throws IOException {
            Setposdataprovider result = new Setposdataprovider(merchantId, accountId, country);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, BigInteger accountId, LiaSettings content) throws IOException {
            Update result = new Update(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<LiaSettings> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Update(BigInteger merchantId, BigInteger accountId, LiaSettings content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, LiaSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Setposdataprovider
        extends ShoppingContentRequest<LiasettingsSetPosDataProviderResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/setposdataprovider";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String country;
            @Key
            private BigInteger posDataProviderId;
            @Key
            private String posExternalAccountId;

            protected Setposdataprovider(BigInteger merchantId, BigInteger accountId, String country) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsSetPosDataProviderResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                this.country = (String)Preconditions.checkNotNull((Object)country, (Object)"Required parameter country must be specified.");
            }

            public Setposdataprovider set$Xgafv(String $Xgafv) {
                return (Setposdataprovider)super.set$Xgafv($Xgafv);
            }

            public Setposdataprovider setAccessToken(String accessToken) {
                return (Setposdataprovider)super.setAccessToken(accessToken);
            }

            public Setposdataprovider setAlt(String alt) {
                return (Setposdataprovider)super.setAlt(alt);
            }

            public Setposdataprovider setCallback(String callback) {
                return (Setposdataprovider)super.setCallback(callback);
            }

            public Setposdataprovider setFields(String fields) {
                return (Setposdataprovider)super.setFields(fields);
            }

            public Setposdataprovider setKey(String key) {
                return (Setposdataprovider)super.setKey(key);
            }

            public Setposdataprovider setOauthToken(String oauthToken) {
                return (Setposdataprovider)super.setOauthToken(oauthToken);
            }

            public Setposdataprovider setPrettyPrint(Boolean prettyPrint) {
                return (Setposdataprovider)super.setPrettyPrint(prettyPrint);
            }

            public Setposdataprovider setQuotaUser(String quotaUser) {
                return (Setposdataprovider)super.setQuotaUser(quotaUser);
            }

            public Setposdataprovider setUploadType(String uploadType) {
                return (Setposdataprovider)super.setUploadType(uploadType);
            }

            public Setposdataprovider setUploadProtocol(String uploadProtocol) {
                return (Setposdataprovider)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Setposdataprovider setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Setposdataprovider setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Setposdataprovider setCountry(String country) {
                this.country = country;
                return this;
            }

            public BigInteger getPosDataProviderId() {
                return this.posDataProviderId;
            }

            public Setposdataprovider setPosDataProviderId(BigInteger posDataProviderId) {
                this.posDataProviderId = posDataProviderId;
                return this;
            }

            public String getPosExternalAccountId() {
                return this.posExternalAccountId;
            }

            public Setposdataprovider setPosExternalAccountId(String posExternalAccountId) {
                this.posExternalAccountId = posExternalAccountId;
                return this;
            }

            @Override
            public Setposdataprovider set(String parameterName, Object value) {
                return (Setposdataprovider)super.set(parameterName, value);
            }
        }

        public class Setinventoryverificationcontact
        extends ShoppingContentRequest<LiasettingsSetInventoryVerificationContactResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/setinventoryverificationcontact";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String country;
            @Key
            private String language;
            @Key
            private String contactName;
            @Key
            private String contactEmail;

            protected Setinventoryverificationcontact(BigInteger merchantId, BigInteger accountId, String country, String language, String contactName, String contactEmail) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsSetInventoryVerificationContactResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                this.country = (String)Preconditions.checkNotNull((Object)country, (Object)"Required parameter country must be specified.");
                this.language = (String)Preconditions.checkNotNull((Object)language, (Object)"Required parameter language must be specified.");
                this.contactName = (String)Preconditions.checkNotNull((Object)contactName, (Object)"Required parameter contactName must be specified.");
                this.contactEmail = (String)Preconditions.checkNotNull((Object)contactEmail, (Object)"Required parameter contactEmail must be specified.");
            }

            public Setinventoryverificationcontact set$Xgafv(String $Xgafv) {
                return (Setinventoryverificationcontact)super.set$Xgafv($Xgafv);
            }

            public Setinventoryverificationcontact setAccessToken(String accessToken) {
                return (Setinventoryverificationcontact)super.setAccessToken(accessToken);
            }

            public Setinventoryverificationcontact setAlt(String alt) {
                return (Setinventoryverificationcontact)super.setAlt(alt);
            }

            public Setinventoryverificationcontact setCallback(String callback) {
                return (Setinventoryverificationcontact)super.setCallback(callback);
            }

            public Setinventoryverificationcontact setFields(String fields) {
                return (Setinventoryverificationcontact)super.setFields(fields);
            }

            public Setinventoryverificationcontact setKey(String key) {
                return (Setinventoryverificationcontact)super.setKey(key);
            }

            public Setinventoryverificationcontact setOauthToken(String oauthToken) {
                return (Setinventoryverificationcontact)super.setOauthToken(oauthToken);
            }

            public Setinventoryverificationcontact setPrettyPrint(Boolean prettyPrint) {
                return (Setinventoryverificationcontact)super.setPrettyPrint(prettyPrint);
            }

            public Setinventoryverificationcontact setQuotaUser(String quotaUser) {
                return (Setinventoryverificationcontact)super.setQuotaUser(quotaUser);
            }

            public Setinventoryverificationcontact setUploadType(String uploadType) {
                return (Setinventoryverificationcontact)super.setUploadType(uploadType);
            }

            public Setinventoryverificationcontact setUploadProtocol(String uploadProtocol) {
                return (Setinventoryverificationcontact)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Setinventoryverificationcontact setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Setinventoryverificationcontact setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Setinventoryverificationcontact setCountry(String country) {
                this.country = country;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Setinventoryverificationcontact setLanguage(String language) {
                this.language = language;
                return this;
            }

            public String getContactName() {
                return this.contactName;
            }

            public Setinventoryverificationcontact setContactName(String contactName) {
                this.contactName = contactName;
                return this;
            }

            public String getContactEmail() {
                return this.contactEmail;
            }

            public Setinventoryverificationcontact setContactEmail(String contactEmail) {
                this.contactEmail = contactEmail;
                return this;
            }

            @Override
            public Setinventoryverificationcontact set(String parameterName, Object value) {
                return (Setinventoryverificationcontact)super.set(parameterName, value);
            }
        }

        public class Requestinventoryverification
        extends ShoppingContentRequest<LiasettingsRequestInventoryVerificationResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/requestinventoryverification/{country}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String country;

            protected Requestinventoryverification(BigInteger merchantId, BigInteger accountId, String country) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsRequestInventoryVerificationResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                this.country = (String)Preconditions.checkNotNull((Object)country, (Object)"Required parameter country must be specified.");
            }

            public Requestinventoryverification set$Xgafv(String $Xgafv) {
                return (Requestinventoryverification)super.set$Xgafv($Xgafv);
            }

            public Requestinventoryverification setAccessToken(String accessToken) {
                return (Requestinventoryverification)super.setAccessToken(accessToken);
            }

            public Requestinventoryverification setAlt(String alt) {
                return (Requestinventoryverification)super.setAlt(alt);
            }

            public Requestinventoryverification setCallback(String callback) {
                return (Requestinventoryverification)super.setCallback(callback);
            }

            public Requestinventoryverification setFields(String fields) {
                return (Requestinventoryverification)super.setFields(fields);
            }

            public Requestinventoryverification setKey(String key) {
                return (Requestinventoryverification)super.setKey(key);
            }

            public Requestinventoryverification setOauthToken(String oauthToken) {
                return (Requestinventoryverification)super.setOauthToken(oauthToken);
            }

            public Requestinventoryverification setPrettyPrint(Boolean prettyPrint) {
                return (Requestinventoryverification)super.setPrettyPrint(prettyPrint);
            }

            public Requestinventoryverification setQuotaUser(String quotaUser) {
                return (Requestinventoryverification)super.setQuotaUser(quotaUser);
            }

            public Requestinventoryverification setUploadType(String uploadType) {
                return (Requestinventoryverification)super.setUploadType(uploadType);
            }

            public Requestinventoryverification setUploadProtocol(String uploadProtocol) {
                return (Requestinventoryverification)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Requestinventoryverification setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Requestinventoryverification setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Requestinventoryverification setCountry(String country) {
                this.country = country;
                return this;
            }

            @Override
            public Requestinventoryverification set(String parameterName, Object value) {
                return (Requestinventoryverification)super.set(parameterName, value);
            }
        }

        public class Requestgmbaccess
        extends ShoppingContentRequest<LiasettingsRequestGmbAccessResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/requestgmbaccess";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String gmbEmail;

            protected Requestgmbaccess(BigInteger merchantId, BigInteger accountId, String gmbEmail) {
                super(ShoppingContent.this, "POST", REST_PATH, null, LiasettingsRequestGmbAccessResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                this.gmbEmail = (String)Preconditions.checkNotNull((Object)gmbEmail, (Object)"Required parameter gmbEmail must be specified.");
            }

            public Requestgmbaccess set$Xgafv(String $Xgafv) {
                return (Requestgmbaccess)super.set$Xgafv($Xgafv);
            }

            public Requestgmbaccess setAccessToken(String accessToken) {
                return (Requestgmbaccess)super.setAccessToken(accessToken);
            }

            public Requestgmbaccess setAlt(String alt) {
                return (Requestgmbaccess)super.setAlt(alt);
            }

            public Requestgmbaccess setCallback(String callback) {
                return (Requestgmbaccess)super.setCallback(callback);
            }

            public Requestgmbaccess setFields(String fields) {
                return (Requestgmbaccess)super.setFields(fields);
            }

            public Requestgmbaccess setKey(String key) {
                return (Requestgmbaccess)super.setKey(key);
            }

            public Requestgmbaccess setOauthToken(String oauthToken) {
                return (Requestgmbaccess)super.setOauthToken(oauthToken);
            }

            public Requestgmbaccess setPrettyPrint(Boolean prettyPrint) {
                return (Requestgmbaccess)super.setPrettyPrint(prettyPrint);
            }

            public Requestgmbaccess setQuotaUser(String quotaUser) {
                return (Requestgmbaccess)super.setQuotaUser(quotaUser);
            }

            public Requestgmbaccess setUploadType(String uploadType) {
                return (Requestgmbaccess)super.setUploadType(uploadType);
            }

            public Requestgmbaccess setUploadProtocol(String uploadProtocol) {
                return (Requestgmbaccess)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Requestgmbaccess setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Requestgmbaccess setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getGmbEmail() {
                return this.gmbEmail;
            }

            public Requestgmbaccess setGmbEmail(String gmbEmail) {
                this.gmbEmail = gmbEmail;
                return this;
            }

            @Override
            public Requestgmbaccess set(String parameterName, Object value) {
                return (Requestgmbaccess)super.set(parameterName, value);
            }
        }

        public class Listposdataproviders
        extends ShoppingContentRequest<LiasettingsListPosDataProvidersResponse> {
            private static final String REST_PATH = "liasettings/posdataproviders";

            protected Listposdataproviders() {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiasettingsListPosDataProvidersResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Listposdataproviders set$Xgafv(String $Xgafv) {
                return (Listposdataproviders)super.set$Xgafv($Xgafv);
            }

            public Listposdataproviders setAccessToken(String accessToken) {
                return (Listposdataproviders)super.setAccessToken(accessToken);
            }

            public Listposdataproviders setAlt(String alt) {
                return (Listposdataproviders)super.setAlt(alt);
            }

            public Listposdataproviders setCallback(String callback) {
                return (Listposdataproviders)super.setCallback(callback);
            }

            public Listposdataproviders setFields(String fields) {
                return (Listposdataproviders)super.setFields(fields);
            }

            public Listposdataproviders setKey(String key) {
                return (Listposdataproviders)super.setKey(key);
            }

            public Listposdataproviders setOauthToken(String oauthToken) {
                return (Listposdataproviders)super.setOauthToken(oauthToken);
            }

            public Listposdataproviders setPrettyPrint(Boolean prettyPrint) {
                return (Listposdataproviders)super.setPrettyPrint(prettyPrint);
            }

            public Listposdataproviders setQuotaUser(String quotaUser) {
                return (Listposdataproviders)super.setQuotaUser(quotaUser);
            }

            public Listposdataproviders setUploadType(String uploadType) {
                return (Listposdataproviders)super.setUploadType(uploadType);
            }

            public Listposdataproviders setUploadProtocol(String uploadProtocol) {
                return (Listposdataproviders)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Listposdataproviders set(String parameterName, Object value) {
                return (Listposdataproviders)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<LiasettingsListResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiasettingsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Getaccessiblegmbaccounts
        extends ShoppingContentRequest<LiasettingsGetAccessibleGmbAccountsResponse> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}/accessiblegmbaccounts";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Getaccessiblegmbaccounts(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiasettingsGetAccessibleGmbAccountsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Getaccessiblegmbaccounts set$Xgafv(String $Xgafv) {
                return (Getaccessiblegmbaccounts)super.set$Xgafv($Xgafv);
            }

            public Getaccessiblegmbaccounts setAccessToken(String accessToken) {
                return (Getaccessiblegmbaccounts)super.setAccessToken(accessToken);
            }

            public Getaccessiblegmbaccounts setAlt(String alt) {
                return (Getaccessiblegmbaccounts)super.setAlt(alt);
            }

            public Getaccessiblegmbaccounts setCallback(String callback) {
                return (Getaccessiblegmbaccounts)super.setCallback(callback);
            }

            public Getaccessiblegmbaccounts setFields(String fields) {
                return (Getaccessiblegmbaccounts)super.setFields(fields);
            }

            public Getaccessiblegmbaccounts setKey(String key) {
                return (Getaccessiblegmbaccounts)super.setKey(key);
            }

            public Getaccessiblegmbaccounts setOauthToken(String oauthToken) {
                return (Getaccessiblegmbaccounts)super.setOauthToken(oauthToken);
            }

            public Getaccessiblegmbaccounts setPrettyPrint(Boolean prettyPrint) {
                return (Getaccessiblegmbaccounts)super.setPrettyPrint(prettyPrint);
            }

            public Getaccessiblegmbaccounts setQuotaUser(String quotaUser) {
                return (Getaccessiblegmbaccounts)super.setQuotaUser(quotaUser);
            }

            public Getaccessiblegmbaccounts setUploadType(String uploadType) {
                return (Getaccessiblegmbaccounts)super.setUploadType(uploadType);
            }

            public Getaccessiblegmbaccounts setUploadProtocol(String uploadProtocol) {
                return (Getaccessiblegmbaccounts)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Getaccessiblegmbaccounts setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Getaccessiblegmbaccounts setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Getaccessiblegmbaccounts set(String parameterName, Object value) {
                return (Getaccessiblegmbaccounts)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<LiaSettings> {
            private static final String REST_PATH = "{merchantId}/liasettings/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Get(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, LiaSettings.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<LiasettingsCustomBatchResponse> {
            private static final String REST_PATH = "liasettings/batch";

            protected Custombatch(LiasettingsCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, LiasettingsCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Freelistingsprogram {
        public Get get(Long merchantId) throws IOException {
            Get result = new Get(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestreview requestreview(Long merchantId, RequestReviewFreeListingsRequest content) throws IOException {
            Requestreview result = new Requestreview(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Requestreview
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/freelistingsprogram/requestreview";
            @Key
            private Long merchantId;

            protected Requestreview(Long merchantId, RequestReviewFreeListingsRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Requestreview set$Xgafv(String $Xgafv) {
                return (Requestreview)super.set$Xgafv($Xgafv);
            }

            public Requestreview setAccessToken(String accessToken) {
                return (Requestreview)super.setAccessToken(accessToken);
            }

            public Requestreview setAlt(String alt) {
                return (Requestreview)super.setAlt(alt);
            }

            public Requestreview setCallback(String callback) {
                return (Requestreview)super.setCallback(callback);
            }

            public Requestreview setFields(String fields) {
                return (Requestreview)super.setFields(fields);
            }

            public Requestreview setKey(String key) {
                return (Requestreview)super.setKey(key);
            }

            public Requestreview setOauthToken(String oauthToken) {
                return (Requestreview)super.setOauthToken(oauthToken);
            }

            public Requestreview setPrettyPrint(Boolean prettyPrint) {
                return (Requestreview)super.setPrettyPrint(prettyPrint);
            }

            public Requestreview setQuotaUser(String quotaUser) {
                return (Requestreview)super.setQuotaUser(quotaUser);
            }

            public Requestreview setUploadType(String uploadType) {
                return (Requestreview)super.setUploadType(uploadType);
            }

            public Requestreview setUploadProtocol(String uploadProtocol) {
                return (Requestreview)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Requestreview setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Requestreview set(String parameterName, Object value) {
                return (Requestreview)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<FreeListingsProgramStatus> {
            private static final String REST_PATH = "{merchantId}/freelistingsprogram";
            @Key
            private Long merchantId;

            protected Get(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, FreeListingsProgramStatus.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Datafeedstatuses {
        public Custombatch custombatch(DatafeedstatusesCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger datafeedId) throws IOException {
            Get result = new Get(merchantId, datafeedId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<DatafeedstatusesListResponse> {
            private static final String REST_PATH = "{merchantId}/datafeedstatuses";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, DatafeedstatusesListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<DatafeedStatus> {
            private static final String REST_PATH = "{merchantId}/datafeedstatuses/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;
            @Key
            private String country;
            @Key
            private String feedLabel;
            @Key
            private String language;

            protected Get(BigInteger merchantId, BigInteger datafeedId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, DatafeedStatus.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)datafeedId, (Object)"Required parameter datafeedId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Get setDatafeedId(BigInteger datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public Get setCountry(String country) {
                this.country = country;
                return this;
            }

            public String getFeedLabel() {
                return this.feedLabel;
            }

            public Get setFeedLabel(String feedLabel) {
                this.feedLabel = feedLabel;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public Get setLanguage(String language) {
                this.language = language;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<DatafeedstatusesCustomBatchResponse> {
            private static final String REST_PATH = "datafeedstatuses/batch";

            protected Custombatch(DatafeedstatusesCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, DatafeedstatusesCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Datafeeds {
        public Custombatch custombatch(DatafeedsCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, BigInteger datafeedId) throws IOException {
            Delete result = new Delete(merchantId, datafeedId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Fetchnow fetchnow(BigInteger merchantId, BigInteger datafeedId) throws IOException {
            Fetchnow result = new Fetchnow(merchantId, datafeedId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger datafeedId) throws IOException {
            Get result = new Get(merchantId, datafeedId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, Datafeed content) throws IOException {
            Insert result = new Insert(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, BigInteger datafeedId, Datafeed content) throws IOException {
            Update result = new Update(merchantId, datafeedId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<Datafeed> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;

            protected Update(BigInteger merchantId, BigInteger datafeedId, Datafeed content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, Datafeed.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)datafeedId, (Object)"Required parameter datafeedId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Update setDatafeedId(BigInteger datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<DatafeedsListResponse> {
            private static final String REST_PATH = "{merchantId}/datafeeds";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, DatafeedsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<Datafeed> {
            private static final String REST_PATH = "{merchantId}/datafeeds";
            @Key
            private BigInteger merchantId;

            protected Insert(BigInteger merchantId, Datafeed content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Datafeed.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Datafeed> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;

            protected Get(BigInteger merchantId, BigInteger datafeedId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Datafeed.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)datafeedId, (Object)"Required parameter datafeedId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Get setDatafeedId(BigInteger datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Fetchnow
        extends ShoppingContentRequest<DatafeedsFetchNowResponse> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}/fetchNow";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;

            protected Fetchnow(BigInteger merchantId, BigInteger datafeedId) {
                super(ShoppingContent.this, "POST", REST_PATH, null, DatafeedsFetchNowResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)datafeedId, (Object)"Required parameter datafeedId must be specified.");
            }

            public Fetchnow set$Xgafv(String $Xgafv) {
                return (Fetchnow)super.set$Xgafv($Xgafv);
            }

            public Fetchnow setAccessToken(String accessToken) {
                return (Fetchnow)super.setAccessToken(accessToken);
            }

            public Fetchnow setAlt(String alt) {
                return (Fetchnow)super.setAlt(alt);
            }

            public Fetchnow setCallback(String callback) {
                return (Fetchnow)super.setCallback(callback);
            }

            public Fetchnow setFields(String fields) {
                return (Fetchnow)super.setFields(fields);
            }

            public Fetchnow setKey(String key) {
                return (Fetchnow)super.setKey(key);
            }

            public Fetchnow setOauthToken(String oauthToken) {
                return (Fetchnow)super.setOauthToken(oauthToken);
            }

            public Fetchnow setPrettyPrint(Boolean prettyPrint) {
                return (Fetchnow)super.setPrettyPrint(prettyPrint);
            }

            public Fetchnow setQuotaUser(String quotaUser) {
                return (Fetchnow)super.setQuotaUser(quotaUser);
            }

            public Fetchnow setUploadType(String uploadType) {
                return (Fetchnow)super.setUploadType(uploadType);
            }

            public Fetchnow setUploadProtocol(String uploadProtocol) {
                return (Fetchnow)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Fetchnow setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Fetchnow setDatafeedId(BigInteger datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            @Override
            public Fetchnow set(String parameterName, Object value) {
                return (Fetchnow)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/datafeeds/{datafeedId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger datafeedId;

            protected Delete(BigInteger merchantId, BigInteger datafeedId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.datafeedId = (BigInteger)Preconditions.checkNotNull((Object)datafeedId, (Object)"Required parameter datafeedId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getDatafeedId() {
                return this.datafeedId;
            }

            public Delete setDatafeedId(BigInteger datafeedId) {
                this.datafeedId = datafeedId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<DatafeedsCustomBatchResponse> {
            private static final String REST_PATH = "datafeeds/batch";

            protected Custombatch(DatafeedsCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, DatafeedsCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Csses {
        public Get get(Long cssGroupId, Long cssDomainId) throws IOException {
            Get result = new Get(cssGroupId, cssDomainId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long cssGroupId) throws IOException {
            List result = new List(cssGroupId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Updatelabels updatelabels(Long cssGroupId, Long cssDomainId, LabelIds content) throws IOException {
            Updatelabels result = new Updatelabels(cssGroupId, cssDomainId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Updatelabels
        extends ShoppingContentRequest<Css> {
            private static final String REST_PATH = "{cssGroupId}/csses/{cssDomainId}/updatelabels";
            @Key
            private Long cssGroupId;
            @Key
            private Long cssDomainId;

            protected Updatelabels(Long cssGroupId, Long cssDomainId, LabelIds content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Css.class);
                this.cssGroupId = (Long)Preconditions.checkNotNull((Object)cssGroupId, (Object)"Required parameter cssGroupId must be specified.");
                this.cssDomainId = (Long)Preconditions.checkNotNull((Object)cssDomainId, (Object)"Required parameter cssDomainId must be specified.");
            }

            public Updatelabels set$Xgafv(String $Xgafv) {
                return (Updatelabels)super.set$Xgafv($Xgafv);
            }

            public Updatelabels setAccessToken(String accessToken) {
                return (Updatelabels)super.setAccessToken(accessToken);
            }

            public Updatelabels setAlt(String alt) {
                return (Updatelabels)super.setAlt(alt);
            }

            public Updatelabels setCallback(String callback) {
                return (Updatelabels)super.setCallback(callback);
            }

            public Updatelabels setFields(String fields) {
                return (Updatelabels)super.setFields(fields);
            }

            public Updatelabels setKey(String key) {
                return (Updatelabels)super.setKey(key);
            }

            public Updatelabels setOauthToken(String oauthToken) {
                return (Updatelabels)super.setOauthToken(oauthToken);
            }

            public Updatelabels setPrettyPrint(Boolean prettyPrint) {
                return (Updatelabels)super.setPrettyPrint(prettyPrint);
            }

            public Updatelabels setQuotaUser(String quotaUser) {
                return (Updatelabels)super.setQuotaUser(quotaUser);
            }

            public Updatelabels setUploadType(String uploadType) {
                return (Updatelabels)super.setUploadType(uploadType);
            }

            public Updatelabels setUploadProtocol(String uploadProtocol) {
                return (Updatelabels)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCssGroupId() {
                return this.cssGroupId;
            }

            public Updatelabels setCssGroupId(Long cssGroupId) {
                this.cssGroupId = cssGroupId;
                return this;
            }

            public Long getCssDomainId() {
                return this.cssDomainId;
            }

            public Updatelabels setCssDomainId(Long cssDomainId) {
                this.cssDomainId = cssDomainId;
                return this;
            }

            @Override
            public Updatelabels set(String parameterName, Object value) {
                return (Updatelabels)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<ListCssesResponse> {
            private static final String REST_PATH = "{cssGroupId}/csses";
            @Key
            private Long cssGroupId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long cssGroupId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListCssesResponse.class);
                this.cssGroupId = (Long)Preconditions.checkNotNull((Object)cssGroupId, (Object)"Required parameter cssGroupId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCssGroupId() {
                return this.cssGroupId;
            }

            public List setCssGroupId(Long cssGroupId) {
                this.cssGroupId = cssGroupId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Css> {
            private static final String REST_PATH = "{cssGroupId}/csses/{cssDomainId}";
            @Key
            private Long cssGroupId;
            @Key
            private Long cssDomainId;

            protected Get(Long cssGroupId, Long cssDomainId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Css.class);
                this.cssGroupId = (Long)Preconditions.checkNotNull((Object)cssGroupId, (Object)"Required parameter cssGroupId must be specified.");
                this.cssDomainId = (Long)Preconditions.checkNotNull((Object)cssDomainId, (Object)"Required parameter cssDomainId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getCssGroupId() {
                return this.cssGroupId;
            }

            public Get setCssGroupId(Long cssGroupId) {
                this.cssGroupId = cssGroupId;
                return this;
            }

            public Long getCssDomainId() {
                return this.cssDomainId;
            }

            public Get setCssDomainId(Long cssDomainId) {
                this.cssDomainId = cssDomainId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Collectionstatuses {
        public Get get(Long merchantId, String collectionId) throws IOException {
            Get result = new Get(merchantId, collectionId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ListCollectionStatusesResponse> {
            private static final String REST_PATH = "{merchantId}/collectionstatuses";
            @Key
            private Long merchantId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListCollectionStatusesResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<CollectionStatus> {
            private static final String REST_PATH = "{merchantId}/collectionstatuses/{collectionId}";
            @Key
            private Long merchantId;
            @Key
            private String collectionId;

            protected Get(Long merchantId, String collectionId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, CollectionStatus.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.collectionId = (String)Preconditions.checkNotNull((Object)collectionId, (Object)"Required parameter collectionId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getCollectionId() {
                return this.collectionId;
            }

            public Get setCollectionId(String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Collections {
        public Create create(Long merchantId, Collection content) throws IOException {
            Create result = new Create(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(Long merchantId, String collectionId) throws IOException {
            Delete result = new Delete(merchantId, collectionId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String collectionId) throws IOException {
            Get result = new Get(merchantId, collectionId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(Long merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<ListCollectionsResponse> {
            private static final String REST_PATH = "{merchantId}/collections";
            @Key
            private Long merchantId;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(Long merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, ListCollectionsResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Collection> {
            private static final String REST_PATH = "{merchantId}/collections/{collectionId}";
            @Key
            private Long merchantId;
            @Key
            private String collectionId;

            protected Get(Long merchantId, String collectionId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Collection.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.collectionId = (String)Preconditions.checkNotNull((Object)collectionId, (Object)"Required parameter collectionId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getCollectionId() {
                return this.collectionId;
            }

            public Get setCollectionId(String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/collections/{collectionId}";
            @Key
            private Long merchantId;
            @Key
            private String collectionId;

            protected Delete(Long merchantId, String collectionId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.collectionId = (String)Preconditions.checkNotNull((Object)collectionId, (Object)"Required parameter collectionId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getCollectionId() {
                return this.collectionId;
            }

            public Delete setCollectionId(String collectionId) {
                this.collectionId = collectionId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends ShoppingContentRequest<Collection> {
            private static final String REST_PATH = "{merchantId}/collections";
            @Key
            private Long merchantId;

            protected Create(Long merchantId, Collection content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Collection.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Create setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Buyongoogleprograms {
        public Activate activate(Long merchantId, String regionCode, ActivateBuyOnGoogleProgramRequest content) throws IOException {
            Activate result = new Activate(merchantId, regionCode, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(Long merchantId, String regionCode) throws IOException {
            Get result = new Get(merchantId, regionCode);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Onboard onboard(Long merchantId, String regionCode, OnboardBuyOnGoogleProgramRequest content) throws IOException {
            Onboard result = new Onboard(merchantId, regionCode, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(Long merchantId, String regionCode, BuyOnGoogleProgramStatus content) throws IOException {
            Patch result = new Patch(merchantId, regionCode, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Pause pause(Long merchantId, String regionCode, PauseBuyOnGoogleProgramRequest content) throws IOException {
            Pause result = new Pause(merchantId, regionCode, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestreview requestreview(Long merchantId, String regionCode, RequestReviewBuyOnGoogleProgramRequest content) throws IOException {
            Requestreview result = new Requestreview(merchantId, regionCode, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Requestreview
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/buyongoogleprograms/{regionCode}/requestreview";
            @Key
            private Long merchantId;
            @Key
            private String regionCode;

            protected Requestreview(Long merchantId, String regionCode, RequestReviewBuyOnGoogleProgramRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionCode = (String)Preconditions.checkNotNull((Object)regionCode, (Object)"Required parameter regionCode must be specified.");
            }

            public Requestreview set$Xgafv(String $Xgafv) {
                return (Requestreview)super.set$Xgafv($Xgafv);
            }

            public Requestreview setAccessToken(String accessToken) {
                return (Requestreview)super.setAccessToken(accessToken);
            }

            public Requestreview setAlt(String alt) {
                return (Requestreview)super.setAlt(alt);
            }

            public Requestreview setCallback(String callback) {
                return (Requestreview)super.setCallback(callback);
            }

            public Requestreview setFields(String fields) {
                return (Requestreview)super.setFields(fields);
            }

            public Requestreview setKey(String key) {
                return (Requestreview)super.setKey(key);
            }

            public Requestreview setOauthToken(String oauthToken) {
                return (Requestreview)super.setOauthToken(oauthToken);
            }

            public Requestreview setPrettyPrint(Boolean prettyPrint) {
                return (Requestreview)super.setPrettyPrint(prettyPrint);
            }

            public Requestreview setQuotaUser(String quotaUser) {
                return (Requestreview)super.setQuotaUser(quotaUser);
            }

            public Requestreview setUploadType(String uploadType) {
                return (Requestreview)super.setUploadType(uploadType);
            }

            public Requestreview setUploadProtocol(String uploadProtocol) {
                return (Requestreview)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Requestreview setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public Requestreview setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            @Override
            public Requestreview set(String parameterName, Object value) {
                return (Requestreview)super.set(parameterName, value);
            }
        }

        public class Pause
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/buyongoogleprograms/{regionCode}/pause";
            @Key
            private Long merchantId;
            @Key
            private String regionCode;

            protected Pause(Long merchantId, String regionCode, PauseBuyOnGoogleProgramRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionCode = (String)Preconditions.checkNotNull((Object)regionCode, (Object)"Required parameter regionCode must be specified.");
            }

            public Pause set$Xgafv(String $Xgafv) {
                return (Pause)super.set$Xgafv($Xgafv);
            }

            public Pause setAccessToken(String accessToken) {
                return (Pause)super.setAccessToken(accessToken);
            }

            public Pause setAlt(String alt) {
                return (Pause)super.setAlt(alt);
            }

            public Pause setCallback(String callback) {
                return (Pause)super.setCallback(callback);
            }

            public Pause setFields(String fields) {
                return (Pause)super.setFields(fields);
            }

            public Pause setKey(String key) {
                return (Pause)super.setKey(key);
            }

            public Pause setOauthToken(String oauthToken) {
                return (Pause)super.setOauthToken(oauthToken);
            }

            public Pause setPrettyPrint(Boolean prettyPrint) {
                return (Pause)super.setPrettyPrint(prettyPrint);
            }

            public Pause setQuotaUser(String quotaUser) {
                return (Pause)super.setQuotaUser(quotaUser);
            }

            public Pause setUploadType(String uploadType) {
                return (Pause)super.setUploadType(uploadType);
            }

            public Pause setUploadProtocol(String uploadProtocol) {
                return (Pause)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Pause setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public Pause setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            @Override
            public Pause set(String parameterName, Object value) {
                return (Pause)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ShoppingContentRequest<BuyOnGoogleProgramStatus> {
            private static final String REST_PATH = "{merchantId}/buyongoogleprograms/{regionCode}";
            @Key
            private Long merchantId;
            @Key
            private String regionCode;
            @Key
            private String updateMask;

            protected Patch(Long merchantId, String regionCode, BuyOnGoogleProgramStatus content) {
                super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, BuyOnGoogleProgramStatus.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionCode = (String)Preconditions.checkNotNull((Object)regionCode, (Object)"Required parameter regionCode must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Patch setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public Patch setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Onboard
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/buyongoogleprograms/{regionCode}/onboard";
            @Key
            private Long merchantId;
            @Key
            private String regionCode;

            protected Onboard(Long merchantId, String regionCode, OnboardBuyOnGoogleProgramRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionCode = (String)Preconditions.checkNotNull((Object)regionCode, (Object)"Required parameter regionCode must be specified.");
            }

            public Onboard set$Xgafv(String $Xgafv) {
                return (Onboard)super.set$Xgafv($Xgafv);
            }

            public Onboard setAccessToken(String accessToken) {
                return (Onboard)super.setAccessToken(accessToken);
            }

            public Onboard setAlt(String alt) {
                return (Onboard)super.setAlt(alt);
            }

            public Onboard setCallback(String callback) {
                return (Onboard)super.setCallback(callback);
            }

            public Onboard setFields(String fields) {
                return (Onboard)super.setFields(fields);
            }

            public Onboard setKey(String key) {
                return (Onboard)super.setKey(key);
            }

            public Onboard setOauthToken(String oauthToken) {
                return (Onboard)super.setOauthToken(oauthToken);
            }

            public Onboard setPrettyPrint(Boolean prettyPrint) {
                return (Onboard)super.setPrettyPrint(prettyPrint);
            }

            public Onboard setQuotaUser(String quotaUser) {
                return (Onboard)super.setQuotaUser(quotaUser);
            }

            public Onboard setUploadType(String uploadType) {
                return (Onboard)super.setUploadType(uploadType);
            }

            public Onboard setUploadProtocol(String uploadProtocol) {
                return (Onboard)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Onboard setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public Onboard setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            @Override
            public Onboard set(String parameterName, Object value) {
                return (Onboard)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<BuyOnGoogleProgramStatus> {
            private static final String REST_PATH = "{merchantId}/buyongoogleprograms/{regionCode}";
            @Key
            private Long merchantId;
            @Key
            private String regionCode;

            protected Get(Long merchantId, String regionCode) {
                super(ShoppingContent.this, "GET", REST_PATH, null, BuyOnGoogleProgramStatus.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionCode = (String)Preconditions.checkNotNull((Object)regionCode, (Object)"Required parameter regionCode must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public Get setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Activate
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/buyongoogleprograms/{regionCode}/activate";
            @Key
            private Long merchantId;
            @Key
            private String regionCode;

            protected Activate(Long merchantId, String regionCode, ActivateBuyOnGoogleProgramRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Void.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.regionCode = (String)Preconditions.checkNotNull((Object)regionCode, (Object)"Required parameter regionCode must be specified.");
            }

            public Activate set$Xgafv(String $Xgafv) {
                return (Activate)super.set$Xgafv($Xgafv);
            }

            public Activate setAccessToken(String accessToken) {
                return (Activate)super.setAccessToken(accessToken);
            }

            public Activate setAlt(String alt) {
                return (Activate)super.setAlt(alt);
            }

            public Activate setCallback(String callback) {
                return (Activate)super.setCallback(callback);
            }

            public Activate setFields(String fields) {
                return (Activate)super.setFields(fields);
            }

            public Activate setKey(String key) {
                return (Activate)super.setKey(key);
            }

            public Activate setOauthToken(String oauthToken) {
                return (Activate)super.setOauthToken(oauthToken);
            }

            public Activate setPrettyPrint(Boolean prettyPrint) {
                return (Activate)super.setPrettyPrint(prettyPrint);
            }

            public Activate setQuotaUser(String quotaUser) {
                return (Activate)super.setQuotaUser(quotaUser);
            }

            public Activate setUploadType(String uploadType) {
                return (Activate)super.setUploadType(uploadType);
            }

            public Activate setUploadProtocol(String uploadProtocol) {
                return (Activate)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Activate setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public Activate setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            @Override
            public Activate set(String parameterName, Object value) {
                return (Activate)super.set(parameterName, value);
            }
        }
    }

    public class Accounttax {
        public Custombatch custombatch(AccounttaxCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger accountId) throws IOException {
            Get result = new Get(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, BigInteger accountId, AccountTax content) throws IOException {
            Update result = new Update(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ShoppingContentRequest<AccountTax> {
            private static final String REST_PATH = "{merchantId}/accounttax/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Update(BigInteger merchantId, BigInteger accountId, AccountTax content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, AccountTax.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<AccounttaxListResponse> {
            private static final String REST_PATH = "{merchantId}/accounttax";
            @Key
            private BigInteger merchantId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccounttaxListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<AccountTax> {
            private static final String REST_PATH = "{merchantId}/accounttax/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Get(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountTax.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<AccounttaxCustomBatchResponse> {
            private static final String REST_PATH = "accounttax/batch";

            protected Custombatch(AccounttaxCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccounttaxCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Accountstatuses {
        public Custombatch custombatch(AccountstatusesCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger accountId) throws IOException {
            Get result = new Get(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ShoppingContentRequest<AccountstatusesListResponse> {
            private static final String REST_PATH = "{merchantId}/accountstatuses";
            @Key
            private BigInteger merchantId;
            @Key
            private java.util.List<String> destinations;
            @Key
            private Long maxResults;
            @Key
            private String name;
            @Key
            private String pageToken;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountstatusesListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public List setDestinations(java.util.List<String> destinations) {
                this.destinations = destinations;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<AccountStatus> {
            private static final String REST_PATH = "{merchantId}/accountstatuses/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private java.util.List<String> destinations;

            protected Get(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountStatus.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public java.util.List<String> getDestinations() {
                return this.destinations;
            }

            public Get setDestinations(java.util.List<String> destinations) {
                this.destinations = destinations;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<AccountstatusesCustomBatchResponse> {
            private static final String REST_PATH = "accountstatuses/batch";

            protected Custombatch(AccountstatusesCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountstatusesCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }
    }

    public class Accounts {
        public Authinfo authinfo() throws IOException {
            Authinfo result = new Authinfo();
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Claimwebsite claimwebsite(BigInteger merchantId, BigInteger accountId) throws IOException {
            Claimwebsite result = new Claimwebsite(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Custombatch custombatch(AccountsCustomBatchRequest content) throws IOException {
            Custombatch result = new Custombatch(content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(BigInteger merchantId, BigInteger accountId) throws IOException {
            Delete result = new Delete(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(BigInteger merchantId, BigInteger accountId) throws IOException {
            Get result = new Get(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(BigInteger merchantId, Account content) throws IOException {
            Insert result = new Insert(merchantId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Link link(BigInteger merchantId, BigInteger accountId, AccountsLinkRequest content) throws IOException {
            Link result = new Link(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(BigInteger merchantId) throws IOException {
            List result = new List(merchantId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Listlinks listlinks(BigInteger merchantId, BigInteger accountId) throws IOException {
            Listlinks result = new Listlinks(merchantId, accountId);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Requestphoneverification requestphoneverification(Long merchantId, Long accountId, RequestPhoneVerificationRequest content) throws IOException {
            Requestphoneverification result = new Requestphoneverification(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(BigInteger merchantId, BigInteger accountId, Account content) throws IOException {
            Update result = new Update(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Updatelabels updatelabels(BigInteger merchantId, BigInteger accountId, AccountsUpdateLabelsRequest content) throws IOException {
            Updatelabels result = new Updatelabels(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Verifyphonenumber verifyphonenumber(Long merchantId, Long accountId, VerifyPhoneNumberRequest content) throws IOException {
            Verifyphonenumber result = new Verifyphonenumber(merchantId, accountId, content);
            ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Credentials credentials() {
            return new Credentials();
        }

        public Labels labels() {
            return new Labels();
        }

        public Returncarrier returncarrier() {
            return new Returncarrier();
        }

        public class Returncarrier {
            public Create create(Long accountId, AccountReturnCarrier content) throws IOException {
                Create result = new Create(accountId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long accountId, Long carrierAccountId) throws IOException {
                Delete result = new Delete(accountId, carrierAccountId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long accountId) throws IOException {
                List result = new List(accountId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long accountId, Long carrierAccountId, AccountReturnCarrier content) throws IOException {
                Patch result = new Patch(accountId, carrierAccountId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends ShoppingContentRequest<AccountReturnCarrier> {
                private static final String REST_PATH = "accounts/{accountId}/returncarrier/{carrierAccountId}";
                @Key
                private Long accountId;
                @Key
                private Long carrierAccountId;

                protected Patch(Long accountId, Long carrierAccountId, AccountReturnCarrier content) {
                    super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, AccountReturnCarrier.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.carrierAccountId = (Long)Preconditions.checkNotNull((Object)carrierAccountId, (Object)"Required parameter carrierAccountId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Long getCarrierAccountId() {
                    return this.carrierAccountId;
                }

                public Patch setCarrierAccountId(Long carrierAccountId) {
                    this.carrierAccountId = carrierAccountId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends ShoppingContentRequest<ListAccountReturnCarrierResponse> {
                private static final String REST_PATH = "accounts/{accountId}/returncarrier";
                @Key
                private Long accountId;

                protected List(Long accountId) {
                    super(ShoppingContent.this, "GET", REST_PATH, null, ListAccountReturnCarrierResponse.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ShoppingContentRequest<Void> {
                private static final String REST_PATH = "accounts/{accountId}/returncarrier/{carrierAccountId}";
                @Key
                private Long accountId;
                @Key
                private Long carrierAccountId;

                protected Delete(Long accountId, Long carrierAccountId) {
                    super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.carrierAccountId = (Long)Preconditions.checkNotNull((Object)carrierAccountId, (Object)"Required parameter carrierAccountId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Long getCarrierAccountId() {
                    return this.carrierAccountId;
                }

                public Delete setCarrierAccountId(Long carrierAccountId) {
                    this.carrierAccountId = carrierAccountId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ShoppingContentRequest<AccountReturnCarrier> {
                private static final String REST_PATH = "accounts/{accountId}/returncarrier";
                @Key
                private Long accountId;

                protected Create(Long accountId, AccountReturnCarrier content) {
                    super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountReturnCarrier.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Create setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Labels {
            public Create create(Long accountId, AccountLabel content) throws IOException {
                Create result = new Create(accountId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(Long accountId, Long labelId) throws IOException {
                Delete result = new Delete(accountId, labelId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(Long accountId) throws IOException {
                List result = new List(accountId);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(Long accountId, Long labelId, AccountLabel content) throws IOException {
                Patch result = new Patch(accountId, labelId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends ShoppingContentRequest<AccountLabel> {
                private static final String REST_PATH = "accounts/{accountId}/labels/{labelId}";
                @Key
                private Long accountId;
                @Key
                private Long labelId;

                protected Patch(Long accountId, Long labelId, AccountLabel content) {
                    super(ShoppingContent.this, "PATCH", REST_PATH, (Object)content, AccountLabel.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.labelId = (Long)Preconditions.checkNotNull((Object)labelId, (Object)"Required parameter labelId must be specified.");
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Long getLabelId() {
                    return this.labelId;
                }

                public Patch setLabelId(Long labelId) {
                    this.labelId = labelId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends ShoppingContentRequest<ListAccountLabelsResponse> {
                private static final String REST_PATH = "accounts/{accountId}/labels";
                @Key
                private Long accountId;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(Long accountId) {
                    super(ShoppingContent.this, "GET", REST_PATH, null, ListAccountLabelsResponse.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends ShoppingContentRequest<Void> {
                private static final String REST_PATH = "accounts/{accountId}/labels/{labelId}";
                @Key
                private Long accountId;
                @Key
                private Long labelId;

                protected Delete(Long accountId, Long labelId) {
                    super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.labelId = (Long)Preconditions.checkNotNull((Object)labelId, (Object)"Required parameter labelId must be specified.");
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Long getLabelId() {
                    return this.labelId;
                }

                public Delete setLabelId(Long labelId) {
                    this.labelId = labelId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends ShoppingContentRequest<AccountLabel> {
                private static final String REST_PATH = "accounts/{accountId}/labels";
                @Key
                private Long accountId;

                protected Create(Long accountId, AccountLabel content) {
                    super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountLabel.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Create setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Credentials {
            public Create create(Long accountId, AccountCredentials content) throws IOException {
                Create result = new Create(accountId, content);
                ShoppingContent.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Create
            extends ShoppingContentRequest<AccountCredentials> {
                private static final String REST_PATH = "accounts/{accountId}/credentials";
                @Key
                private Long accountId;

                protected Create(Long accountId, AccountCredentials content) {
                    super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountCredentials.class);
                    this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public Long getAccountId() {
                    return this.accountId;
                }

                public Create setAccountId(Long accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class Verifyphonenumber
        extends ShoppingContentRequest<VerifyPhoneNumberResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/verifyphonenumber";
            @Key
            private Long merchantId;
            @Key
            private Long accountId;

            protected Verifyphonenumber(Long merchantId, Long accountId, VerifyPhoneNumberRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, VerifyPhoneNumberResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Verifyphonenumber set$Xgafv(String $Xgafv) {
                return (Verifyphonenumber)super.set$Xgafv($Xgafv);
            }

            public Verifyphonenumber setAccessToken(String accessToken) {
                return (Verifyphonenumber)super.setAccessToken(accessToken);
            }

            public Verifyphonenumber setAlt(String alt) {
                return (Verifyphonenumber)super.setAlt(alt);
            }

            public Verifyphonenumber setCallback(String callback) {
                return (Verifyphonenumber)super.setCallback(callback);
            }

            public Verifyphonenumber setFields(String fields) {
                return (Verifyphonenumber)super.setFields(fields);
            }

            public Verifyphonenumber setKey(String key) {
                return (Verifyphonenumber)super.setKey(key);
            }

            public Verifyphonenumber setOauthToken(String oauthToken) {
                return (Verifyphonenumber)super.setOauthToken(oauthToken);
            }

            public Verifyphonenumber setPrettyPrint(Boolean prettyPrint) {
                return (Verifyphonenumber)super.setPrettyPrint(prettyPrint);
            }

            public Verifyphonenumber setQuotaUser(String quotaUser) {
                return (Verifyphonenumber)super.setQuotaUser(quotaUser);
            }

            public Verifyphonenumber setUploadType(String uploadType) {
                return (Verifyphonenumber)super.setUploadType(uploadType);
            }

            public Verifyphonenumber setUploadProtocol(String uploadProtocol) {
                return (Verifyphonenumber)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Verifyphonenumber setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getAccountId() {
                return this.accountId;
            }

            public Verifyphonenumber setAccountId(Long accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Verifyphonenumber set(String parameterName, Object value) {
                return (Verifyphonenumber)super.set(parameterName, value);
            }
        }

        public class Updatelabels
        extends ShoppingContentRequest<AccountsUpdateLabelsResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/updatelabels";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Updatelabels(BigInteger merchantId, BigInteger accountId, AccountsUpdateLabelsRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountsUpdateLabelsResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Updatelabels set$Xgafv(String $Xgafv) {
                return (Updatelabels)super.set$Xgafv($Xgafv);
            }

            public Updatelabels setAccessToken(String accessToken) {
                return (Updatelabels)super.setAccessToken(accessToken);
            }

            public Updatelabels setAlt(String alt) {
                return (Updatelabels)super.setAlt(alt);
            }

            public Updatelabels setCallback(String callback) {
                return (Updatelabels)super.setCallback(callback);
            }

            public Updatelabels setFields(String fields) {
                return (Updatelabels)super.setFields(fields);
            }

            public Updatelabels setKey(String key) {
                return (Updatelabels)super.setKey(key);
            }

            public Updatelabels setOauthToken(String oauthToken) {
                return (Updatelabels)super.setOauthToken(oauthToken);
            }

            public Updatelabels setPrettyPrint(Boolean prettyPrint) {
                return (Updatelabels)super.setPrettyPrint(prettyPrint);
            }

            public Updatelabels setQuotaUser(String quotaUser) {
                return (Updatelabels)super.setQuotaUser(quotaUser);
            }

            public Updatelabels setUploadType(String uploadType) {
                return (Updatelabels)super.setUploadType(uploadType);
            }

            public Updatelabels setUploadProtocol(String uploadProtocol) {
                return (Updatelabels)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Updatelabels setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Updatelabels setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Updatelabels set(String parameterName, Object value) {
                return (Updatelabels)super.set(parameterName, value);
            }
        }

        public class Update
        extends ShoppingContentRequest<Account> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Update(BigInteger merchantId, BigInteger accountId, Account content) {
                super(ShoppingContent.this, "PUT", REST_PATH, (Object)content, Account.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Update setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Update setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Requestphoneverification
        extends ShoppingContentRequest<RequestPhoneVerificationResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/requestphoneverification";
            @Key
            private Long merchantId;
            @Key
            private Long accountId;

            protected Requestphoneverification(Long merchantId, Long accountId, RequestPhoneVerificationRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, RequestPhoneVerificationResponse.class);
                this.merchantId = (Long)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (Long)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Requestphoneverification set$Xgafv(String $Xgafv) {
                return (Requestphoneverification)super.set$Xgafv($Xgafv);
            }

            public Requestphoneverification setAccessToken(String accessToken) {
                return (Requestphoneverification)super.setAccessToken(accessToken);
            }

            public Requestphoneverification setAlt(String alt) {
                return (Requestphoneverification)super.setAlt(alt);
            }

            public Requestphoneverification setCallback(String callback) {
                return (Requestphoneverification)super.setCallback(callback);
            }

            public Requestphoneverification setFields(String fields) {
                return (Requestphoneverification)super.setFields(fields);
            }

            public Requestphoneverification setKey(String key) {
                return (Requestphoneverification)super.setKey(key);
            }

            public Requestphoneverification setOauthToken(String oauthToken) {
                return (Requestphoneverification)super.setOauthToken(oauthToken);
            }

            public Requestphoneverification setPrettyPrint(Boolean prettyPrint) {
                return (Requestphoneverification)super.setPrettyPrint(prettyPrint);
            }

            public Requestphoneverification setQuotaUser(String quotaUser) {
                return (Requestphoneverification)super.setQuotaUser(quotaUser);
            }

            public Requestphoneverification setUploadType(String uploadType) {
                return (Requestphoneverification)super.setUploadType(uploadType);
            }

            public Requestphoneverification setUploadProtocol(String uploadProtocol) {
                return (Requestphoneverification)super.setUploadProtocol(uploadProtocol);
            }

            public Long getMerchantId() {
                return this.merchantId;
            }

            public Requestphoneverification setMerchantId(Long merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public Long getAccountId() {
                return this.accountId;
            }

            public Requestphoneverification setAccountId(Long accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Requestphoneverification set(String parameterName, Object value) {
                return (Requestphoneverification)super.set(parameterName, value);
            }
        }

        public class Listlinks
        extends ShoppingContentRequest<AccountsListLinksResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/listlinks";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;

            protected Listlinks(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountsListLinksResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Listlinks set$Xgafv(String $Xgafv) {
                return (Listlinks)super.set$Xgafv($Xgafv);
            }

            public Listlinks setAccessToken(String accessToken) {
                return (Listlinks)super.setAccessToken(accessToken);
            }

            public Listlinks setAlt(String alt) {
                return (Listlinks)super.setAlt(alt);
            }

            public Listlinks setCallback(String callback) {
                return (Listlinks)super.setCallback(callback);
            }

            public Listlinks setFields(String fields) {
                return (Listlinks)super.setFields(fields);
            }

            public Listlinks setKey(String key) {
                return (Listlinks)super.setKey(key);
            }

            public Listlinks setOauthToken(String oauthToken) {
                return (Listlinks)super.setOauthToken(oauthToken);
            }

            public Listlinks setPrettyPrint(Boolean prettyPrint) {
                return (Listlinks)super.setPrettyPrint(prettyPrint);
            }

            public Listlinks setQuotaUser(String quotaUser) {
                return (Listlinks)super.setQuotaUser(quotaUser);
            }

            public Listlinks setUploadType(String uploadType) {
                return (Listlinks)super.setUploadType(uploadType);
            }

            public Listlinks setUploadProtocol(String uploadProtocol) {
                return (Listlinks)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Listlinks setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Listlinks setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Listlinks setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Listlinks setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public Listlinks set(String parameterName, Object value) {
                return (Listlinks)super.set(parameterName, value);
            }
        }

        public class List
        extends ShoppingContentRequest<AccountsListResponse> {
            private static final String REST_PATH = "{merchantId}/accounts";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger label;
            @Key
            private Long maxResults;
            @Key
            private String name;
            @Key
            private String pageToken;
            @Key
            private String view;

            protected List(BigInteger merchantId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountsListResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public List setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getLabel() {
                return this.label;
            }

            public List setLabel(BigInteger label) {
                this.label = label;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Link
        extends ShoppingContentRequest<AccountsLinkResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/link";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;

            protected Link(BigInteger merchantId, BigInteger accountId, AccountsLinkRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountsLinkResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Link set$Xgafv(String $Xgafv) {
                return (Link)super.set$Xgafv($Xgafv);
            }

            public Link setAccessToken(String accessToken) {
                return (Link)super.setAccessToken(accessToken);
            }

            public Link setAlt(String alt) {
                return (Link)super.setAlt(alt);
            }

            public Link setCallback(String callback) {
                return (Link)super.setCallback(callback);
            }

            public Link setFields(String fields) {
                return (Link)super.setFields(fields);
            }

            public Link setKey(String key) {
                return (Link)super.setKey(key);
            }

            public Link setOauthToken(String oauthToken) {
                return (Link)super.setOauthToken(oauthToken);
            }

            public Link setPrettyPrint(Boolean prettyPrint) {
                return (Link)super.setPrettyPrint(prettyPrint);
            }

            public Link setQuotaUser(String quotaUser) {
                return (Link)super.setQuotaUser(quotaUser);
            }

            public Link setUploadType(String uploadType) {
                return (Link)super.setUploadType(uploadType);
            }

            public Link setUploadProtocol(String uploadProtocol) {
                return (Link)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Link setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Link setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            @Override
            public Link set(String parameterName, Object value) {
                return (Link)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ShoppingContentRequest<Account> {
            private static final String REST_PATH = "{merchantId}/accounts";
            @Key
            private BigInteger merchantId;

            protected Insert(BigInteger merchantId, Account content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, Account.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Insert setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ShoppingContentRequest<Account> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private String view;

            protected Get(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "GET", REST_PATH, null, Account.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Get setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Get setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public Get setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ShoppingContentRequest<Void> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean force;

            protected Delete(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "DELETE", REST_PATH, null, Void.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Delete setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Delete setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public Boolean getForce() {
                return this.force;
            }

            public Delete setForce(Boolean force) {
                this.force = force;
                return this;
            }

            public boolean isForce() {
                if (this.force == null || this.force == Data.NULL_BOOLEAN) {
                    return false;
                }
                return this.force;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Custombatch
        extends ShoppingContentRequest<AccountsCustomBatchResponse> {
            private static final String REST_PATH = "accounts/batch";

            protected Custombatch(AccountsCustomBatchRequest content) {
                super(ShoppingContent.this, "POST", REST_PATH, (Object)content, AccountsCustomBatchResponse.class);
            }

            public Custombatch set$Xgafv(String $Xgafv) {
                return (Custombatch)super.set$Xgafv($Xgafv);
            }

            public Custombatch setAccessToken(String accessToken) {
                return (Custombatch)super.setAccessToken(accessToken);
            }

            public Custombatch setAlt(String alt) {
                return (Custombatch)super.setAlt(alt);
            }

            public Custombatch setCallback(String callback) {
                return (Custombatch)super.setCallback(callback);
            }

            public Custombatch setFields(String fields) {
                return (Custombatch)super.setFields(fields);
            }

            public Custombatch setKey(String key) {
                return (Custombatch)super.setKey(key);
            }

            public Custombatch setOauthToken(String oauthToken) {
                return (Custombatch)super.setOauthToken(oauthToken);
            }

            public Custombatch setPrettyPrint(Boolean prettyPrint) {
                return (Custombatch)super.setPrettyPrint(prettyPrint);
            }

            public Custombatch setQuotaUser(String quotaUser) {
                return (Custombatch)super.setQuotaUser(quotaUser);
            }

            public Custombatch setUploadType(String uploadType) {
                return (Custombatch)super.setUploadType(uploadType);
            }

            public Custombatch setUploadProtocol(String uploadProtocol) {
                return (Custombatch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Custombatch set(String parameterName, Object value) {
                return (Custombatch)super.set(parameterName, value);
            }
        }

        public class Claimwebsite
        extends ShoppingContentRequest<AccountsClaimWebsiteResponse> {
            private static final String REST_PATH = "{merchantId}/accounts/{accountId}/claimwebsite";
            @Key
            private BigInteger merchantId;
            @Key
            private BigInteger accountId;
            @Key
            private Boolean overwrite;

            protected Claimwebsite(BigInteger merchantId, BigInteger accountId) {
                super(ShoppingContent.this, "POST", REST_PATH, null, AccountsClaimWebsiteResponse.class);
                this.merchantId = (BigInteger)Preconditions.checkNotNull((Object)merchantId, (Object)"Required parameter merchantId must be specified.");
                this.accountId = (BigInteger)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
            }

            public Claimwebsite set$Xgafv(String $Xgafv) {
                return (Claimwebsite)super.set$Xgafv($Xgafv);
            }

            public Claimwebsite setAccessToken(String accessToken) {
                return (Claimwebsite)super.setAccessToken(accessToken);
            }

            public Claimwebsite setAlt(String alt) {
                return (Claimwebsite)super.setAlt(alt);
            }

            public Claimwebsite setCallback(String callback) {
                return (Claimwebsite)super.setCallback(callback);
            }

            public Claimwebsite setFields(String fields) {
                return (Claimwebsite)super.setFields(fields);
            }

            public Claimwebsite setKey(String key) {
                return (Claimwebsite)super.setKey(key);
            }

            public Claimwebsite setOauthToken(String oauthToken) {
                return (Claimwebsite)super.setOauthToken(oauthToken);
            }

            public Claimwebsite setPrettyPrint(Boolean prettyPrint) {
                return (Claimwebsite)super.setPrettyPrint(prettyPrint);
            }

            public Claimwebsite setQuotaUser(String quotaUser) {
                return (Claimwebsite)super.setQuotaUser(quotaUser);
            }

            public Claimwebsite setUploadType(String uploadType) {
                return (Claimwebsite)super.setUploadType(uploadType);
            }

            public Claimwebsite setUploadProtocol(String uploadProtocol) {
                return (Claimwebsite)super.setUploadProtocol(uploadProtocol);
            }

            public BigInteger getMerchantId() {
                return this.merchantId;
            }

            public Claimwebsite setMerchantId(BigInteger merchantId) {
                this.merchantId = merchantId;
                return this;
            }

            public BigInteger getAccountId() {
                return this.accountId;
            }

            public Claimwebsite setAccountId(BigInteger accountId) {
                this.accountId = accountId;
                return this;
            }

            public Boolean getOverwrite() {
                return this.overwrite;
            }

            public Claimwebsite setOverwrite(Boolean overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            @Override
            public Claimwebsite set(String parameterName, Object value) {
                return (Claimwebsite)super.set(parameterName, value);
            }
        }

        public class Authinfo
        extends ShoppingContentRequest<AccountsAuthInfoResponse> {
            private static final String REST_PATH = "accounts/authinfo";

            protected Authinfo() {
                super(ShoppingContent.this, "GET", REST_PATH, null, AccountsAuthInfoResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Authinfo set$Xgafv(String $Xgafv) {
                return (Authinfo)super.set$Xgafv($Xgafv);
            }

            public Authinfo setAccessToken(String accessToken) {
                return (Authinfo)super.setAccessToken(accessToken);
            }

            public Authinfo setAlt(String alt) {
                return (Authinfo)super.setAlt(alt);
            }

            public Authinfo setCallback(String callback) {
                return (Authinfo)super.setCallback(callback);
            }

            public Authinfo setFields(String fields) {
                return (Authinfo)super.setFields(fields);
            }

            public Authinfo setKey(String key) {
                return (Authinfo)super.setKey(key);
            }

            public Authinfo setOauthToken(String oauthToken) {
                return (Authinfo)super.setOauthToken(oauthToken);
            }

            public Authinfo setPrettyPrint(Boolean prettyPrint) {
                return (Authinfo)super.setPrettyPrint(prettyPrint);
            }

            public Authinfo setQuotaUser(String quotaUser) {
                return (Authinfo)super.setQuotaUser(quotaUser);
            }

            public Authinfo setUploadType(String uploadType) {
                return (Authinfo)super.setUploadType(uploadType);
            }

            public Authinfo setUploadProtocol(String uploadProtocol) {
                return (Authinfo)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Authinfo set(String parameterName, Object value) {
                return (Authinfo)super.set(parameterName, value);
            }
        }
    }
}

