/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The automatic improvements of the account can be used to automatically update items, improve
 * images and shipping.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountAutomaticImprovements extends com.google.api.client.json.GenericJson {

  /**
   * This improvement will attempt to automatically correct submitted images if they don't meet the
   * [image requirements](https://support.google.com/merchants/answer/6324350), for example,
   * removing overlays. If successful, the image will be replaced and approved. This improvement is
   * only applied to images of disapproved offers. For more information see: [Automatic image
   * improvements](https://support.google.com/merchants/answer/9242973) This field is only updated
   * (cleared) if provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountImageImprovements imageImprovements;

  /**
   * Turning on [item updates](https://support.google.com/merchants/answer/3246284) allows Google to
   * automatically update items for you. When item updates are on, Google uses the structured data
   * markup on the website and advanced data extractors to update the price and availability of the
   * items. When the item updates are off, items with mismatched data aren't shown. This field is
   * only updated (cleared) if provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountItemUpdates itemUpdates;

  /**
   * Not available for MCAs [accounts](https://support.google.com/merchants/answer/188487). By
   * turning on [automatic shipping
   * improvements](https://support.google.com/merchants/answer/10027038), you are allowing Google to
   * improve the accuracy of your delivery times shown to shoppers using Google. More accurate
   * delivery times, especially when faster, typically lead to better conversion rates. Google will
   * improve your estimated delivery times based on various factors: - Delivery address of an order
   * - Current handling time and shipping time settings - Estimated weekdays or business days -
   * Parcel tracking data This field is only updated (cleared) if provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountShippingImprovements shippingImprovements;

  /**
   * This improvement will attempt to automatically correct submitted images if they don't meet the
   * [image requirements](https://support.google.com/merchants/answer/6324350), for example,
   * removing overlays. If successful, the image will be replaced and approved. This improvement is
   * only applied to images of disapproved offers. For more information see: [Automatic image
   * improvements](https://support.google.com/merchants/answer/9242973) This field is only updated
   * (cleared) if provided.
   * @return value or {@code null} for none
   */
  public AccountImageImprovements getImageImprovements() {
    return imageImprovements;
  }

  /**
   * This improvement will attempt to automatically correct submitted images if they don't meet the
   * [image requirements](https://support.google.com/merchants/answer/6324350), for example,
   * removing overlays. If successful, the image will be replaced and approved. This improvement is
   * only applied to images of disapproved offers. For more information see: [Automatic image
   * improvements](https://support.google.com/merchants/answer/9242973) This field is only updated
   * (cleared) if provided.
   * @param imageImprovements imageImprovements or {@code null} for none
   */
  public AccountAutomaticImprovements setImageImprovements(AccountImageImprovements imageImprovements) {
    this.imageImprovements = imageImprovements;
    return this;
  }

  /**
   * Turning on [item updates](https://support.google.com/merchants/answer/3246284) allows Google to
   * automatically update items for you. When item updates are on, Google uses the structured data
   * markup on the website and advanced data extractors to update the price and availability of the
   * items. When the item updates are off, items with mismatched data aren't shown. This field is
   * only updated (cleared) if provided.
   * @return value or {@code null} for none
   */
  public AccountItemUpdates getItemUpdates() {
    return itemUpdates;
  }

  /**
   * Turning on [item updates](https://support.google.com/merchants/answer/3246284) allows Google to
   * automatically update items for you. When item updates are on, Google uses the structured data
   * markup on the website and advanced data extractors to update the price and availability of the
   * items. When the item updates are off, items with mismatched data aren't shown. This field is
   * only updated (cleared) if provided.
   * @param itemUpdates itemUpdates or {@code null} for none
   */
  public AccountAutomaticImprovements setItemUpdates(AccountItemUpdates itemUpdates) {
    this.itemUpdates = itemUpdates;
    return this;
  }

  /**
   * Not available for MCAs [accounts](https://support.google.com/merchants/answer/188487). By
   * turning on [automatic shipping
   * improvements](https://support.google.com/merchants/answer/10027038), you are allowing Google to
   * improve the accuracy of your delivery times shown to shoppers using Google. More accurate
   * delivery times, especially when faster, typically lead to better conversion rates. Google will
   * improve your estimated delivery times based on various factors: - Delivery address of an order
   * - Current handling time and shipping time settings - Estimated weekdays or business days -
   * Parcel tracking data This field is only updated (cleared) if provided.
   * @return value or {@code null} for none
   */
  public AccountShippingImprovements getShippingImprovements() {
    return shippingImprovements;
  }

  /**
   * Not available for MCAs [accounts](https://support.google.com/merchants/answer/188487). By
   * turning on [automatic shipping
   * improvements](https://support.google.com/merchants/answer/10027038), you are allowing Google to
   * improve the accuracy of your delivery times shown to shoppers using Google. More accurate
   * delivery times, especially when faster, typically lead to better conversion rates. Google will
   * improve your estimated delivery times based on various factors: - Delivery address of an order
   * - Current handling time and shipping time settings - Estimated weekdays or business days -
   * Parcel tracking data This field is only updated (cleared) if provided.
   * @param shippingImprovements shippingImprovements or {@code null} for none
   */
  public AccountAutomaticImprovements setShippingImprovements(AccountShippingImprovements shippingImprovements) {
    this.shippingImprovements = shippingImprovements;
    return this;
  }

  @Override
  public AccountAutomaticImprovements set(String fieldName, Object value) {
    return (AccountAutomaticImprovements) super.set(fieldName, value);
  }

  @Override
  public AccountAutomaticImprovements clone() {
    return (AccountAutomaticImprovements) super.clone();
  }

}
