/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * The [business identity attributes](https://support.google.com/merchants/answer/10342414) can be
 * used to self-declare attributes that let customers know more about your business.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountBusinessIdentity extends com.google.api.client.json.GenericJson {

  /**
   * Specifies whether the business identifies itself as being black-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountIdentityType blackOwned;

  /**
   * Required. By setting this field, your business may be included in promotions for all the
   * selected attributes. If you clear this option, it won't affect your identification with any of
   * the attributes. For this field to be set, the merchant must self identify with at least one of
   * the `AccountIdentityType`. If none are included, the request will be considered invalid.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean includeForPromotions;

  /**
   * Specifies whether the business identifies itself as being latino-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountIdentityType latinoOwned;

  /**
   * Specifies whether the business identifies itself as a small business. This optional field is
   * only available for merchants with a business country set to "US". It is also not allowed for
   * marketplaces, but it is allowed to marketplace sellers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountIdentityType smallBusiness;

  /**
   * Specifies whether the business identifies itself as being veteran-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountIdentityType veteranOwned;

  /**
   * Specifies whether the business identifies itself as being women-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountIdentityType womenOwned;

  /**
   * Specifies whether the business identifies itself as being black-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * @return value or {@code null} for none
   */
  public AccountIdentityType getBlackOwned() {
    return blackOwned;
  }

  /**
   * Specifies whether the business identifies itself as being black-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * @param blackOwned blackOwned or {@code null} for none
   */
  public AccountBusinessIdentity setBlackOwned(AccountIdentityType blackOwned) {
    this.blackOwned = blackOwned;
    return this;
  }

  /**
   * Required. By setting this field, your business may be included in promotions for all the
   * selected attributes. If you clear this option, it won't affect your identification with any of
   * the attributes. For this field to be set, the merchant must self identify with at least one of
   * the `AccountIdentityType`. If none are included, the request will be considered invalid.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIncludeForPromotions() {
    return includeForPromotions;
  }

  /**
   * Required. By setting this field, your business may be included in promotions for all the
   * selected attributes. If you clear this option, it won't affect your identification with any of
   * the attributes. For this field to be set, the merchant must self identify with at least one of
   * the `AccountIdentityType`. If none are included, the request will be considered invalid.
   * @param includeForPromotions includeForPromotions or {@code null} for none
   */
  public AccountBusinessIdentity setIncludeForPromotions(java.lang.Boolean includeForPromotions) {
    this.includeForPromotions = includeForPromotions;
    return this;
  }

  /**
   * Specifies whether the business identifies itself as being latino-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * @return value or {@code null} for none
   */
  public AccountIdentityType getLatinoOwned() {
    return latinoOwned;
  }

  /**
   * Specifies whether the business identifies itself as being latino-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * @param latinoOwned latinoOwned or {@code null} for none
   */
  public AccountBusinessIdentity setLatinoOwned(AccountIdentityType latinoOwned) {
    this.latinoOwned = latinoOwned;
    return this;
  }

  /**
   * Specifies whether the business identifies itself as a small business. This optional field is
   * only available for merchants with a business country set to "US". It is also not allowed for
   * marketplaces, but it is allowed to marketplace sellers.
   * @return value or {@code null} for none
   */
  public AccountIdentityType getSmallBusiness() {
    return smallBusiness;
  }

  /**
   * Specifies whether the business identifies itself as a small business. This optional field is
   * only available for merchants with a business country set to "US". It is also not allowed for
   * marketplaces, but it is allowed to marketplace sellers.
   * @param smallBusiness smallBusiness or {@code null} for none
   */
  public AccountBusinessIdentity setSmallBusiness(AccountIdentityType smallBusiness) {
    this.smallBusiness = smallBusiness;
    return this;
  }

  /**
   * Specifies whether the business identifies itself as being veteran-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * @return value or {@code null} for none
   */
  public AccountIdentityType getVeteranOwned() {
    return veteranOwned;
  }

  /**
   * Specifies whether the business identifies itself as being veteran-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * @param veteranOwned veteranOwned or {@code null} for none
   */
  public AccountBusinessIdentity setVeteranOwned(AccountIdentityType veteranOwned) {
    this.veteranOwned = veteranOwned;
    return this;
  }

  /**
   * Specifies whether the business identifies itself as being women-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * @return value or {@code null} for none
   */
  public AccountIdentityType getWomenOwned() {
    return womenOwned;
  }

  /**
   * Specifies whether the business identifies itself as being women-owned. This optional field is
   * only available for merchants with a business country set to "US". This field is not allowed for
   * marketplaces or marketplace sellers.
   * @param womenOwned womenOwned or {@code null} for none
   */
  public AccountBusinessIdentity setWomenOwned(AccountIdentityType womenOwned) {
    this.womenOwned = womenOwned;
    return this;
  }

  @Override
  public AccountBusinessIdentity set(String fieldName, Object value) {
    return (AccountBusinessIdentity) super.set(fieldName, value);
  }

  @Override
  public AccountBusinessIdentity clone() {
    return (AccountBusinessIdentity) super.clone();
  }

}
