/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.content.model;

/**
 * Settings for conversion tracking.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Content API for Shopping. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccountConversionSettings extends com.google.api.client.json.GenericJson {

  /**
   * When enabled, free listing URLs have a parameter to enable conversion tracking for products
   * owned by the current merchant account. See [auto-
   * tagging](https://support.google.com/merchants/answer/11127659).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean freeListingsAutoTaggingEnabled;

  /**
   * When enabled, free listing URLs have a parameter to enable conversion tracking for products
   * owned by the current merchant account. See [auto-
   * tagging](https://support.google.com/merchants/answer/11127659).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFreeListingsAutoTaggingEnabled() {
    return freeListingsAutoTaggingEnabled;
  }

  /**
   * When enabled, free listing URLs have a parameter to enable conversion tracking for products
   * owned by the current merchant account. See [auto-
   * tagging](https://support.google.com/merchants/answer/11127659).
   * @param freeListingsAutoTaggingEnabled freeListingsAutoTaggingEnabled or {@code null} for none
   */
  public AccountConversionSettings setFreeListingsAutoTaggingEnabled(java.lang.Boolean freeListingsAutoTaggingEnabled) {
    this.freeListingsAutoTaggingEnabled = freeListingsAutoTaggingEnabled;
    return this;
  }

  @Override
  public AccountConversionSettings set(String fieldName, Object value) {
    return (AccountConversionSettings) super.set(fieldName, value);
  }

  @Override
  public AccountConversionSettings clone() {
    return (AccountConversionSettings) super.clone();
  }

}
